/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.tools.build.bundletool.commands.CheckTransparencyCommand;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.transparency.BundleTransparencyCheckUtils;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public final class BundleModeTransparencyChecker {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TransparencyCheckResult checkTransparency(CheckTransparencyCommand command) {
        try (ZipFile bundleZip = new ZipFile(command.getBundlePath().get().toFile());){
            AppBundle inputBundle = AppBundle.buildFromZip(bundleZip);
            TransparencyCheckResult transparencyCheckResult = BundleTransparencyCheckUtils.checkTransparency(inputBundle);
            return transparencyCheckResult;
        }
        catch (ZipException e11) {
            throw InvalidBundleException.builder().withCause(e11).withUserMessage("The App Bundle is not a valid zip file.").build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException("An error occurred when processing the App Bundle.", e12);
        }
    }

    private BundleModeTransparencyChecker() {
    }
}

