/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.TargetingDimensionMatcher;
import com.android.tools.build.bundletool.model.exceptions.InvalidDeviceSpecException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.protobuf.Int32Value;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeviceTierApkMatcher
extends TargetingDimensionMatcher<Targeting.DeviceTierTargeting> {
    public DeviceTierApkMatcher(Devices.DeviceSpec deviceSpec) {
        super(deviceSpec);
    }

    @Override
    protected Targeting.DeviceTierTargeting getTargetingValue(Targeting.ApkTargeting apkTargeting) {
        return apkTargeting.getDeviceTierTargeting();
    }

    @Override
    protected Targeting.DeviceTierTargeting getTargetingValue(Targeting.VariantTargeting variantTargeting) {
        return Targeting.DeviceTierTargeting.getDefaultInstance();
    }

    @Override
    public boolean matchesTargeting(Targeting.DeviceTierTargeting targeting) {
        if (targeting.equals(Targeting.DeviceTierTargeting.getDefaultInstance())) {
            return true;
        }
        ImmutableSet values2 = (ImmutableSet)targeting.getValueList().stream().map(Int32Value::getValue).collect(ImmutableSet.toImmutableSet());
        ImmutableSet alternatives = (ImmutableSet)targeting.getAlternativesList().stream().map(Int32Value::getValue).collect(ImmutableSet.toImmutableSet());
        Sets.SetView intersection = Sets.intersection((Set)values2, (Set)alternatives);
        Preconditions.checkArgument((boolean)intersection.isEmpty(), (String)"Expected targeting values and alternatives to be mutually exclusive, but both contain: %s", (Object)intersection);
        if (!this.getDeviceSpec().hasDeviceTier()) {
            throw InvalidDeviceSpecException.builder().withUserMessage("The bundle uses device tier targeting, but no device tier was specified.").build();
        }
        return values2.contains((Object)this.getDeviceSpec().getDeviceTier().getValue());
    }

    @Override
    protected boolean isDeviceDimensionPresent() {
        return this.getDeviceSpec().hasDeviceTier();
    }

    @Override
    protected void checkDeviceCompatibleInternal(Targeting.DeviceTierTargeting targeting) {
        if (targeting.equals(Targeting.DeviceTierTargeting.getDefaultInstance())) {
            return;
        }
        ImmutableSet valuesAndAlternatives = (ImmutableSet)Streams.concat((Stream[])new Stream[]{targeting.getValueList().stream().map(Int32Value::getValue), targeting.getAlternativesList().stream().map(Int32Value::getValue)}).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument((boolean)valuesAndAlternatives.contains((Object)this.getDeviceSpec().getDeviceTier().getValue()), (String)"The specified device tier '%s' does not match any of the available values: %s.", (int)this.getDeviceSpec().getDeviceTier().getValue(), (Object)valuesAndAlternatives.stream().map(i11 -> i11.toString()).collect(Collectors.joining(", ")));
    }
}

