/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.aapt.Resources;
import com.android.bundle.Config;
import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.mergers.AndroidManifestMerger;
import com.android.tools.build.bundletool.mergers.DexMerger;
import com.android.tools.build.bundletool.mergers.MergingUtils;
import com.android.tools.build.bundletool.mergers.ResourceTableMerger;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public class ModuleSplitsToShardMerger {
    private final Version bundletoolVersion;
    private final TempDirectory globalTempDir;
    private final DexMerger dexMerger;
    private final AppBundle appBundle;

    @Inject
    public ModuleSplitsToShardMerger(Version bundletoolVersion, TempDirectory globalTempDir, DexMerger dexMerger, AppBundle appBundle) {
        this.bundletoolVersion = bundletoolVersion;
        this.globalTempDir = globalTempDir;
        this.dexMerger = dexMerger;
        this.appBundle = appBundle;
    }

    public ModuleSplit mergeSingleShard(ImmutableCollection<ModuleSplit> splitsOfShard, Map<ImmutableSet<ModuleEntry>, ImmutableList<Path>> mergedDexCache) {
        return this.mergeSingleShard(splitsOfShard, mergedDexCache, ModuleSplit.SplitType.STANDALONE, this.createManifestMerger());
    }

    public ModuleSplit mergeSingleShard(ImmutableCollection<ModuleSplit> splitsOfShard, Map<ImmutableSet<ModuleEntry>, ImmutableList<Path>> mergedDexCache, ModuleSplit.SplitType mergedSplitType, AndroidManifestMerger manifestMerger) {
        ArrayListMultimap dexFilesToMergeByModule = ArrayListMultimap.create();
        HashMultimap androidManifestsToMergeByModule = HashMultimap.create();
        HashMap<ZipPath, ModuleEntry> mergedEntriesByPath = new HashMap<ZipPath, ModuleEntry>();
        Optional<Resources.ResourceTable> mergedResourceTable = Optional.empty();
        HashMap<String, Files.TargetedAssetsDirectory> mergedAssetsConfig = new HashMap<String, Files.TargetedAssetsDirectory>();
        Targeting.ApkTargeting mergedSplitTargeting = Targeting.ApkTargeting.getDefaultInstance();
        for (ModuleSplit split : splitsOfShard) {
            mergedResourceTable = this.mergeResourceTables(mergedResourceTable, split);
            mergedSplitTargeting = this.mergeSplitTargetings(mergedSplitTargeting, split);
            androidManifestsToMergeByModule.put((Object)split.getModuleName(), (Object)split.getAndroidManifest());
            for (ModuleEntry entry : split.getEntries()) {
                if (entry.getPath().startsWith(BundleModule.DEX_DIRECTORY)) {
                    dexFilesToMergeByModule.put((Object)split.getModuleName(), (Object)entry);
                    continue;
                }
                ModuleSplitsToShardMerger.mergeEntries(mergedEntriesByPath, split, entry);
            }
            split.getAssetsConfig().ifPresent(assetsConfig -> MergingUtils.mergeTargetedAssetsDirectories(mergedAssetsConfig, assetsConfig.getDirectoryList()));
        }
        AndroidManifest mergedAndroidManifest = manifestMerger.merge((SetMultimap<BundleModuleName, AndroidManifest>)androidManifestsToMergeByModule);
        Collection<ModuleEntry> mergedDexFiles = this.mergeDexFilesAndCache((ListMultimap<BundleModuleName, ModuleEntry>)dexFilesToMergeByModule, mergedAndroidManifest, mergedDexCache);
        ImmutableList<String> fusedModuleNames = ModuleSplitsToShardMerger.getUniqueModuleNames(splitsOfShard);
        if (mergedSplitType.equals((Object)ModuleSplit.SplitType.STANDALONE)) {
            mergedAndroidManifest = mergedAndroidManifest.toEditor().setFusedModuleNames(fusedModuleNames).save();
        }
        return this.buildShard(mergedEntriesByPath.values(), mergedDexFiles, mergedSplitTargeting, mergedAndroidManifest, mergedResourceTable, mergedAssetsConfig, mergedSplitType);
    }

    private AndroidManifestMerger createManifestMerger() {
        if (VersionGuardedFeature.FUSE_APPLICATION_ELEMENTS_FROM_FEATURE_MANIFESTS.enabledForVersion(this.bundletoolVersion)) {
            return AndroidManifestMerger.fusingMergerApplicationElements();
        }
        if (VersionGuardedFeature.FUSE_ACTIVITIES_FROM_FEATURE_MANIFESTS.enabledForVersion(this.bundletoolVersion)) {
            return AndroidManifestMerger.fusingMergerOnlyReplaceActivities();
        }
        return AndroidManifestMerger.useBaseModuleManifestMerger();
    }

    public ImmutableList<ModuleSplit> mergeApex(ImmutableList<ImmutableList<ModuleSplit>> unfusedShards) {
        return (ImmutableList)unfusedShards.stream().map(this::mergeSingleApexShard).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    ModuleSplit mergeSingleApexShard(ImmutableList<ModuleSplit> splitsOfShard) {
        Preconditions.checkState((!splitsOfShard.isEmpty() ? 1 : 0) != 0, (Object)"A shard is made of at least one split.");
        HashMap<ZipPath, ModuleEntry> mergedEntriesByPath = new HashMap<ZipPath, ModuleEntry>();
        Targeting.ApkTargeting splitTargeting = Targeting.ApkTargeting.getDefaultInstance();
        for (ModuleSplit split : splitsOfShard) {
            splitTargeting = splitTargeting.hasMultiAbiTargeting() ? splitTargeting : split.getApkTargeting();
            for (ModuleEntry entry : split.getEntries()) {
                ModuleSplitsToShardMerger.mergeEntries(mergedEntriesByPath, split, entry);
            }
        }
        ModuleSplit shard = this.buildShard(mergedEntriesByPath.values(), (Collection<ModuleEntry>)ImmutableList.of(), splitTargeting, ((ModuleSplit)splitsOfShard.get(0)).getAndroidManifest(), Optional.empty(), new HashMap<String, Files.TargetedAssetsDirectory>(), ModuleSplit.SplitType.STANDALONE);
        return shard.toBuilder().setApexConfig(((ModuleSplit)splitsOfShard.get(0)).getApexConfig().get()).setApexEmbeddedApkConfigs(((ModuleSplit)splitsOfShard.get(0)).getApexEmbeddedApkConfigs()).build();
    }

    private ModuleSplit buildShard(Collection<ModuleEntry> entriesByPath, Collection<ModuleEntry> mergedDexFiles, Targeting.ApkTargeting splitTargeting, AndroidManifest androidManifest, Optional<Resources.ResourceTable> mergedResourceTable, Map<String, Files.TargetedAssetsDirectory> mergedAssetsConfig, ModuleSplit.SplitType mergedSplitType) {
        ImmutableList entries = ImmutableList.builder().addAll(entriesByPath).addAll(mergedDexFiles).build();
        ModuleSplit.Builder shard = ModuleSplit.builder().setAndroidManifest(androidManifest).setEntries((List<ModuleEntry>)entries).setApkTargeting(splitTargeting).setSplitType(mergedSplitType).setMasterSplit(false).setModuleName(BundleModuleName.BASE_MODULE_NAME).setVariantTargeting(Targeting.VariantTargeting.getDefaultInstance());
        mergedResourceTable.ifPresent(shard::setResourceTable);
        if (!mergedAssetsConfig.isEmpty()) {
            shard.setAssetsConfig(Files.Assets.newBuilder().addAllDirectory(mergedAssetsConfig.values()).build());
        }
        return shard.build();
    }

    private Collection<ModuleEntry> mergeDexFilesAndCache(ListMultimap<BundleModuleName, ModuleEntry> dexFilesToMergeByModule, AndroidManifest androidManifest, Map<ImmutableSet<ModuleEntry>, ImmutableList<Path>> mergedDexCache) {
        if (dexFilesToMergeByModule.size() <= 1 || this.appBundle.getFeatureModules().size() <= 1) {
            return dexFilesToMergeByModule.values();
        }
        if (this.getDexMergingStrategy().equals((Object)Config.StandaloneConfig.DexMergingStrategy.NEVER_MERGE) || androidManifest.getEffectiveMinSdkVersion() >= 21) {
            return ModuleSplitsToShardMerger.renameDexFromAllModulesToSingleShard(dexFilesToMergeByModule);
        }
        ImmutableList dexEntries = ImmutableList.copyOf((Collection)dexFilesToMergeByModule.values());
        ImmutableList mergedDexFiles = mergedDexCache.computeIfAbsent((ImmutableSet<ModuleEntry>)ImmutableSet.copyOf((Collection)dexEntries), key -> this.mergeDexFiles((List<ModuleEntry>)dexEntries, androidManifest));
        return (Collection)mergedDexFiles.stream().map(filePath -> ModuleEntry.builder().setPath(BundleModule.DEX_DIRECTORY.resolve(filePath.getFileName().toString())).setContent((Path)filePath).build()).collect(ImmutableList.toImmutableList());
    }

    static ImmutableList<ModuleEntry> renameDexFromAllModulesToSingleShard(Multimap<BundleModuleName, ModuleEntry> dexFilesToMergeByModule) {
        Stream dexFilesFromBase = dexFilesToMergeByModule.get((Object)BundleModuleName.BASE_MODULE_NAME).stream();
        int dexFilesCountInBase = dexFilesToMergeByModule.get((Object)BundleModuleName.BASE_MODULE_NAME).size();
        Stream dexFilesFromNotBase = dexFilesToMergeByModule.keys().stream().distinct().filter(moduleName -> !BundleModuleName.BASE_MODULE_NAME.equals(moduleName)).flatMap(moduleName -> dexFilesToMergeByModule.get(moduleName).stream().sorted(Comparator.comparingInt(ModuleSplitsToShardMerger::getDexIndex)));
        Stream renamedDexFiles = Streams.mapWithIndex(dexFilesFromNotBase, (entry, index) -> entry.toBuilder().setPath(BundleModule.DEX_DIRECTORY.resolve((long)dexFilesCountInBase + index == 0L ? "classes.dex" : String.format("classes%d.dex", (long)dexFilesCountInBase + index + 1L))).build());
        return (ImmutableList)Stream.concat(dexFilesFromBase, renamedDexFiles).collect(ImmutableList.toImmutableList());
    }

    private static int getDexIndex(ModuleEntry entry) {
        String fileName = entry.getPath().getFileName().toString();
        if (!fileName.startsWith("classes") || !fileName.endsWith(".dex")) {
            return -1;
        }
        String index = fileName.substring(7, fileName.length() - 4);
        if (!index.chars().allMatch(Character::isDigit)) {
            return -1;
        }
        return index.isEmpty() ? 1 : Integer.parseInt(index);
    }

    private ImmutableList<Path> mergeDexFiles(List<ModuleEntry> dexEntries, AndroidManifest androidManifest) {
        try {
            Path dexOriginalDir = Files.createTempDirectory(this.globalTempDir.getPath(), "dex-merging-in", new FileAttribute[0]);
            Path dexMergedDir = Files.createTempDirectory(this.globalTempDir.getPath(), "dex-merging-out", new FileAttribute[0]);
            Optional<Path> mainDexListFile = this.writeMainDexListFileIfPresent();
            Optional<Path> proguardMapFile = this.writeProguardMapFileIfPresent();
            ImmutableList<Path> dexFiles = ModuleSplitsToShardMerger.writeModuleEntriesToIndexedFiles(dexEntries, dexOriginalDir, ".dex");
            ImmutableList<Path> mergedDexFiles = this.dexMerger.merge(dexFiles, dexMergedDir, mainDexListFile, proguardMapFile, androidManifest.getEffectiveApplicationDebuggable(), androidManifest.getEffectiveMinSdkVersion());
            return mergedDexFiles;
        }
        catch (IOException e11) {
            throw CommandExecutionException.builder().withCause(e11).withInternalMessage("I/O error while merging dex files.").build();
        }
    }

    private static void mergeEntries(Map<ZipPath, ModuleEntry> mergedEntriesByPath, ModuleSplit split, ModuleEntry entry) {
        ModuleEntry existingEntry = mergedEntriesByPath.putIfAbsent(entry.getPath(), entry);
        Preconditions.checkState((existingEntry == null || existingEntry.equals(entry) ? 1 : 0) != 0, (String)"Module '%s' and some other module(s) contain entry '%s' with different contents.", (Object)split.getModuleName(), (Object)entry.getPath());
    }

    private Optional<Resources.ResourceTable> mergeResourceTables(Optional<Resources.ResourceTable> merged, ModuleSplit split) {
        if (!merged.isPresent()) {
            return split.getResourceTable();
        }
        if (split.getResourceTable().isPresent()) {
            try {
                return Optional.of(new ResourceTableMerger().merge(merged.get(), split.getResourceTable().get()));
            }
            catch (CommandExecutionException | IllegalStateException e11) {
                throw CommandExecutionException.builder().withCause(e11).withInternalMessage("Failed to merge with resource table of module '%s'.", split.getModuleName()).build();
            }
        }
        return merged;
    }

    private Targeting.ApkTargeting mergeSplitTargetings(Targeting.ApkTargeting merged, ModuleSplit split) {
        try {
            return MergingUtils.mergeShardTargetings(merged, split.getApkTargeting());
        }
        catch (CommandExecutionException | IllegalStateException e11) {
            throw CommandExecutionException.builder().withCause(e11).withInternalMessage("Failed to merge with targeting of module '%s'.", split.getModuleName()).build();
        }
    }

    private Optional<Path> writeMainDexListFileIfPresent() throws IOException {
        Optional<ByteSource> mainDexListFile = this.appBundle.getBundleMetadata().getFileAsByteSource("com.android.tools.build.bundletool", "mainDexList.txt");
        if (!mainDexListFile.isPresent()) {
            return Optional.empty();
        }
        Path mainDexListFilePath = Files.createTempFile(this.globalTempDir.getPath(), "mainDexList", ".txt", new FileAttribute[0]);
        try (InputStream inputStream = mainDexListFile.get().openStream();){
            Files.copy(inputStream, mainDexListFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        return Optional.of(mainDexListFilePath);
    }

    private Optional<Path> writeProguardMapFileIfPresent() throws IOException {
        Optional<ByteSource> proguardFile = this.appBundle.getBundleMetadata().getFileAsByteSource("shadow.bundletool.com.android.tools.build.obfuscation", "proguard.map");
        if (!proguardFile.isPresent()) {
            return Optional.empty();
        }
        Path proguardMapFilePath = Files.createTempFile(this.globalTempDir.getPath(), "proguard", ".map", new FileAttribute[0]);
        try (InputStream inputStream = proguardFile.get().openStream();){
            Files.copy(inputStream, proguardMapFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        return Optional.of(proguardMapFilePath);
    }

    private Config.StandaloneConfig.DexMergingStrategy getDexMergingStrategy() {
        return this.appBundle.getBundleConfig().getOptimizations().getStandaloneConfig().getDexMergingStrategy();
    }

    private static ImmutableList<String> getUniqueModuleNames(ImmutableCollection<ModuleSplit> splits) {
        return (ImmutableList)splits.stream().map(ModuleSplit::getModuleName).map(BundleModuleName::getName).distinct().collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<Path> writeModuleEntriesToIndexedFiles(List<ModuleEntry> moduleEntries, Path toDirectory, String fileSuffix) throws IOException {
        ImmutableList.Builder files = ImmutableList.builder();
        for (int i11 = 0; i11 < moduleEntries.size(); ++i11) {
            Path fileName = toDirectory.resolve(i11 + fileSuffix);
            ModuleSplitsToShardMerger.writeModuleEntryToFile(moduleEntries.get(i11), fileName);
            files.add((Object)fileName);
        }
        return files.build();
    }

    private static void writeModuleEntryToFile(ModuleEntry entry, Path toFile) throws IOException {
        try (InputStream is2 = entry.getContent().openStream();){
            Files.copy(is2, toFile, new CopyOption[0]);
        }
    }
}

