/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import java.util.regex.Pattern;

public class DeviceTierUtils {
    private static final Pattern DEVICE_TIER_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");

    public static void validateDeviceTierForAssetsDirectory(String directory, String tierName) {
        if (!DEVICE_TIER_PATTERN.matcher(tierName).matches()) {
            throw InvalidBundleException.builder().withUserMessage("Device tier names should start with a letter and contain only letters, numbers and underscores. Found tier named '%s' for directory '%s'.", tierName, directory).build();
        }
    }

    public static void validateDeviceTierForConditionalModule(String tierName) {
        if (!DEVICE_TIER_PATTERN.matcher(tierName).matches()) {
            throw InvalidBundleException.builder().withUserMessage("Device tier names should start with a letter and contain only letters, numbers and underscores. Found tier named '%s' in '<dist:%s>' element.", tierName, "device-tier").build();
        }
    }

    private DeviceTierUtils() {
    }
}

