/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;

public class DexCompressionSplitter
implements ModuleSplitSplitter {
    @Override
    public ImmutableCollection<ModuleSplit> split(ModuleSplit moduleSplit) {
        ImmutableSet dexEntries = (ImmutableSet)moduleSplit.getEntries().stream().filter(entry -> entry.getPath().startsWith(BundleModule.DEX_DIRECTORY)).collect(ImmutableSet.toImmutableSet());
        if (dexEntries.isEmpty()) {
            return ImmutableList.of((Object)moduleSplit);
        }
        boolean forceUncompressed = DexCompressionSplitter.targetsAtLeastQ(moduleSplit);
        return ImmutableList.of((Object)DexCompressionSplitter.createModuleSplit(moduleSplit, DexCompressionSplitter.mergeAndSetCompression((ImmutableSet<ModuleEntry>)dexEntries, moduleSplit, forceUncompressed)));
    }

    private static ImmutableList<ModuleEntry> mergeAndSetCompression(ImmutableSet<ModuleEntry> dexEntries, ModuleSplit moduleSplit, boolean forceUncompressed) {
        ImmutableSet nonDexEntries = (ImmutableSet)moduleSplit.getEntries().stream().filter(entry -> !dexEntries.contains(entry)).collect(ImmutableSet.toImmutableSet());
        return ImmutableList.builder().addAll((Iterable)dexEntries.stream().map(moduleEntry -> moduleEntry.toBuilder().setForceUncompressed(forceUncompressed).build()).collect(ImmutableList.toImmutableList())).addAll((Iterable)nonDexEntries).build();
    }

    private static boolean targetsAtLeastQ(ModuleSplit moduleSplit) {
        int sdkVersion = ((Targeting.SdkVersion)Iterables.getOnlyElement(moduleSplit.getVariantTargeting().getSdkVersionTargeting().getValueList())).getMin().getValue();
        return sdkVersion >= 29;
    }

    private static ModuleSplit createModuleSplit(ModuleSplit moduleSplit, ImmutableList<ModuleEntry> moduleEntries) {
        return moduleSplit.toBuilder().setEntries((List<ModuleEntry>)moduleEntries).build();
    }
}

