/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler;

import java.io.IOException;
import java.nio.ByteBuffer;
import shadow.bundletool.com.android.ddmlib.ByteBufferUtil;
import shadow.bundletool.com.android.ddmlib.Client;
import shadow.bundletool.com.android.ddmlib.DebugViewDumpHandler;
import shadow.bundletool.com.android.ddmlib.Log;
import shadow.bundletool.com.android.ddmlib.internal.ClientImpl;
import shadow.bundletool.com.android.ddmlib.internal.MonitorThread;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.ChunkHandler;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;

public final class HandleViewDebug
extends ChunkHandler {
    private static final int VURT_DUMP_HIERARCHY = 1;
    private static final int VURT_CAPTURE_LAYERS = 2;
    private static final int VURT_DUMP_THEME = 3;
    private static final int VUOP_CAPTURE_VIEW = 1;
    private static final int VUOP_DUMP_DISPLAYLIST = 2;
    private static final int VUOP_PROFILE_VIEW = 3;
    private static final int VUOP_INVOKE_VIEW_METHOD = 4;
    private static final int VUOP_SET_LAYOUT_PARAMETER = 5;
    private static final String TAG = "ddmlib";
    private static final HandleViewDebug sInstance = new HandleViewDebug();
    private static final DebugViewDumpHandler sViewOpNullChunkHandler = new NullChunkHandler(DebugViewDumpHandler.CHUNK_VUOP);

    private HandleViewDebug() {
    }

    public static void register(MonitorThread mt) {
        mt.registerChunkHandler(DebugViewDumpHandler.CHUNK_VUGL, sInstance);
        mt.registerChunkHandler(DebugViewDumpHandler.CHUNK_VULW, sInstance);
        mt.registerChunkHandler(DebugViewDumpHandler.CHUNK_VUOP, sInstance);
        mt.registerChunkHandler(DebugViewDumpHandler.CHUNK_VURT, sInstance);
    }

    @Override
    public void clientReady(ClientImpl client) throws IOException {
    }

    @Override
    public void clientDisconnected(ClientImpl client) {
    }

    public static void listViewRoots(Client client, DebugViewDumpHandler replyHandler) throws IOException {
        ByteBuffer buf = HandleViewDebug.allocBuffer(8);
        JdwpPacket packet = new JdwpPacket(buf);
        ByteBuffer chunkBuf = HandleViewDebug.getChunkDataBuf(buf);
        chunkBuf.putInt(1);
        HandleViewDebug.finishChunkPacket(packet, DebugViewDumpHandler.CHUNK_VULW, chunkBuf.position());
        ((ClientImpl)client).send(packet, replyHandler);
    }

    public static void dumpViewHierarchy(Client client, String viewRoot, boolean skipChildren, boolean includeProperties, boolean useV2, DebugViewDumpHandler handler) throws IOException {
        ByteBuffer buf = HandleViewDebug.allocBuffer(8 + viewRoot.length() * 2 + 4 + 4 + 4);
        JdwpPacket packet = new JdwpPacket(buf);
        ByteBuffer chunkBuf = HandleViewDebug.getChunkDataBuf(buf);
        chunkBuf.putInt(1);
        chunkBuf.putInt(viewRoot.length());
        ByteBufferUtil.putString(chunkBuf, viewRoot);
        chunkBuf.putInt(skipChildren ? 1 : 0);
        chunkBuf.putInt(includeProperties ? 1 : 0);
        chunkBuf.putInt(useV2 ? 1 : 0);
        HandleViewDebug.finishChunkPacket(packet, DebugViewDumpHandler.CHUNK_VURT, chunkBuf.position());
        ((ClientImpl)client).send(packet, handler);
    }

    public static void captureLayers(ClientImpl client, String viewRoot, DebugViewDumpHandler handler) throws IOException {
        int bufLen = 8 + viewRoot.length() * 2;
        ByteBuffer buf = HandleViewDebug.allocBuffer(bufLen);
        JdwpPacket packet = new JdwpPacket(buf);
        ByteBuffer chunkBuf = HandleViewDebug.getChunkDataBuf(buf);
        chunkBuf.putInt(2);
        chunkBuf.putInt(viewRoot.length());
        ByteBufferUtil.putString(chunkBuf, viewRoot);
        HandleViewDebug.finishChunkPacket(packet, DebugViewDumpHandler.CHUNK_VURT, chunkBuf.position());
        client.send(packet, handler);
    }

    private static void sendViewOpPacket(Client client, int op, String viewRoot, String view, byte[] extra, DebugViewDumpHandler handler) throws IOException {
        int bufLen = 8 + viewRoot.length() * 2 + 4 + view.length() * 2;
        if (extra != null) {
            bufLen += extra.length;
        }
        ByteBuffer buf = HandleViewDebug.allocBuffer(bufLen);
        JdwpPacket packet = new JdwpPacket(buf);
        ByteBuffer chunkBuf = HandleViewDebug.getChunkDataBuf(buf);
        chunkBuf.putInt(op);
        chunkBuf.putInt(viewRoot.length());
        ByteBufferUtil.putString(chunkBuf, viewRoot);
        chunkBuf.putInt(view.length());
        ByteBufferUtil.putString(chunkBuf, view);
        if (extra != null) {
            chunkBuf.put(extra);
        }
        HandleViewDebug.finishChunkPacket(packet, DebugViewDumpHandler.CHUNK_VUOP, chunkBuf.position());
        ((ClientImpl)client).send(packet, handler);
    }

    public static void profileView(ClientImpl client, String viewRoot, String view, DebugViewDumpHandler handler) throws IOException {
        HandleViewDebug.sendViewOpPacket(client, 3, viewRoot, view, null, handler);
    }

    public static void captureView(Client client, String viewRoot, String view, DebugViewDumpHandler handler) throws IOException {
        HandleViewDebug.sendViewOpPacket(client, 1, viewRoot, view, null, handler);
    }

    public static void invalidateView(ClientImpl client, String viewRoot, String view) throws IOException {
        HandleViewDebug.invokeMethod(client, viewRoot, view, "invalidate", new Object[0]);
    }

    public static void requestLayout(ClientImpl client, String viewRoot, String view) throws IOException {
        HandleViewDebug.invokeMethod(client, viewRoot, view, "requestLayout", new Object[0]);
    }

    public static void dumpDisplayList(Client client, String viewRoot, String view) throws IOException {
        HandleViewDebug.sendViewOpPacket(client, 2, viewRoot, view, null, sViewOpNullChunkHandler);
    }

    public static void dumpTheme(ClientImpl client, String viewRoot, DebugViewDumpHandler handler) throws IOException {
        ByteBuffer buf = HandleViewDebug.allocBuffer(8 + viewRoot.length() * 2);
        JdwpPacket packet = new JdwpPacket(buf);
        ByteBuffer chunkBuf = HandleViewDebug.getChunkDataBuf(buf);
        chunkBuf.putInt(3);
        chunkBuf.putInt(viewRoot.length());
        ByteBufferUtil.putString(chunkBuf, viewRoot);
        HandleViewDebug.finishChunkPacket(packet, DebugViewDumpHandler.CHUNK_VURT, chunkBuf.position());
        client.send(packet, handler);
    }

    public static void invokeMethod(ClientImpl client, String viewRoot, String view, String method, Object ... args) throws IOException {
        int len = 4 + method.length() * 2;
        if (args != null) {
            len += 4;
            len += 10 * args.length;
        }
        byte[] extra = new byte[len];
        ByteBuffer b4 = ByteBuffer.wrap(extra);
        b4.putInt(method.length());
        ByteBufferUtil.putString(b4, method);
        if (args != null) {
            b4.putInt(args.length);
            for (int i4 = 0; i4 < args.length; ++i4) {
                Object arg = args[i4];
                if (arg instanceof Boolean) {
                    b4.putChar('Z');
                    b4.put((byte)((Boolean)arg != false ? 1 : 0));
                    continue;
                }
                if (arg instanceof Byte) {
                    b4.putChar('B');
                    b4.put((Byte)arg);
                    continue;
                }
                if (arg instanceof Character) {
                    b4.putChar('C');
                    b4.putChar(((Character)arg).charValue());
                    continue;
                }
                if (arg instanceof Short) {
                    b4.putChar('S');
                    b4.putShort((Short)arg);
                    continue;
                }
                if (arg instanceof Integer) {
                    b4.putChar('I');
                    b4.putInt((Integer)arg);
                    continue;
                }
                if (arg instanceof Long) {
                    b4.putChar('J');
                    b4.putLong((Long)arg);
                    continue;
                }
                if (arg instanceof Float) {
                    b4.putChar('F');
                    b4.putFloat(((Float)arg).floatValue());
                    continue;
                }
                if (arg instanceof Double) {
                    b4.putChar('D');
                    b4.putDouble((Double)arg);
                    continue;
                }
                Log.e(TAG, "View method invocation only supports primitive arguments, supplied: " + arg);
                return;
            }
        }
        HandleViewDebug.sendViewOpPacket(client, 4, viewRoot, view, extra, sViewOpNullChunkHandler);
    }

    public static void setLayoutParameter(ClientImpl client, String viewRoot, String view, String parameter, int value) throws IOException {
        int len = 4 + parameter.length() * 2 + 4;
        byte[] extra = new byte[len];
        ByteBuffer b4 = ByteBuffer.wrap(extra);
        b4.putInt(parameter.length());
        ByteBufferUtil.putString(b4, parameter);
        b4.putInt(value);
        HandleViewDebug.sendViewOpPacket(client, 5, viewRoot, view, extra, sViewOpNullChunkHandler);
    }

    @Override
    public void handleChunk(ClientImpl client, int type, ByteBuffer data, boolean isReply, int msgId) {
    }

    public static void sendStartGlTracing(ClientImpl client) throws IOException {
        ByteBuffer buf = HandleViewDebug.allocBuffer(4);
        JdwpPacket packet = new JdwpPacket(buf);
        ByteBuffer chunkBuf = HandleViewDebug.getChunkDataBuf(buf);
        chunkBuf.putInt(1);
        HandleViewDebug.finishChunkPacket(packet, DebugViewDumpHandler.CHUNK_VUGL, chunkBuf.position());
        client.send(packet, null);
    }

    public static void sendStopGlTracing(ClientImpl client) throws IOException {
        ByteBuffer buf = HandleViewDebug.allocBuffer(4);
        JdwpPacket packet = new JdwpPacket(buf);
        ByteBuffer chunkBuf = HandleViewDebug.getChunkDataBuf(buf);
        chunkBuf.putInt(0);
        HandleViewDebug.finishChunkPacket(packet, DebugViewDumpHandler.CHUNK_VUGL, chunkBuf.position());
        client.send(packet, null);
    }

    private static class NullChunkHandler
    extends DebugViewDumpHandler {
        public NullChunkHandler(int chunkType) {
            super(chunkType);
        }

        @Override
        protected void handleViewDebugResult(ByteBuffer data) {
        }
    }
}

