/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.lang.management.ManagementFactory;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class JvmWideVariable<T> {
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("[^\\s:=,]+");
    private static final ConcurrentMap<String, AtomicReference<Object>> variableTable = JvmWideVariable.createVariableTableIfNotExists();
    private final String fullName;
    private boolean unregistered;

    public JvmWideVariable(String group, String name, String tag, TypeToken<T> typeToken, Supplier<T> initialValueSupplier) {
        String fullName = JvmWideVariable.getFullName(group, name, tag);
        JvmWideVariable.verifyBootstrapLoadedType(typeToken.getType(), fullName);
        this.fullName = fullName;
        this.unregistered = false;
        variableTable.computeIfAbsent(fullName, any -> new AtomicReference(initialValueSupplier.get()));
    }

    public JvmWideVariable(Class<?> definingClass, String name, Class<T> type, T initialValue) {
        this(definingClass.getName(), name, type.getName(), TypeToken.of(type), () -> initialValue);
    }

    public JvmWideVariable(Class<?> definingClass, String name, TypeToken<T> typeToken, Supplier<T> initialValueSupplier) {
        this(definingClass.getName(), name, JvmWideVariable.collectComponentClasses(typeToken.getType()).stream().map(Class::getName).collect(Collectors.joining("-")), typeToken, initialValueSupplier);
    }

    public JvmWideVariable(String group, String name, TypeToken<T> typeToken, Supplier<T> initialValueSupplier) {
        this(group, name, JvmWideVariable.collectComponentClasses(typeToken.getType()).stream().map(Class::getName).collect(Collectors.joining("-")), typeToken, initialValueSupplier);
    }

    @VisibleForTesting
    static String getFullName(String group, String name, String tag) {
        Preconditions.checkArgument((boolean)VALID_NAME_PATTERN.matcher(group).matches());
        Preconditions.checkArgument((boolean)VALID_NAME_PATTERN.matcher(name).matches());
        Preconditions.checkArgument((boolean)VALID_NAME_PATTERN.matcher(tag).matches());
        return group + ":name=" + name + ",tag=" + tag;
    }

    private static void verifyBootstrapLoadedType(Type type, String variable) {
        for (Class<?> clazz : JvmWideVariable.collectComponentClasses(type)) {
            Verify.verify((clazz.getClassLoader() == null ? 1 : 0) != 0, (String)"Type %s used to define JVM-wide variable %s must be loaded by the bootstrap class loader but is loaded by %s", clazz, (Object)variable, (Object)clazz.getClassLoader());
        }
    }

    @VisibleForTesting
    static Collection<Class<?>> collectComponentClasses(Type type) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        JvmWideVariable.doCollectComponentClasses(type, builder);
        return builder.build();
    }

    private static void doCollectComponentClasses(Type type, ImmutableSet.Builder<Class<?>> builder) {
        if (type instanceof Class) {
            builder.add((Object)((Class)type));
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            JvmWideVariable.doCollectComponentClasses(parameterizedType.getRawType(), builder);
            if (parameterizedType.getOwnerType() != null) {
                JvmWideVariable.doCollectComponentClasses(parameterizedType.getOwnerType(), builder);
            }
            for (Type componentType : parameterizedType.getActualTypeArguments()) {
                JvmWideVariable.doCollectComponentClasses(componentType, builder);
            }
        } else if (type instanceof GenericArrayType) {
            JvmWideVariable.doCollectComponentClasses(((GenericArrayType)type).getGenericComponentType(), builder);
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type componentType : wildcardType.getLowerBounds()) {
                JvmWideVariable.doCollectComponentClasses(componentType, builder);
            }
            for (Type componentType : wildcardType.getUpperBounds()) {
                JvmWideVariable.doCollectComponentClasses(componentType, builder);
            }
        } else {
            throw new IllegalArgumentException("Type " + type + " is not yet supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<String, AtomicReference<Object>> createVariableTableIfNotExists() {
        ConcurrentMap variableTable;
        ObjectName objectName;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Type type = new TypeToken<ConcurrentMap<String, AtomicReference<Object>>>(){}.getType();
        String tag = JvmWideVariable.collectComponentClasses(type).stream().map(Class::getName).collect(Collectors.joining("-"));
        try {
            objectName = new ObjectName(JvmWideVariable.getFullName("JvmWideVariable", "variableTable", tag));
        }
        catch (MalformedObjectNameException e4) {
            throw new RuntimeException(e4);
        }
        MBeanServer e4 = server;
        synchronized (e4) {
            if (!server.isRegistered(objectName)) {
                ValueWrapper valueWrapper = new ValueWrapper(new ConcurrentHashMap());
                try {
                    server.registerMBean(valueWrapper, objectName);
                }
                catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e5) {
                    throw new RuntimeException(e5);
                }
            }
        }
        try {
            variableTable = (ConcurrentMap)server.getAttribute(objectName, "Value");
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e6) {
            throw new RuntimeException(e6);
        }
        return (ConcurrentMap)Verify.verifyNotNull((Object)variableTable);
    }

    private AtomicReference<T> getVariable() {
        Verify.verify((!this.unregistered ? 1 : 0) != 0, (String)String.format("This JwmWideVariable instance was used to access JVM-wide variable %s, but has already been unregistered", this.fullName), (Object[])new Object[0]);
        return (AtomicReference)Verify.verifyNotNull((Object)((AtomicReference)variableTable.get(this.fullName)), (String)String.format("JVM-wide variable %s has already been unregistered", this.fullName), (Object[])new Object[0]);
    }

    public T get() {
        return this.getVariable().get();
    }

    public void set(T value) {
        this.getVariable().set(value);
    }

    public <V> V executeCallableSynchronously(Callable<V> action) throws ExecutionException {
        AtomicReference<T> atomicReference = this.getVariable();
        synchronized (atomicReference) {
            try {
                return action.call();
            }
            catch (Exception e4) {
                throw new ExecutionException(e4);
            }
        }
    }

    public <V> V executeSupplierSynchronously(Supplier<V> action) {
        try {
            return (V)this.executeCallableSynchronously(action::get);
        }
        catch (ExecutionException e4) {
            throw new RuntimeException(e4);
        }
    }

    public void executeRunnableSynchronously(Runnable action) {
        this.executeSupplierSynchronously(() -> {
            action.run();
            return null;
        });
    }

    public void unregister() {
        Verify.verify((!this.unregistered ? 1 : 0) != 0, (String)String.format("This JwmWideVariable instance was used to access JVM-wide variable %s, but has already been unregistered", this.fullName), (Object[])new Object[0]);
        Verify.verifyNotNull((Object)((AtomicReference)variableTable.remove(this.fullName)), (String)String.format("JVM-wide variable %s has already been unregistered", this.fullName), (Object[])new Object[0]);
        this.unregistered = true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fullName", (Object)this.fullName).add("unregistered", this.unregistered).toString();
    }

    public static <K, V> V getJvmWideObjectPerKey(Class<?> definingClass, String variableName, TypeToken<K> keyType, TypeToken<V> valueType, K key, Supplier<V> newObjectSupplier) {
        ConcurrentMap keyToObjectMap = (ConcurrentMap)Verify.verifyNotNull((Object)new JvmWideVariable<ConcurrentMap>(definingClass, variableName, new TypeToken<ConcurrentMap<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType), ConcurrentHashMap::new).get());
        return (V)keyToObjectMap.computeIfAbsent(key, any -> Verify.verifyNotNull(newObjectSupplier.get()));
    }

    public static interface ValueWrapperMBean<T> {
        public static final String VALUE_PROPERTY = "Value";

        public T getValue();
    }

    private static final class ValueWrapper<T>
    implements ValueWrapperMBean<T> {
        private final T value;

        public ValueWrapper(T value) {
            this.value = value;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }
}

