/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class SubStream {
    public static final String FN_FOLDER_CONTENT = "__content__.json";
    private final String name;
    private final int index;
    private final String filename;
    private final Set<? super QualifiedContent.Scope> scopes;
    private final Set<QualifiedContent.ContentType> types;
    private final Format format;
    private final boolean present;

    SubStream(String name2, int index, Set<? super QualifiedContent.Scope> scopes2, Set<QualifiedContent.ContentType> types, Format format, boolean present) {
        this.name = name2;
        this.index = index;
        this.scopes = scopes2;
        this.types = types;
        this.format = format;
        this.present = present;
        this.filename = this.computeFilename();
    }

    public String getName() {
        return this.name;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return this.scopes;
    }

    public Set<QualifiedContent.ContentType> getTypes() {
        return this.types;
    }

    public Format getFormat() {
        return this.format;
    }

    public int getIndex() {
        return this.index;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isPresent() {
        return this.present;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<SubStream> loadSubStreams(File rootFolder) {
        File jsonFile = new File(rootFolder, FN_FOLDER_CONTENT);
        if (!jsonFile.isFile()) {
            return ImmutableList.of();
        }
        try (FileReader reader = new FileReader(jsonFile);){
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(SubStream.class, (Object)new SubStreamAdapter());
            Gson gson2 = gsonBuilder.create();
            Type recordType = new TypeToken<List<SubStream>>(){}.getType();
            Collection collection = (Collection)gson2.fromJson((Reader)reader, recordType);
            return collection;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void save(Collection<SubStream> subStreams, File rootFolder) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(SubStream.class, (Object)new SubStreamAdapter());
        Gson gson2 = gsonBuilder.create();
        FileUtils.mkdirs((File)rootFolder);
        Files.asCharSink((File)new File(rootFolder, FN_FOLDER_CONTENT), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)gson2.toJson(subStreams));
    }

    private String computeFilename() {
        if (this.format == Format.DIRECTORY) {
            return Integer.toString(this.index);
        }
        return Integer.toString(this.index) + ".jar";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubStream subStream = (SubStream)o;
        return this.index == subStream.index && this.present == subStream.present && Objects.equals(this.name, subStream.name) && Objects.equals(this.scopes, subStream.scopes) && Objects.equals(this.types, subStream.types) && this.format == subStream.format;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.index, this.scopes, this.types, this.format, this.present);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("index", this.index).add("filename", (Object)this.filename).add("scopes", this.scopes).add("types", this.types).add("format", (Object)this.format).add("present", this.present).toString();
    }

    public SubStream duplicateWithPresent(boolean exists) {
        return new SubStream(this.name, this.index, this.scopes, this.types, this.format, exists);
    }

    private static final class SubStreamAdapter
    extends TypeAdapter<SubStream> {
        private SubStreamAdapter() {
        }

        public void write(JsonWriter out, SubStream value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("name").value(value.getName());
            out.name("index").value((long)value.getIndex());
            out.name("scopes").beginArray();
            Set<? super QualifiedContent.Scope> scopes2 = value.getScopes();
            for (QualifiedContent.Scope scope : scopes2) {
                out.value(scope.toString());
            }
            out.endArray();
            out.name("types").beginArray();
            for (QualifiedContent.ContentType contentType : value.getTypes()) {
                out.value(contentType.toString());
            }
            out.endArray();
            out.name("format").value(value.getFormat().toString());
            out.name("present").value(value.present);
            out.endObject();
        }

        public SubStream read(JsonReader in) throws IOException {
            in.beginObject();
            String name2 = null;
            int index = -1;
            HashSet scopes2 = Sets.newHashSet();
            HashSet types = Sets.newHashSet();
            Format format = null;
            boolean present = false;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "name": {
                        name2 = in.nextString();
                        break;
                    }
                    case "index": {
                        index = in.nextInt();
                        break;
                    }
                    case "scopes": {
                        SubStreamAdapter.readScopes(in, scopes2);
                        break;
                    }
                    case "types": {
                        SubStreamAdapter.readTypes(in, types);
                        break;
                    }
                    case "format": {
                        format = Format.valueOf((String)in.nextString());
                        break;
                    }
                    case "present": {
                        present = in.nextBoolean();
                    }
                }
            }
            in.endObject();
            Preconditions.checkNotNull(name2);
            Preconditions.checkNotNull(format);
            Preconditions.checkState((index >= 0 ? 1 : 0) != 0);
            return new SubStream(name2, index, scopes2, types, format, present);
        }

        private static void readScopes(JsonReader in, Set<QualifiedContent.ScopeType> scopes2) throws IOException {
            in.beginArray();
            while (in.hasNext()) {
                Object scope;
                String scopeName = in.nextString();
                try {
                    scope = QualifiedContent.Scope.valueOf((String)scopeName);
                }
                catch (IllegalArgumentException e) {
                    scope = InternalScope.valueOf(scopeName);
                }
                scopes2.add((QualifiedContent.ScopeType)scope);
            }
            in.endArray();
        }

        private static void readTypes(JsonReader in, Set<QualifiedContent.ContentType> types) throws IOException {
            in.beginArray();
            while (in.hasNext()) {
                Object type;
                String typeName = in.nextString();
                try {
                    type = QualifiedContent.DefaultContentType.valueOf((String)typeName);
                }
                catch (IllegalArgumentException e) {
                    type = ExtendedContentType.valueOf(typeName);
                }
                types.add((QualifiedContent.ContentType)type);
            }
            in.endArray();
        }
    }
}

