/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H&\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "T", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "Lorg/gradle/workers/WorkAction;", "()V", "execute", "", "run", "Parameters", "gradle-core"})
public abstract class ProfileAwareWorkAction<T extends Parameters>
implements WorkAction<T> {
    public final void execute() {
        AnalyticsService analyticsService = (AnalyticsService)((Parameters)this.getParameters()).getAnalyticsService().get();
        Object object = ((Parameters)this.getParameters()).getTaskOwner().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.taskOwner.get()");
        String string = (String)object;
        Object object2 = ((Parameters)this.getParameters()).getWorkerKey().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.workerKey.get()");
        analyticsService.workerStarted(string, (String)object2);
        this.run();
        AnalyticsService analyticsService2 = (AnalyticsService)((Parameters)this.getParameters()).getAnalyticsService().get();
        Object object3 = ((Parameters)this.getParameters()).getTaskOwner().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameters.taskOwner.get()");
        String string2 = (String)object3;
        Object object4 = ((Parameters)this.getParameters()).getWorkerKey().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"parameters.workerKey.get()");
        analyticsService2.workerFinished(string2, (String)object4);
    }

    public abstract void run();

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0000J$\u0010\u0017\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "Lorg/gradle/workers/WorkParameters;", "()V", "analyticsService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "getAnalyticsService", "()Lorg/gradle/api/provider/Property;", "projectName", "", "getProjectName", "taskOwner", "getTaskOwner", "workerKey", "getWorkerKey", "initAllProperties", "", "Lorg/gradle/api/provider/Provider;", "initializeFromAndroidVariantTask", "task", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "initializeFromProfileAwareWorkAction", "workAction", "initializeWith", "gradle-core"})
    public static abstract class Parameters
    implements WorkParameters {
        @NotNull
        public abstract Property<String> getProjectName();

        @NotNull
        public abstract Property<String> getTaskOwner();

        @NotNull
        public abstract Property<String> getWorkerKey();

        @NotNull
        public abstract Property<AnalyticsService> getAnalyticsService();

        public final void initializeFromAndroidVariantTask(@NotNull AndroidVariantTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            String string = task.getProjectName();
            String string2 = task.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"task.path");
            this.initializeWith(string, string2, (Provider<AnalyticsService>)((Provider)task.getAnalyticsService()));
        }

        public final void initializeWith(@NotNull String projectName, @NotNull String taskOwner, @NotNull Provider<AnalyticsService> analyticsService) {
            Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
            Intrinsics.checkParameterIsNotNull((Object)taskOwner, (String)"taskOwner");
            Intrinsics.checkParameterIsNotNull(analyticsService, (String)"analyticsService");
            String workerKeyString = taskOwner + '{' + this.getClass().getName() + this.hashCode();
            this.initAllProperties(projectName, taskOwner, workerKeyString, analyticsService);
        }

        public final void initializeFromProfileAwareWorkAction(@NotNull Parameters workAction) {
            Intrinsics.checkParameterIsNotNull((Object)workAction, (String)"workAction");
            String workerKeyString = (String)workAction.getWorkerKey().get() + this.hashCode();
            Object object = workAction.getProjectName().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"workAction.projectName.get()");
            String string = (String)object;
            Object object2 = workAction.getTaskOwner().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"workAction.taskOwner.get()");
            this.initAllProperties(string, (String)object2, workerKeyString, (Provider<AnalyticsService>)((Provider)workAction.getAnalyticsService()));
        }

        private final void initAllProperties(String projectName, String taskOwner, String workerKey, Provider<AnalyticsService> analyticsService) {
            block0: {
                HasConfigurableValuesKt.setDisallowChanges(this.getProjectName(), projectName);
                HasConfigurableValuesKt.setDisallowChanges(this.getTaskOwner(), taskOwner);
                HasConfigurableValuesKt.setDisallowChanges(this.getWorkerKey(), workerKey);
                HasConfigurableValuesKt.setDisallowChanges(this.getAnalyticsService(), analyticsService);
                TaskProfilingRecord taskProfilingRecord = ((AnalyticsService)this.getAnalyticsService().get()).getTaskRecord(taskOwner);
                if (taskProfilingRecord == null) break block0;
                taskProfilingRecord.addWorker(workerKey, GradleBuildProfileSpan.ExecutionType.WORKER_EXECUTION);
            }
        }
    }
}

