/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.utils.DependencyInfo;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.build.gradle.internal.utils.ViolatingPluginDetector;
import com.android.builder.errors.IssueReporter;
import com.android.ide.common.repository.GradleVersion;
import java.io.Closeable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"AGP_INTERNAL__MIN_PLUGIN_VERSION_CHECK_STARTED", "", "pluginList", "", "Lcom/android/build/gradle/internal/utils/DependencyInfo;", "enforceMinimumVersionOfPlugin", "", "project", "Lorg/gradle/api/Project;", "pluginInfo", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "enforceMinimumVersionsOfPlugins", "getBuildSrcPlugins", "", "classLoader", "Ljava/lang/ClassLoader;", "gradle-core"})
@JvmName(name="GradlePluginUtils")
public final class GradlePluginUtils {
    private static final List<DependencyInfo> pluginList;
    private static final String AGP_INTERNAL__MIN_PLUGIN_VERSION_CHECK_STARTED = "AGP_INTERNAL__MIN_PLUGIN_VERSION_CHECK_STARTED";

    public static final void enforceMinimumVersionsOfPlugins(@NotNull Project project, @NotNull IssueReporter issueReporter2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter2, (String)"issueReporter");
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        ExtensionContainer extensionContainer = project2.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer, (String)"project.rootProject.extensions");
        ExtraPropertiesExtension extraProperties = extensionContainer.getExtraProperties();
        if (extraProperties.has(AGP_INTERNAL__MIN_PLUGIN_VERSION_CHECK_STARTED)) {
            return;
        }
        extraProperties.set(AGP_INTERNAL__MIN_PLUGIN_VERSION_CHECK_STARTED, (Object)true);
        project.getGradle().projectsEvaluated((Action)new Action<Gradle>(issueReporter2){
            final /* synthetic */ IssueReporter $issueReporter;

            public final void execute(Gradle gradle) {
                boolean bl = false;
                Set projectsToCheck = new LinkedHashSet<E>();
                gradle.allprojects((Action)new Action<Project>(projectsToCheck){
                    final /* synthetic */ Set $projectsToCheck;

                    public final void execute(Project it) {
                        Project project = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                        if (project.getPluginManager().hasPlugin("com.android.base")) {
                            for (Project current = it; current != null && this.$projectsToCheck.add(current); current = current.getParent()) {
                            }
                        }
                    }
                    {
                        this.$projectsToCheck = set;
                    }
                });
                gradle.allprojects((Action)new Action<Project>(this, projectsToCheck){
                    final /* synthetic */ enforceMinimumVersionsOfPlugins.1 this$0;
                    final /* synthetic */ Set $projectsToCheck;

                    public final void execute(Project it) {
                        if (this.$projectsToCheck.contains(it)) {
                            for (DependencyInfo pluginToCheck : GradlePluginUtils.access$getPluginList$p()) {
                                Project project = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                                GradlePluginUtils.access$enforceMinimumVersionOfPlugin(project, pluginToCheck, this.this$0.$issueReporter);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$projectsToCheck = set;
                    }
                });
            }
            {
                this.$issueReporter = issueReporter2;
            }
        });
    }

    private static final void enforceMinimumVersionOfPlugin(Project project, DependencyInfo pluginInfo, IssueReporter issueReporter2) {
        Configuration buildScriptClasspath;
        ScriptHandler scriptHandler = project.getBuildscript();
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
        Configuration configuration2 = buildScriptClasspath = scriptHandler.getConfigurations().getByName("classpath");
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"buildScriptClasspath");
        ResolvableDependencies resolvableDependencies = configuration2.getIncoming();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"buildScriptClasspath.incoming");
        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionResult, (String)"buildScriptClasspath.incoming.resolutionResult");
        String string = project.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.displayName");
        List<String> pathsToViolatingPlugins = new ViolatingPluginDetector(resolutionResult, pluginInfo, string).detect();
        Collection collection = pathsToViolatingPlugins;
        boolean bl = false;
        if (!collection.isEmpty()) {
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.THIRD_PARTY_GRADLE_PLUGIN_TOO_OLD, (String)("The Android Gradle plugin supports only " + pluginInfo.getDisplayName() + " Gradle plugin" + " version " + pluginInfo.getMinimumVersion() + " and higher.\n" + "The following dependencies do not satisfy the required version:\n" + CollectionsKt.joinToString$default((Iterable)pathsToViolatingPlugins, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), (String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new Object[]{pluginInfo.getDisplayName(), pluginInfo.getDependencyGroup(), pluginInfo.getDependencyName(), pluginInfo.getMinimumVersion(), CollectionsKt.joinToString$default((Iterable)pathsToViolatingPlugins, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null)}), (CharSequence)";", null, null, (int)0, null, null, (int)62, null), null, (int)8, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Set<String> getBuildSrcPlugins(@NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        Pattern pattern = Pattern.compile("META-INF/gradle-plugins/(.+)\\.properties");
        Enumeration<URL> urls = classLoader.getResources("META-INF/gradle-plugins");
        HashSet<String> buildSrcPlugins = new HashSet<String>();
        while (urls.hasMoreElements()) {
            URLConnection urlConnection;
            URL url = urls.nextElement();
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            if (!StringsKt.endsWith$default((String)string, (String)"buildSrc.jar!/META-INF/gradle-plugins", (boolean)false, (int)2, null) || !((urlConnection = url.openConnection()) instanceof JarURLConnection)) continue;
            Closeable closeable = ((JarURLConnection)urlConnection).getJarFile();
            boolean bl = false;
            Throwable throwable = null;
            try {
                JarFile jar = (JarFile)closeable;
                boolean bl2 = false;
                Enumeration<JarEntry> jarEntries = jar.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry entry;
                    JarEntry jarEntry = entry = jarEntries.nextElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jarEntry, (String)"entry");
                    Matcher matcher = pattern.matcher(jarEntry.getName());
                    if (!matcher.matches()) continue;
                    buildSrcPlugins.add(matcher.group(1));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return buildSrcPlugins;
    }

    static {
        Object[] objectArray = new DependencyInfo[4];
        GradleVersion gradleVersion = GradleVersion.parse((String)"9.0.0-rc2");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"GradleVersion.parse(\"9.0.0-rc2\")");
        objectArray[0] = new DependencyInfo("Butterknife", "com.jakewharton", "butterknife-gradle-plugin", gradleVersion);
        GradleVersion gradleVersion2 = GradleVersion.parse((String)"1.28.0");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion2, (String)"GradleVersion.parse(\"1.28.0\")");
        objectArray[1] = new DependencyInfo("Crashlytics", "io.fabric.tools", "gradle", gradleVersion2);
        GradleVersion gradleVersion3 = GradleVersion.parse((String)"0.8.6");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion3, (String)"GradleVersion.parse(\"0.8.6\")");
        objectArray[2] = new DependencyInfo("Protobuf", "com.google.protobuf", "protobuf-gradle-plugin", gradleVersion3);
        GradleVersion gradleVersion4 = GradleVersion.parse((String)"1.3.10");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion4, (String)"GradleVersion.parse(\"1.3.10\")");
        objectArray[3] = new DependencyInfo("Kotlin", "org.jetbrains.kotlin", "kotlin-gradle-plugin", gradleVersion4);
        pluginList = CollectionsKt.listOf((Object[])objectArray);
    }

    public static final /* synthetic */ List access$getPluginList$p() {
        return pluginList;
    }

    public static final /* synthetic */ void access$enforceMinimumVersionOfPlugin(Project project, DependencyInfo pluginInfo, IssueReporter issueReporter2) {
        GradlePluginUtils.enforceMinimumVersionOfPlugin(project, pluginInfo, issueReporter2);
    }
}

