/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import java.awt.Color;
import java.net.URL;

public class HtmlBuilder {
    private final StringBuilder mStringBuilder;
    private String mTableDataExtra;
    private static final boolean USE_DD_LISTS = true;

    public HtmlBuilder(StringBuilder stringBuilder) {
        this.mStringBuilder = stringBuilder;
    }

    public HtmlBuilder() {
        this.mStringBuilder = new StringBuilder(100);
    }

    public HtmlBuilder openHtmlBody() {
        this.addHtml("<html><body>");
        return this;
    }

    public HtmlBuilder closeHtmlBody() {
        this.addHtml("</body></html>");
        return this;
    }

    public HtmlBuilder addHtml(String html) {
        this.mStringBuilder.append(html);
        return this;
    }

    public HtmlBuilder addNbsp() {
        this.mStringBuilder.append("&nbsp;");
        return this;
    }

    public HtmlBuilder addNbsps(int count) {
        for (int i = 0; i < count; ++i) {
            this.addNbsp();
        }
        return this;
    }

    public HtmlBuilder newline() {
        this.mStringBuilder.append("<BR/>");
        return this;
    }

    public HtmlBuilder newlineIfNecessary() {
        if (!SdkUtils.endsWith(this.mStringBuilder, "<BR/>")) {
            this.mStringBuilder.append("<BR/>");
        }
        return this;
    }

    public HtmlBuilder beginNoBr() {
        this.mStringBuilder.append("<NOBR>");
        return this;
    }

    public HtmlBuilder endNoBr() {
        this.mStringBuilder.append("</NOBR>");
        return this;
    }

    public HtmlBuilder addLink(String textBefore, String linkText, String textAfter, String url) {
        if (textBefore != null) {
            this.add(textBefore);
        }
        this.addLink(linkText, url);
        if (textAfter != null) {
            this.add(textAfter);
        }
        return this;
    }

    public HtmlBuilder addLink(String text, String url) {
        char c;
        int begin;
        int length = text.length();
        for (begin = 0; begin < length && Character.isWhitespace(c = text.charAt(begin)); ++begin) {
            this.mStringBuilder.append(c);
        }
        this.mStringBuilder.append("<A HREF=\"");
        this.mStringBuilder.append(url);
        this.mStringBuilder.append("\">");
        XmlUtils.appendXmlTextValue(this.mStringBuilder, text.trim());
        this.mStringBuilder.append("</A>");
        for (int end = length - 1; end > begin; --end) {
            char c2 = text.charAt(begin);
            if (!Character.isWhitespace(c2)) continue;
            this.mStringBuilder.append(c2);
        }
        return this;
    }

    public HtmlBuilder add(String text) {
        XmlUtils.appendXmlTextValue(this.mStringBuilder, text);
        return this;
    }

    public HtmlBuilder add(String text, int start, int end) {
        XmlUtils.appendXmlTextValue(this.mStringBuilder, text, start, end);
        return this;
    }

    public String getHtml() {
        return this.mStringBuilder.toString();
    }

    public HtmlBuilder beginBold() {
        this.mStringBuilder.append("<B>");
        return this;
    }

    public HtmlBuilder endBold() {
        this.mStringBuilder.append("</B>");
        return this;
    }

    public HtmlBuilder beginUnderline() {
        this.mStringBuilder.append("<U>");
        return this;
    }

    public HtmlBuilder endUnderline() {
        this.mStringBuilder.append("</U>");
        return this;
    }

    public HtmlBuilder coloredText(Color color, String text) {
        this.beginColor(color);
        this.add(text);
        this.endColor();
        return this;
    }

    public HtmlBuilder beginColor(Color color) {
        this.mStringBuilder.append("<FONT color=\"#");
        String R = Integer.toHexString(color.getRed());
        String G = Integer.toHexString(color.getGreen());
        String B = Integer.toHexString(color.getBlue());
        this.mStringBuilder.append(R.length() < 2 ? "0" : "").append(R).append(G.length() < 2 ? "0" : "").append(G).append(B.length() < 2 ? "0" : "").append(B);
        this.mStringBuilder.append("\">");
        return this;
    }

    public HtmlBuilder endColor() {
        this.mStringBuilder.append("</FONT>");
        return this;
    }

    public HtmlBuilder addUnderlined(String text) {
        this.beginUnderline();
        this.add(text);
        this.endUnderline();
        return this;
    }

    public HtmlBuilder addBold(String text) {
        this.beginBold();
        this.add(text);
        this.endBold();
        return this;
    }

    public HtmlBuilder beginItalic() {
        this.mStringBuilder.append("<I>");
        return this;
    }

    public HtmlBuilder endItalic() {
        this.mStringBuilder.append("</I>");
        return this;
    }

    public HtmlBuilder addItalic(String text) {
        this.beginItalic();
        this.add(text);
        this.endItalic();
        return this;
    }

    private HtmlBuilder appendStyle(String cssStyle) {
        if (cssStyle != null) {
            this.mStringBuilder.append(" style=\"");
            this.mStringBuilder.append(cssStyle);
            this.mStringBuilder.append("\"");
        }
        return this;
    }

    public HtmlBuilder beginDiv() {
        return this.beginDiv(null);
    }

    public HtmlBuilder beginDiv(String cssStyle) {
        this.mStringBuilder.append("<div");
        this.appendStyle(cssStyle);
        this.mStringBuilder.append('>');
        return this;
    }

    public HtmlBuilder endDiv() {
        this.mStringBuilder.append("</div>");
        return this;
    }

    public HtmlBuilder beginSpan() {
        return this.beginSpan(null);
    }

    public HtmlBuilder beginSpan(String cssStyle) {
        this.mStringBuilder.append("<span");
        this.appendStyle(cssStyle);
        this.mStringBuilder.append('>');
        return this;
    }

    public HtmlBuilder beginClassSpan(String cssClasses) {
        this.mStringBuilder.append("<span class=\"");
        this.mStringBuilder.append(cssClasses);
        this.mStringBuilder.append("\">");
        return this;
    }

    public HtmlBuilder beginPre(String styleClass) {
        this.mStringBuilder.append("<pre");
        if (styleClass != null) {
            this.mStringBuilder.append(" class=\"");
            this.mStringBuilder.append(styleClass);
            this.mStringBuilder.append("\"");
        }
        this.mStringBuilder.append(">\n");
        return this;
    }

    public HtmlBuilder endPre() {
        this.mStringBuilder.append("</pre>\n");
        return this;
    }

    public HtmlBuilder endSpan() {
        this.mStringBuilder.append("</span>");
        return this;
    }

    public HtmlBuilder addHeading(String text, String fontColor) {
        this.mStringBuilder.append("<font");
        this.appendStyle("font-weight:bold; color:" + fontColor + ";");
        this.mStringBuilder.append(">");
        this.add(text);
        this.mStringBuilder.append("</font>");
        return this;
    }

    public HtmlBuilder beginList() {
        this.mStringBuilder.append("<DL>");
        return this;
    }

    public HtmlBuilder endList() {
        this.mStringBuilder.append("</DL>");
        return this;
    }

    public HtmlBuilder listItem() {
        this.mStringBuilder.append("<DD>");
        this.mStringBuilder.append("-&NBSP;");
        return this;
    }

    public HtmlBuilder addImage(URL url, String altText) {
        String link = "";
        try {
            link = url.toURI().toURL().toExternalForm();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mStringBuilder.append("<img src='");
        this.mStringBuilder.append(link);
        this.mStringBuilder.append("'");
        if (altText != null) {
            this.mStringBuilder.append(" alt=\"");
            this.mStringBuilder.append(altText);
            this.mStringBuilder.append("\"");
        }
        this.mStringBuilder.append(" />");
        return this;
    }

    public HtmlBuilder addIcon(String src) {
        if (src != null) {
            this.mStringBuilder.append("<img src='");
            this.mStringBuilder.append(src);
            this.mStringBuilder.append("' width=16 height=16 border=0 />");
        }
        return this;
    }

    public HtmlBuilder beginTable(String tdExtra) {
        this.mStringBuilder.append("<table>");
        this.mTableDataExtra = tdExtra;
        return this;
    }

    public HtmlBuilder beginTable() {
        return this.beginTable(null);
    }

    public HtmlBuilder endTable() {
        this.mStringBuilder.append("</table>");
        return this;
    }

    public HtmlBuilder beginTableRow() {
        this.mStringBuilder.append("<tr>");
        return this;
    }

    public HtmlBuilder endTableRow() {
        this.mStringBuilder.append("</tr>");
        return this;
    }

    public HtmlBuilder addTableRow(boolean isHeader, String ... columns) {
        if (columns == null || columns.length == 0) {
            return this;
        }
        String tag = "t" + (isHeader ? (char)'h' : 'd');
        this.beginTableRow();
        for (String c : columns) {
            this.mStringBuilder.append('<');
            this.mStringBuilder.append(tag);
            if (this.mTableDataExtra != null) {
                this.mStringBuilder.append(' ');
                this.mStringBuilder.append(this.mTableDataExtra);
            }
            this.mStringBuilder.append('>');
            this.mStringBuilder.append(c);
            this.mStringBuilder.append("</");
            this.mStringBuilder.append(tag);
            this.mStringBuilder.append('>');
        }
        this.endTableRow();
        return this;
    }

    public HtmlBuilder addTableRow(String ... columns) {
        return this.addTableRow(false, columns);
    }

    public StringBuilder getStringBuilder() {
        return this.mStringBuilder;
    }
}

