/*
 * Decompiled with CFR 0.152.
 */
package com.android.xml;

public final class XmlBuilder {
    private final StringBuilder stringBuilder = new StringBuilder();
    private Construct lastAppendedConstruct = Construct.NULL;
    private int indentationLevel;

    public XmlBuilder startTag(String name) {
        int length;
        if (!this.lastAppendedConstruct.equals((Object)Construct.END_TAG) && (length = this.stringBuilder.length()) > 0) {
            this.stringBuilder.replace(length - 1, length, ">\n");
        }
        if (this.indentationLevel != 0) {
            this.stringBuilder.append('\n');
        }
        this.indent();
        this.stringBuilder.append('<').append(name).append('\n');
        ++this.indentationLevel;
        this.lastAppendedConstruct = Construct.START_TAG;
        return this;
    }

    public XmlBuilder androidAttribute(String name, boolean value) {
        return this.androidAttribute(name, Boolean.toString(value));
    }

    public XmlBuilder androidAttribute(String name, int value) {
        return this.androidAttribute(name, Integer.toString(value));
    }

    public XmlBuilder androidAttribute(String name, String value) {
        return this.attribute("android", name, value);
    }

    public XmlBuilder attribute(String name, String value) {
        return this.attribute("", name, value);
    }

    public XmlBuilder attribute(String namespacePrefix, String name, String value) {
        this.indent();
        if (!namespacePrefix.isEmpty()) {
            this.stringBuilder.append(namespacePrefix).append(':');
        }
        this.stringBuilder.append(name).append("=\"").append(value).append("\"\n");
        this.lastAppendedConstruct = Construct.ATTRIBUTE;
        return this;
    }

    public XmlBuilder characterData(String data) {
        if (this.lastAppendedConstruct.equals((Object)Construct.START_TAG) || this.lastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) {
            int length = this.stringBuilder.length();
            this.stringBuilder.replace(length - 1, length, ">\n");
        }
        this.indent();
        this.stringBuilder.append(data).append('\n');
        this.lastAppendedConstruct = Construct.CHARACTER_DATA;
        return this;
    }

    public XmlBuilder endTag(String name) {
        return this.endTagImpl(name, !name.endsWith("Layout") && !name.equals("PreferenceCategory"));
    }

    public XmlBuilder seperateEndTag(String name) {
        return this.endTagImpl(name, false);
    }

    private XmlBuilder endTagImpl(String name, boolean useEmptyElementTag) {
        if (this.lastAppendedConstruct.equals((Object)Construct.START_TAG) || this.lastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) {
            int length = this.stringBuilder.length();
            if (useEmptyElementTag) {
                this.stringBuilder.deleteCharAt(length - 1);
            } else {
                this.stringBuilder.replace(length - 1, length, ">\n\n");
            }
        }
        --this.indentationLevel;
        if ((this.lastAppendedConstruct.equals((Object)Construct.START_TAG) || this.lastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) && useEmptyElementTag) {
            this.stringBuilder.append(" />\n");
        } else {
            this.indent();
            this.stringBuilder.append("</").append(name).append(">\n");
        }
        this.lastAppendedConstruct = Construct.END_TAG;
        return this;
    }

    private void indent() {
        for (int i = 0; i < this.indentationLevel; ++i) {
            this.stringBuilder.append("    ");
        }
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    private static enum Construct {
        NULL,
        START_TAG,
        ATTRIBUTE,
        CHARACTER_DATA,
        END_TAG;

    }
}

