/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.SdkConstants;
import com.android.utils.StringHelperPOSIX;
import com.android.utils.StringHelperWindows;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010\u001c\n\u0002\b\u0004\u001a.\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000b\u001a:\u0010\u0005\u001a\u00020\f\"\u0004\b\u0000\u0010\u00072\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000b\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a%\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\u001a\u0010\u0019\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u0006\u001a#\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0016\"\u00020\u0006\u00a2\u0006\u0002\u0010\u001d\u001a\u0012\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u001a\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006\u001a\u001a\u0010\u001b\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u0006\u001a\n\u0010 \u001a\u00020\u0006*\u00020\u0006\u001a\u0012\u0010!\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006\u001a\u0010\u0010\u0005\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00060#\u001a\n\u0010$\u001a\u00020\u0006*\u00020\u0006\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014*\u00020\u0006\u001a\u0010\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014*\u00020\u0006\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"CR", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "LF", "Ljava/util/regex/Pattern;", "combineAsCamelCase", "", "T", "objectList", "", "mapFunction", "Ljava/util/function/Function;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toLineSeparator", "separator", "input", "toStrings", "", "objects", "", "", "([Ljava/lang/Object;)Ljava/util/List;", "appendCamelCase", "word", "appendCapitalized", "words", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "word1", "word2", "capitalize", "capitalizeAndAppend", "suffix", "", "toSystemLineSeparator", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "common"})
@JvmName(name="StringHelper")
public final class StringHelper {
    private static final CharMatcher CR = CharMatcher.is((char)'\r');
    private static final Pattern LF = Pattern.compile("\n", 16);

    @NotNull
    public static final StringBuilder appendCapitalized(@NotNull StringBuilder $receiver, @NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        CharSequence charSequence = word;
        if (charSequence.length() == 0) {
            return $receiver;
        }
        int c = word.charAt(0);
        if (c >= 55296 && c <= 56319) {
            String string = word;
            int n = 0;
            c = string.codePointAt(n);
            int charCount = Character.charCount(c);
            String string2 = word;
            int n2 = 0;
            String string3 = string2.substring(n2, charCount);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = string3;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string4 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toUpperCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase(locale)");
            String upperString = string5;
            $receiver.append(upperString);
            $receiver.append(word, charCount, word.length());
        } else {
            char c2;
            int result = Character.toUpperCase(c);
            if (result != -1) {
                c2 = (char)result;
            } else {
                String string = word;
                int n = 0;
                int n3 = 1;
                String string6 = string.substring(n, n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = string6;
                Locale locale = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
                Locale locale3 = locale;
                String string7 = string;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.toUpperCase(locale3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toUpperCase(locale)");
                c2 = string8.charAt(0);
            }
            char upperChar = c2;
            $receiver.append(upperChar);
            $receiver.append(word, 1, word.length());
        }
        return $receiver;
    }

    @NotNull
    public static final String capitalize(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder sb = new StringBuilder($receiver.length());
        StringHelper.appendCapitalized(sb, $receiver);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $receiver, @NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        StringBuilder sb = new StringBuilder($receiver.length() + word.length());
        sb.append($receiver);
        StringHelper.appendCapitalized(sb, word);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $receiver, @NotNull String word1, @NotNull String word2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)word1, (String)"word1");
        Intrinsics.checkParameterIsNotNull((Object)word2, (String)"word2");
        StringBuilder sb = new StringBuilder($receiver.length() + word1.length() + word2.length());
        sb.append($receiver);
        StringHelper.appendCapitalized(sb, word1);
        StringHelper.appendCapitalized(sb, word2);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $receiver, String ... words) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)words, (String)"words");
        int length = $receiver.length();
        int max = words.length;
        for (int i = 0; i < max; ++i) {
            length += words[i].length();
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append($receiver);
        for (String word : words) {
            StringHelper.appendCapitalized(sb, word);
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String capitalizeAndAppend(@NotNull String $receiver, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        StringBuilder sb = new StringBuilder($receiver.length() + suffix.length());
        StringHelper.appendCapitalized(sb, $receiver);
        sb.append(suffix);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final StringBuilder appendCamelCase(@NotNull StringBuilder $receiver, @NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        CharSequence charSequence = $receiver;
        if (charSequence.length() == 0) {
            $receiver.append(word);
        } else {
            StringHelper.appendCapitalized($receiver, word);
        }
        return $receiver;
    }

    @NotNull
    public static final String combineAsCamelCase(@NotNull Iterable<String> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        int count = 0;
        for (String s : $receiver) {
            count += s.length();
        }
        StringBuilder sb = new StringBuilder(count);
        boolean first = true;
        for (String str : $receiver) {
            if (first) {
                sb.append(str);
                first = false;
                continue;
            }
            StringHelper.appendCapitalized(sb, str);
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final <T> String combineAsCamelCase(@NotNull Collection<? extends T> objectList, @NotNull Function<T, String> mapFunction) {
        Intrinsics.checkParameterIsNotNull(objectList, (String)"objectList");
        Intrinsics.checkParameterIsNotNull(mapFunction, (String)"mapFunction");
        StringBuilder sb = new StringBuilder(objectList.size() * 20);
        StringHelper.combineAsCamelCase(sb, objectList, mapFunction);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public static final <T> void combineAsCamelCase(@NotNull StringBuilder sb, @NotNull Collection<? extends T> objectList, @NotNull Function<T, String> mapFunction) {
        Intrinsics.checkParameterIsNotNull((Object)sb, (String)"sb");
        Intrinsics.checkParameterIsNotNull(objectList, (String)"objectList");
        Intrinsics.checkParameterIsNotNull(mapFunction, (String)"mapFunction");
        boolean first = true;
        for (T object : objectList) {
            if (first) {
                sb.append(mapFunction.apply(object));
                first = false;
                continue;
            }
            String string = mapFunction.apply(object);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mapFunction.apply(`object`)");
            StringHelper.appendCapitalized(sb, string);
        }
    }

    @NotNull
    public static final List<String> toStrings(Object ... objects) {
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object path : objects) {
            if (path instanceof String) {
                builder.add(path);
                continue;
            }
            if (path instanceof Collection) {
                for (Object item : (Collection)path) {
                    if (item instanceof String) {
                        builder.add(item);
                        continue;
                    }
                    builder.add((Object)path.toString());
                }
                continue;
            }
            builder.add((Object)path.toString());
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return (List)immutableList;
    }

    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String $receiver) {
        List<String> list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (SdkConstants.currentPlatform() == 2) {
            List<String> list2 = StringHelperWindows.tokenizeCommandLineToEscaped($receiver);
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"StringHelperWindows.toke\u2026ommandLineToEscaped(this)");
        } else {
            List<String> list3 = StringHelperPOSIX.tokenizeCommandLineToEscaped($receiver);
            list = list3;
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"StringHelperPOSIX.tokeni\u2026ommandLineToEscaped(this)");
        }
        return list;
    }

    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String $receiver) {
        List<String> list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (SdkConstants.currentPlatform() == 2) {
            List<String> list2 = StringHelperWindows.tokenizeCommandLineToRaw($receiver);
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"StringHelperWindows.tokenizeCommandLineToRaw(this)");
        } else {
            List<String> list3 = StringHelperPOSIX.tokenizeCommandLineToRaw($receiver);
            list = list3;
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"StringHelperPOSIX.tokenizeCommandLineToRaw(this)");
        }
        return list;
    }

    @NotNull
    public static final String toSystemLineSeparator(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = System.lineSeparator();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.lineSeparator()");
        return StringHelper.toLineSeparator(string, $receiver);
    }

    private static final String toLineSeparator(String separator, String input) {
        String string;
        String unixStyle;
        String string2 = unixStyle = CR.matchesAnyOf((CharSequence)input) ? CR.removeFrom((CharSequence)input) : input;
        if (Intrinsics.areEqual((Object)separator, (Object)"\n")) {
            String string3 = unixStyle;
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"unixStyle");
        } else {
            String string4 = LF.matcher(unixStyle).replaceAll("\r\n");
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"LF.matcher(unixStyle).replaceAll(\"\\r\\n\")");
        }
        return string;
    }
}

