/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.AvdData;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientTracker;
import com.android.ddmlib.CommandFailedException;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.clientmanager.DeviceClientManager;
import com.android.ddmlib.clientmanager.DeviceClientManagerUtils;
import com.android.ddmlib.internal.ClientImpl;
import com.android.ddmlib.internal.CommandService;
import com.android.ddmlib.internal.DeviceClientMonitorTask;
import com.android.ddmlib.internal.DeviceImpl;
import com.android.ddmlib.internal.DeviceListMonitorTask;
import com.android.ddmlib.internal.commands.DisconnectCommand;
import com.android.ddmlib.internal.jdwp.JdwpProxyServer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class DeviceMonitor
implements ClientTracker {
    private final AndroidDebugBridge mServer;
    private final MonitorErrorHandler mMonitorErrorHandler;
    private final boolean mEmitDeviceListUpdates;
    private DeviceListMonitorTask mDeviceListMonitorTask;
    private Thread mDeviceListMonitorThread;
    private DeviceClientMonitorTask myDeviceClientMonitorTask;
    private Thread mDeviceClientMonitorThread;
    private JdwpProxyServer mJdwpProxy;
    private CommandService mDdmlibCommandService;
    private final Object mDevicesGuard = new Object();
    private ImmutableList<DeviceImpl> mDevices = ImmutableList.of();
    private static final long STOP_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);

    public DeviceMonitor(AndroidDebugBridge server, MonitorErrorHandler monitorErrorHandler, boolean emitDeviceListUpdates) {
        this.mServer = server;
        this.mMonitorErrorHandler = monitorErrorHandler;
        this.mEmitDeviceListUpdates = emitDeviceListUpdates;
    }

    public void start() {
        try {
            if (DdmPreferences.isJdwpProxyEnabled()) {
                this.mJdwpProxy = new JdwpProxyServer(DdmPreferences.getJdwpProxyPort(), this::jdwpProxyChangedState);
                this.mJdwpProxy.start();
            }
            if (DdmPreferences.isDdmlibCommandServiceEnabled()) {
                this.mDdmlibCommandService = new CommandService(DdmPreferences.getDdmCommandPort());
                this.mDdmlibCommandService.addCommand("disconnect", new DisconnectCommand(this));
                this.mDdmlibCommandService.start();
            }
            this.mDeviceListMonitorTask = new DeviceListMonitorTask(this.mServer, new DeviceListUpdateListener(), this.mEmitDeviceListUpdates);
            if (AndroidDebugBridge.getClientSupport()) {
                this.myDeviceClientMonitorTask = new DeviceClientMonitorTask();
                this.mDeviceClientMonitorThread = new Thread((Runnable)this.myDeviceClientMonitorTask, "Device Client Monitor");
                this.mDeviceClientMonitorThread.start();
            }
            this.mDeviceListMonitorThread = new Thread((Runnable)this.mDeviceListMonitorTask, "Device List Monitor");
            this.mDeviceListMonitorThread.start();
        }
        catch (IOException ex) {
            Log.e("DeviceMonitor", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jdwpProxyChangedState() {
        DeviceImpl[] deviceImplArray = this.mDevicesGuard;
        synchronized (this.mDevicesGuard) {
            DeviceImpl[] devices = (DeviceImpl[])this.mDevices.toArray((Object[])new DeviceImpl[0]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (DeviceImpl device : devices) {
                this.trackDeviceToDropAndReopen(device);
            }
            return;
        }
    }

    public void stop() {
        if (this.mJdwpProxy != null) {
            this.mJdwpProxy.stop();
        }
        if (this.mDeviceListMonitorTask != null) {
            this.mDeviceListMonitorTask.stop();
            try {
                if (this.mDeviceListMonitorThread != null) {
                    this.mDeviceListMonitorThread.join(STOP_TIMEOUT_MILLIS);
                    this.mDeviceListMonitorThread = null;
                }
            }
            catch (InterruptedException ex) {
                Log.e("DeviceMonitor.stop", ex);
            }
        }
        if (this.myDeviceClientMonitorTask != null) {
            this.myDeviceClientMonitorTask.stop();
            try {
                if (this.mDeviceClientMonitorThread != null) {
                    this.mDeviceClientMonitorThread.join(STOP_TIMEOUT_MILLIS);
                    this.mDeviceClientMonitorThread = null;
                }
            }
            catch (InterruptedException ex) {
                Log.e("DeviceMonitor.stop", ex);
            }
        }
        if (this.mDdmlibCommandService != null) {
            this.mDdmlibCommandService.stop();
        }
    }

    public boolean isMonitoring() {
        return this.mDeviceListMonitorTask != null && this.mDeviceListMonitorTask.isMonitoring();
    }

    public int getConnectionAttemptCount() {
        return this.mDeviceListMonitorTask == null ? 0 : this.mDeviceListMonitorTask.getConnectionAttemptCount();
    }

    public int getRestartAttemptCount() {
        return this.mDeviceListMonitorTask == null ? 0 : this.mDeviceListMonitorTask.getRestartAttemptCount();
    }

    public boolean hasInitialDeviceList() {
        return this.mDeviceListMonitorTask != null && this.mDeviceListMonitorTask.hasInitialDeviceList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice[] getDevices() {
        ImmutableList<DeviceImpl> devices;
        Object object = this.mDevicesGuard;
        synchronized (object) {
            devices = this.mDevices;
        }
        return (IDevice[])devices.toArray((Object[])new IDevice[0]);
    }

    public void disconnectClient(IDevice device, int pid) {
        if (this.isMonitoring()) {
            for (Client client : device.getClients()) {
                if (client.getClientData().getPid() != pid) continue;
                assert (this.myDeviceClientMonitorTask != null);
                this.myDeviceClientMonitorTask.disconnectClient((ClientImpl)client);
                return;
            }
        } else {
            Log.w("ddms", "Client disconnect ignored, not currently monitoring");
        }
    }

    AndroidDebugBridge getServer() {
        return this.mServer;
    }

    @Override
    public void trackClientToDropAndReopen(ClientImpl client) {
        assert (this.myDeviceClientMonitorTask != null);
        this.myDeviceClientMonitorTask.registerClientToDropAndReopen(client);
    }

    @Override
    public void trackDisconnectedClient(ClientImpl client) {
        assert (this.myDeviceClientMonitorTask != null);
        this.myDeviceClientMonitorTask.free(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trackDeviceToDropAndReopen(DeviceImpl device) {
        boolean hasDevice;
        Object object = this.mDevicesGuard;
        synchronized (object) {
            hasDevice = this.mDevices.contains((Object)device);
        }
        if (hasDevice && AndroidDebugBridge.getClientSupport() && this.myDeviceClientMonitorTask != null) {
            Log.d("DeviceMonitor", "Restarting monitoring service for " + device);
            if (!this.myDeviceClientMonitorTask.register(device)) {
                Log.e("DeviceMonitor", "Failed to start monitoring " + device.getSerialNumber());
            }
        }
    }

    private static ImmutableList<DeviceImpl> addRemove(Collection<DeviceImpl> original, Collection<IDevice> toAdd, Collection<IDevice> toRemove) {
        HashSet removed = Sets.newHashSet(toRemove);
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (DeviceImpl deviceImpl : original) {
            if (removed.contains(deviceImpl)) continue;
            resultBuilder.add((Object)deviceImpl);
        }
        for (IDevice iDevice : toAdd) {
            if (!(iDevice instanceof DeviceImpl)) continue;
            resultBuilder.add((Object)((DeviceImpl)iDevice));
        }
        return resultBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDevices(List<DeviceImpl> newList) {
        ImmutableList<DeviceImpl> oldDevices;
        Object object = this.mDevicesGuard;
        synchronized (object) {
            oldDevices = this.mDevices;
        }
        DeviceListComparisonResult result = DeviceListComparisonResult.compare(oldDevices, newList);
        ImmutableList<DeviceImpl> newDevices = DeviceMonitor.addRemove(oldDevices, result.added, result.removed);
        Iterator<IDevice> iterator = this.mDevicesGuard;
        synchronized (iterator) {
            this.mDevices = newDevices;
        }
        for (IDevice device : result.removed) {
            this.removeDevice((DeviceImpl)device);
            AndroidDebugBridge.deviceDisconnected(device);
        }
        ArrayList newlyOnline = Lists.newArrayListWithExpectedSize((int)newDevices.size());
        for (Map.Entry<IDevice, IDevice.DeviceState> entry : result.updated.entrySet()) {
            DeviceImpl device = (DeviceImpl)entry.getKey();
            device.setState(entry.getValue());
            device.update(1);
            if (!device.isOnline()) continue;
            newlyOnline.add(device);
        }
        for (IDevice device : result.added) {
            AndroidDebugBridge.deviceConnected(device);
            if (!device.isOnline()) continue;
            newlyOnline.add((DeviceImpl)device);
        }
        if (AndroidDebugBridge.getClientSupport()) {
            for (IDevice device : newlyOnline) {
                if (this.myDeviceClientMonitorTask.register((DeviceImpl)device)) continue;
                Log.e("DeviceMonitor", "Failed to start monitoring " + ((DeviceImpl)device).getSerialNumber());
            }
        }
        for (IDevice device : newlyOnline) {
            DeviceMonitor.setProperties((DeviceImpl)device);
            ((DeviceImpl)device).getSystemProperty("ro.build.version.sdk");
        }
    }

    private void removeDevice(DeviceImpl device) {
        device.setState(IDevice.DeviceState.DISCONNECTED);
        device.clearClientList();
        SocketChannel channel = device.getClientMonitoringSocket();
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setProperties(DeviceImpl device) {
        Path avdPath;
        EmulatorConsole console;
        AvdData avdData;
        block7: {
            block6: {
                avdData = null;
                try {
                    if (device.isEmulator()) break block6;
                    device.setAvdData(null);
                    device.setAvdData(avdData);
                    return;
                }
                catch (Throwable throwable) {
                    device.setAvdData(avdData);
                    throw throwable;
                }
            }
            console = EmulatorConsole.getConsole(device);
            if (console != null) break block7;
            device.setAvdData(null);
            device.setAvdData(avdData);
            return;
        }
        String avdName = console.getAvdName();
        try {
            avdPath = console.getAvdNioPath();
        }
        catch (CommandFailedException exception) {
            Log.e("DeviceMonitor", exception);
            avdPath = null;
        }
        console.close();
        avdData = new AvdData(avdName, avdPath);
        device.setAvdData(avdData);
    }

    public static interface MonitorErrorHandler {
        public void initializationError(Exception var1);
    }

    private class DeviceListUpdateListener
    implements DeviceListMonitorTask.UpdateListener {
        private DeviceListUpdateListener() {
        }

        @Override
        public void initializationError(Exception e) {
            DeviceMonitor.this.mMonitorErrorHandler.initializationError(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void listFetchError(Exception e) {
            ImmutableList<DeviceImpl> devices;
            Object object = DeviceMonitor.this.mDevicesGuard;
            synchronized (object) {
                devices = DeviceMonitor.this.mDevices;
                DeviceMonitor.this.mDevices = ImmutableList.of();
            }
            for (DeviceImpl device : devices) {
                DeviceMonitor.this.removeDevice(device);
                AndroidDebugBridge.deviceDisconnected(device);
            }
        }

        @Override
        public void deviceListUpdate(Map<String, IDevice.DeviceState> devices) {
            Function<IDevice, DeviceClientManager> deviceClientManagerProvider = DeviceMonitor.this.mServer.getClientManager() == null ? null : device -> DeviceClientManagerUtils.createDeviceClientManager(DeviceMonitor.this.mServer, device);
            ArrayList l = Lists.newArrayListWithExpectedSize((int)devices.size());
            for (Map.Entry<String, IDevice.DeviceState> entry : devices.entrySet()) {
                l.add(new DeviceImpl(DeviceMonitor.this, deviceClientManagerProvider, entry.getKey(), entry.getValue(), DeviceMonitor.this.getServer().getiDeviceUsageTracker()));
            }
            DeviceMonitor.this.updateDevices(l);
        }
    }

    @VisibleForTesting
    public static class DeviceListComparisonResult {
        public final Map<IDevice, IDevice.DeviceState> updated;
        public final List<IDevice> added;
        public final List<IDevice> removed;

        private DeviceListComparisonResult(Map<IDevice, IDevice.DeviceState> updated, List<IDevice> added, List<IDevice> removed) {
            this.updated = updated;
            this.added = added;
            this.removed = removed;
        }

        public static DeviceListComparisonResult compare(List<? extends IDevice> previous, List<? extends IDevice> current) {
            current = Lists.newArrayList((Iterable)current);
            HashMap updated = Maps.newHashMapWithExpectedSize((int)current.size());
            ArrayList added = Lists.newArrayListWithExpectedSize((int)1);
            ArrayList removed = Lists.newArrayListWithExpectedSize((int)1);
            for (IDevice iDevice : previous) {
                IDevice currentDevice = DeviceListComparisonResult.find(current, iDevice);
                if (currentDevice != null) {
                    if (currentDevice.getState() != iDevice.getState()) {
                        updated.put(iDevice, currentDevice.getState());
                    }
                    current.remove(currentDevice);
                    continue;
                }
                removed.add(iDevice);
            }
            added.addAll(current);
            return new DeviceListComparisonResult(updated, added, removed);
        }

        private static IDevice find(List<? extends IDevice> devices, IDevice device) {
            for (IDevice iDevice : devices) {
                if (!iDevice.getSerialNumber().equals(device.getSerialNumber())) continue;
                return iDevice;
            }
            return null;
        }
    }
}

