/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelSeverity;
import com.android.tools.lint.model.LintModelVariant;
import com.android.tools.lint.model.LintModelWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J4\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J&\u0010\u0015\u001a\u00020\u00122\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/model/LintModelModuleWriter;", "Lcom/android/tools/lint/model/LintModelWriter;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;)V", "writeLintOptions", "", "lintOptions", "Lcom/android/tools/lint/model/LintModelLintOptions;", "indent", "", "writeModule", "module", "Lcom/android/tools/lint/model/LintModelModule;", "writeVariants", "", "Lcom/android/tools/lint/model/LintModelVariant;", "writeDependencies", "", "createdBy", "", "writeSeverityOverrides", "severityOverrides", "", "Lcom/android/tools/lint/model/LintModelSeverity;", "writeVariantReference", "variant", "lint-model"})
final class LintModelModuleWriter
extends LintModelWriter {
    public LintModelModuleWriter(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        super(adapter, new PrintWriter(LintModelSerialization.LintModelSerializationAdapter.DefaultImpls.getWriter$default(adapter, LintModelSerialization.TargetFile.MODULE, null, null, 6, null)));
    }

    public final void writeModule(@NotNull LintModelModule module, @Nullable List<? extends LintModelVariant> writeVariants, boolean writeDependencies, @Nullable String createdBy) {
        Object it;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.setRoot(module.getDir());
        int indent = 0;
        this.getPrinter().print("<lint-module");
        this.printAttribute(this.getPrinter(), "format", "1", indent);
        PrintWriter printWriter = this.getPrinter();
        Iterator<? extends LintModelVariant> iterator = module.getDir().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"module.dir.path");
        this.printAttribute(printWriter, "dir", (String)((Object)iterator), indent);
        this.printName(this.getPrinter(), module.getModulePath(), indent);
        this.printAttribute(this.getPrinter(), "type", module.getType().name(), indent);
        iterator = createdBy;
        if (iterator != null) {
            String object = iterator;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            this.printAttribute(this.getPrinter(), "createdBy", (String)it, indent);
        }
        iterator = module.getMavenName();
        if (iterator != null) {
            Iterator<? extends LintModelVariant> iterator2 = iterator;
            bl2 = false;
            bl = false;
            it = iterator2;
            boolean bl4 = false;
            this.printAttribute(this.getPrinter(), "maven", it.toString(), indent);
        }
        iterator = module.getGradleVersion();
        if (iterator != null) {
            Iterator<? extends LintModelVariant> iterator3 = iterator;
            bl2 = false;
            bl = false;
            it = iterator3;
            boolean bl5 = false;
            PrintWriter printWriter2 = this.getPrinter();
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
            this.printAttribute(printWriter2, "gradle", string, indent);
        }
        LintModelWriter.printFile$default(this, this.getPrinter(), "buildFolder", module.getBuildFolder(), indent, null, 8, null);
        iterator = module.getResourcePrefix();
        if (iterator != null) {
            Iterator<? extends LintModelVariant> iterator4 = iterator;
            bl2 = false;
            bl = false;
            it = iterator4;
            boolean bl6 = false;
            this.printAttribute(this.getPrinter(), "resourcePrefix", (String)it, indent);
        }
        LintModelWriter.printStrings$default(this, this.getPrinter(), "dynamicFeatures", module.getDynamicFeatures(), indent, null, 8, null);
        LintModelWriter.printFiles$default(this, this.getPrinter(), "bootClassPath", module.getBootClassPath(), indent, null, 8, null);
        this.printAttribute(this.getPrinter(), "javaSourceLevel", module.getJavaSourceLevel(), indent);
        this.printAttribute(this.getPrinter(), "compileTarget", module.getCompileTarget(), indent);
        if (module.neverShrinking()) {
            this.printAttribute(this.getPrinter(), "neverShrinking", "true", indent);
        }
        LintModelWriter.printFiles$default(this, this.getPrinter(), "lintRuleJars", module.getLintRuleJars(), indent, null, 8, null);
        this.getPrinter().println(">");
        this.writeLintOptions(module.getLintOptions(), indent + 1);
        if (writeVariants != null) {
            for (LintModelVariant lintModelVariant : writeVariants) {
                this.writeVariantReference(lintModelVariant, indent + 1);
                LintModelSerialization.INSTANCE.writeVariant(lintModelVariant, this.getAdapter(), writeDependencies, createdBy);
            }
        }
        this.getPrinter().println("</lint-module>");
        this.getPrinter().close();
    }

    public static /* synthetic */ void writeModule$default(LintModelModuleWriter lintModelModuleWriter, LintModelModule lintModelModule, List list, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            list = lintModelModule.getVariants();
        }
        if ((n & 8) != 0) {
            string = null;
        }
        lintModelModuleWriter.writeModule(lintModelModule, list, bl, string);
    }

    private final void writeVariantReference(LintModelVariant variant, int indent) {
        this.indent(indent);
        this.getPrinter().print("<variant name=\"");
        this.getPrinter().print(variant.getName());
        this.getPrinter().println("\"/>");
    }

    private final void writeLintOptions(LintModelLintOptions lintOptions, int indent) {
        Object it;
        boolean bl;
        boolean bl2;
        boolean bl3;
        this.indent(indent);
        this.getPrinter().print("<lintOptions");
        LintModelWriter.printFile$default(this, this.getPrinter(), "lintConfig", lintOptions.getLintConfig(), indent, null, 8, null);
        LintModelWriter.printFile$default(this, this.getPrinter(), "baselineFile", lintOptions.getBaselineFile(), indent, null, 8, null);
        if (lintOptions.getCheckDependencies()) {
            this.printAttribute(this.getPrinter(), "checkDependencies", "true", indent);
        }
        if (lintOptions.getCheckTestSources()) {
            this.printAttribute(this.getPrinter(), "checkTestSources", "true", indent);
        }
        Object object = lintOptions.getDisable();
        boolean bl4 = false;
        if (!object.isEmpty()) {
            LintModelWriter.printStrings$default(this, this.getPrinter(), "disable", lintOptions.getDisable(), indent, null, 8, null);
        }
        object = lintOptions.getEnable();
        bl4 = false;
        if (!object.isEmpty()) {
            LintModelWriter.printStrings$default(this, this.getPrinter(), "enable", lintOptions.getEnable(), indent, null, 8, null);
        }
        if ((object = lintOptions.getCheck()) == null) {
            bl3 = false;
        } else {
            Collection collection = (Collection)object;
            bl2 = false;
            bl3 = !collection.isEmpty();
        }
        if (bl3) {
            LintModelWriter.printStrings$default(this, this.getPrinter(), "check", lintOptions.getDisable(), indent, null, 8, null);
        }
        if (lintOptions.getAbortOnError()) {
            this.printAttribute(this.getPrinter(), "abortOnError", "true", indent);
        }
        if (lintOptions.getAbsolutePaths()) {
            this.printAttribute(this.getPrinter(), "absolutePaths", "true", indent);
        }
        if (lintOptions.getNoLines()) {
            this.printAttribute(this.getPrinter(), "noLines", "true", indent);
        }
        if (lintOptions.getQuiet()) {
            this.printAttribute(this.getPrinter(), "quiet", "true", indent);
        }
        if (lintOptions.getCheckAllWarnings()) {
            this.printAttribute(this.getPrinter(), "checkAllWarnings", "true", indent);
        }
        if (lintOptions.getIgnoreWarnings()) {
            this.printAttribute(this.getPrinter(), "ignoreWarnings", "true", indent);
        }
        if (lintOptions.getWarningsAsErrors()) {
            this.printAttribute(this.getPrinter(), "warningsAsErrors", "true", indent);
        }
        if (lintOptions.getIgnoreTestSources()) {
            this.printAttribute(this.getPrinter(), "ignoreTestSources", "true", indent);
        }
        if (lintOptions.getIgnoreTestFixturesSources()) {
            this.printAttribute(this.getPrinter(), "ignoreTestFixturesSources", "true", indent);
        }
        if (lintOptions.getCheckGeneratedSources()) {
            this.printAttribute(this.getPrinter(), "checkGeneratedSources", "true", indent);
        }
        if (lintOptions.getCheckReleaseBuilds()) {
            this.printAttribute(this.getPrinter(), "checkReleaseBuilds", "true", indent);
        }
        if (lintOptions.getExplainIssues()) {
            this.printAttribute(this.getPrinter(), "explainIssues", "true", indent);
        }
        if (lintOptions.getShowAll()) {
            this.printAttribute(this.getPrinter(), "showAll", "true", indent);
        }
        if (lintOptions.getTextReport()) {
            this.printAttribute(this.getPrinter(), "textReport", "true", indent);
        }
        LintModelWriter.printFile$default(this, this.getPrinter(), "textOutput", lintOptions.getTextOutput(), indent, null, 8, null);
        if (lintOptions.getHtmlReport()) {
            this.printAttribute(this.getPrinter(), "htmlReport", "true", indent);
        }
        if ((object = lintOptions.getHtmlOutput()) != null) {
            Object object2 = object;
            bl2 = false;
            bl = false;
            it = object2;
            boolean bl5 = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "htmlOutput", (File)it, indent, null, 8, null);
        }
        if (lintOptions.getXmlReport()) {
            this.printAttribute(this.getPrinter(), "xmlReport", "true", indent);
        }
        if ((object = lintOptions.getXmlOutput()) != null) {
            Object object3 = object;
            bl2 = false;
            bl = false;
            it = object3;
            boolean bl6 = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "xmlOutput", (File)it, indent, null, 8, null);
        }
        if (lintOptions.getSarifReport()) {
            this.printAttribute(this.getPrinter(), "sarifReport", "true", indent);
        }
        if ((object = lintOptions.getSarifOutput()) != null) {
            Object object4 = object;
            bl2 = false;
            bl = false;
            it = object4;
            boolean bl7 = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "sarifOutput", (File)it, indent, null, 8, null);
        }
        if (!this.writeSeverityOverrides(lintOptions.getSeverityOverrides(), indent + 1)) {
            this.getPrinter().println("/>");
        } else {
            this.indent(indent);
            this.getPrinter().println("</lintOptions>");
        }
    }

    private final boolean writeSeverityOverrides(Map<String, ? extends LintModelSeverity> severityOverrides, int indent) {
        Map<String, ? extends LintModelSeverity> map = severityOverrides;
        if (map == null) {
            return false;
        }
        if (severityOverrides.isEmpty()) {
            return false;
        }
        this.getPrinter().println(">");
        this.indent(indent);
        this.getPrinter().println("<severities>");
        Sequence $this$sortedBy$iv = MapsKt.asSequence(severityOverrides);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = (String)it.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry $dstr$id$severity = (Map.Entry)element$iv;
            boolean bl2 = false;
            Map.Entry entry = $dstr$id$severity;
            boolean bl3 = false;
            String id = (String)entry.getKey();
            Map.Entry entry2 = $dstr$id$severity;
            boolean bl4 = false;
            LintModelSeverity severity = (LintModelSeverity)((Object)entry2.getValue());
            this.indent(indent + 1);
            this.getPrinter().print("<severity");
            this.printAttribute(this.getPrinter(), "id", id, indent);
            this.printAttribute(this.getPrinter(), "severity", severity.name(), indent);
            this.getPrinter().println(" />");
        }
        this.indent(indent);
        this.getPrinter().println("</severities>");
        return true;
    }
}

