/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModuleLoader;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.tools.lint.model.LintModelVariant;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\n\u00103\u001a\u0004\u0018\u000101H\u0016J\u0012\u00104\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u00020\u000bH\u0016J\u0016\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00032\u0006\u00108\u001a\u000201H\u0016J\b\u00109\u001a\u00020:H&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0006R\u0014\u0010 \u001a\u0004\u0018\u00010!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u0004\u0018\u00010%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0012\u0010(\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\rR\u0014\u0010*\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\rR\u0012\u0010,\u001a\u00020-X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0018\u00100\u001a\b\u0012\u0004\u0012\u0002010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0006\u00a8\u0006;\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/lint/model/LintModelModule;", "", "bootClassPath", "", "Ljava/io/File;", "getBootClassPath", "()Ljava/util/List;", "buildFolder", "getBuildFolder", "()Ljava/io/File;", "compileTarget", "", "getCompileTarget", "()Ljava/lang/String;", "dir", "getDir", "dynamicFeatures", "", "getDynamicFeatures", "()Ljava/util/Collection;", "gradleVersion", "Lcom/android/ide/common/repository/GradleVersion;", "getGradleVersion", "()Lcom/android/ide/common/repository/GradleVersion;", "javaSourceLevel", "getJavaSourceLevel", "lintOptions", "Lcom/android/tools/lint/model/LintModelLintOptions;", "getLintOptions", "()Lcom/android/tools/lint/model/LintModelLintOptions;", "lintRuleJars", "getLintRuleJars", "loader", "Lcom/android/tools/lint/model/LintModelModuleLoader;", "getLoader", "()Lcom/android/tools/lint/model/LintModelModuleLoader;", "mavenName", "Lcom/android/tools/lint/model/LintModelMavenName;", "getMavenName", "()Lcom/android/tools/lint/model/LintModelMavenName;", "modulePath", "getModulePath", "resourcePrefix", "getResourcePrefix", "type", "Lcom/android/tools/lint/model/LintModelModuleType;", "getType", "()Lcom/android/tools/lint/model/LintModelModuleType;", "variants", "Lcom/android/tools/lint/model/LintModelVariant;", "getVariants", "defaultVariant", "findVariant", "name", "getInactiveSourceProviders", "Lcom/android/tools/lint/model/LintModelSourceProvider;", "active", "neverShrinking", "", "lint-model"})
public interface LintModelModule {
    @Nullable
    public LintModelModuleLoader getLoader();

    @NotNull
    public File getDir();

    @NotNull
    public String getModulePath();

    @NotNull
    public LintModelModuleType getType();

    @Nullable
    public LintModelMavenName getMavenName();

    @Nullable
    public GradleVersion getGradleVersion();

    @NotNull
    public File getBuildFolder();

    @NotNull
    public LintModelLintOptions getLintOptions();

    @NotNull
    public List<File> getLintRuleJars();

    @Nullable
    public String getResourcePrefix();

    @NotNull
    public Collection<String> getDynamicFeatures();

    @NotNull
    public List<File> getBootClassPath();

    @NotNull
    public String getJavaSourceLevel();

    @NotNull
    public String getCompileTarget();

    @NotNull
    public List<LintModelVariant> getVariants();

    @Nullable
    default public LintModelVariant defaultVariant() {
        return (LintModelVariant)CollectionsKt.firstOrNull(this.getVariants());
    }

    public boolean neverShrinking();

    @Nullable
    default public LintModelVariant findVariant(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (LintModelVariant variant : this.getVariants()) {
            if (!Intrinsics.areEqual((Object)name, (Object)variant.getName())) continue;
            return variant;
        }
        return null;
    }

    @NotNull
    default public List<LintModelSourceProvider> getInactiveSourceProviders(@NotNull LintModelVariant active) {
        Intrinsics.checkNotNullParameter((Object)active, (String)"active");
        HashSet<Object> seen = new HashSet<Object>();
        for (LintModelSourceProvider provider : active.getSourceProviders()) {
            seen.add(CollectionsKt.first((Iterable)provider.getManifestFiles()));
        }
        List providers = new ArrayList();
        for (LintModelVariant variant : this.getVariants()) {
            if (Intrinsics.areEqual((Object)variant, (Object)active)) continue;
            for (LintModelSourceProvider provider : active.getSourceProviders()) {
                if (!seen.add(CollectionsKt.first((Iterable)provider.getManifestFiles()))) continue;
                providers.add(provider);
            }
        }
        return providers;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @Nullable
        public static LintModelVariant defaultVariant(@NotNull LintModelModule $this) {
            return $this.defaultVariant();
        }

        @Deprecated
        @Nullable
        public static LintModelVariant findVariant(@NotNull LintModelModule $this, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return $this.findVariant(name);
        }

        @Deprecated
        @NotNull
        public static List<LintModelSourceProvider> getInactiveSourceProviders(@NotNull LintModelModule $this, @NotNull LintModelVariant active) {
            Intrinsics.checkNotNullParameter((Object)active, (String)"active");
            return $this.getInactiveSourceProviders(active);
        }
    }
}

