/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.android.ide.common.util.JvmWideVariable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecutorSingleton {
    private static final JvmWideVariable<ExecutorService> sExecutorService = new JvmWideVariable<Object>(ExecutorSingleton.class.getName(), "sExecutorService", ExecutorService.class, null);
    private static final JvmWideVariable<Integer> sThreadPoolSize = new JvmWideVariable<Integer>(ExecutorSingleton.class.getName(), "sThreadPoolSize", Integer.class, Integer.valueOf(Runtime.getRuntime().availableProcessors()));

    public static ExecutorService getExecutor() {
        return sExecutorService.doSupplierSynchronized(() -> {
            if (sExecutorService.get() == null) {
                sExecutorService.set(Executors.newFixedThreadPool(sThreadPoolSize.get()));
            }
            return sExecutorService.get();
        });
    }

    public static void shutdown() {
        sExecutorService.doRunnableSynchronized(() -> {
            if (sExecutorService.get() != null) {
                sExecutorService.get().shutdown();
                sExecutorService.set(null);
            }
        });
    }

    public static void setThreadPoolSize(int threadPoolSize) {
        sExecutorService.doRunnableSynchronized(() -> sThreadPoolSize.set(threadPoolSize));
    }
}

