/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.ide.common.gradle.model.IdeFilterData;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

public final class IdeOutputFile
extends IdeModel
implements OutputFile {
    private static final long serialVersionUID = 1L;
    private final String myOutputType;
    private final Collection<String> myFilterTypes;
    private final Collection<FilterData> myFilters;
    private final File myOutputFile;
    private final Collection<? extends OutputFile> myOutputs;
    private final OutputFile myMainOutputFile;
    private final Integer myVersionCode;
    private final int myHashCode;

    public IdeOutputFile(OutputFile file, ModelCache modelCache) {
        super(file, modelCache);
        this.myOutputType = file.getOutputType();
        this.myFilterTypes = ImmutableList.copyOf((Collection)file.getFilterTypes());
        this.myFilters = IdeOutputFile.copy(file.getFilters(), modelCache, (K data) -> new IdeFilterData((FilterData)data, modelCache));
        this.myOutputFile = file.getOutputFile();
        this.myMainOutputFile = IdeOutputFile.copyNewProperty(modelCache, () -> ((OutputFile)file).getMainOutputFile(), outputFile -> new IdeOutputFile((OutputFile)outputFile, modelCache), null);
        this.myOutputs = IdeOutputFile.copyOutputs(file, modelCache);
        this.myVersionCode = IdeOutputFile.copyNewProperty(() -> ((OutputFile)file).getVersionCode(), null);
        this.myHashCode = this.calculateHashCode();
    }

    private static Collection<? extends OutputFile> copyOutputs(OutputFile file, ModelCache modelCache) {
        try {
            Collection key = file.getOutputs();
            return IdeOutputFile.copy(key, modelCache, (K outputFile) -> new IdeOutputFile((OutputFile)outputFile, modelCache));
        }
        catch (UnsupportedOperationException ignored) {
            return Collections.emptyList();
        }
    }

    public String getOutputType() {
        return this.myOutputType;
    }

    public Collection<String> getFilterTypes() {
        return this.myFilterTypes;
    }

    public Collection<FilterData> getFilters() {
        return this.myFilters;
    }

    public File getOutputFile() {
        return this.myOutputFile;
    }

    public OutputFile getMainOutputFile() {
        if (this.myMainOutputFile != null) {
            return this.myMainOutputFile;
        }
        throw new UnsupportedOperationException("getMainOutputFile()");
    }

    public Collection<? extends OutputFile> getOutputs() {
        return this.myOutputs;
    }

    public int getVersionCode() {
        if (this.myVersionCode != null) {
            return this.myVersionCode;
        }
        throw new UnsupportedOperationException("getVersionCode");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeOutputFile)) {
            return false;
        }
        IdeOutputFile file = (IdeOutputFile)o;
        return Objects.equals(this.myVersionCode, file.myVersionCode) && Objects.equals(this.myOutputType, file.myOutputType) && Objects.equals(this.myFilterTypes, file.myFilterTypes) && Objects.equals(this.myFilters, file.myFilters) && Objects.equals(this.myOutputFile, file.myOutputFile) && this.areOutputsEqual(file) && this.mainOutputFileEquals(file);
    }

    private boolean areOutputsEqual(IdeOutputFile other) {
        if (this.myOutputs == other.myOutputs) {
            return true;
        }
        Iterator<? extends OutputFile> iterator1 = this.myOutputs.iterator();
        Iterator<? extends OutputFile> iterator2 = other.myOutputs.iterator();
        while (iterator1.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            OutputFile o1 = iterator1.next();
            OutputFile o2 = iterator2.next();
            if (!(o1 == this ? o2 != other : !Objects.equals(o1, o2))) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    private boolean mainOutputFileEquals(IdeOutputFile file) {
        return this.myMainOutputFile == this ? file.myMainOutputFile == file : Objects.equals(this.myMainOutputFile, file.myMainOutputFile);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        int result = this.myOutputType.hashCode();
        result = 31 * result + this.myFilterTypes.hashCode();
        result = 31 * result + this.myFilters.hashCode();
        result = 31 * result + this.myOutputFile.hashCode();
        result = 31 * result + this.hashCode(this.myMainOutputFile);
        result = 31 * result + this.hashCode(this.myOutputs);
        result = 31 * result + Objects.hashCode(this.myVersionCode);
        return result;
    }

    private int hashCode(Collection<? extends OutputFile> outputFiles) {
        int hashCode = 1;
        for (OutputFile outputFile : outputFiles) {
            hashCode = 31 * hashCode + this.hashCode(outputFile);
        }
        return hashCode;
    }

    private int hashCode(OutputFile outputFile) {
        return outputFile != this ? Objects.hashCode(outputFile) : 1;
    }

    public String toString() {
        return "IdeOutputFile{myOutputType='" + this.myOutputType + '\'' + ", myFilterTypes=" + this.myFilterTypes + ", myFilters=" + this.myFilters + ", myOutputFile=" + this.myOutputFile + ", myMainOutputFile=" + this.toString(this.myMainOutputFile) + ", myOutputs=" + this.toString(this.myOutputs) + ", myVersionCode=" + this.myVersionCode + "}";
    }

    private String toString(Collection<? extends OutputFile> outputFiles) {
        int max = outputFiles.size() - 1;
        if (max == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        for (OutputFile outputFile : outputFiles) {
            b.append(this.toString(outputFile));
            if (i++ == max) {
                b.append(']');
                break;
            }
            b.append(", ");
        }
        return b.toString();
    }

    private String toString(OutputFile outputFile) {
        if (outputFile == this) {
            return "this";
        }
        return Objects.toString(outputFile);
    }
}

