/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NodeUtils;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Deprecated
class IdGeneratingResourceParser {
    private final ResourceMergerItem mFileResourceMergerItem;
    private final List<ResourceMergerItem> mIdResourceMergerItems;
    private final ResourceNamespace mNamespace;

    IdGeneratingResourceParser(File file, String sourceName, ResourceType sourceType, ResourceNamespace namespace) throws MergingException {
        Document mDocument = IdGeneratingResourceParser.readDocument(file);
        if (IdGeneratingResourceParser.hasDataBindings(mDocument)) {
            throw MergingException.withMessage("Does not handle data-binding files", new Object[0]).build();
        }
        this.mNamespace = namespace;
        this.mFileResourceMergerItem = new IdResourceMergerItem(sourceName, this.mNamespace, sourceType);
        this.mIdResourceMergerItems = Lists.newArrayList();
        HashSet pendingResourceIds = Sets.newHashSet();
        NodeList nodes = mDocument.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            this.parseIds(this.mIdResourceMergerItems, child, pendingResourceIds);
        }
        for (String id : pendingResourceIds) {
            IdResourceMergerItem resourceItem = new IdResourceMergerItem(id, this.mNamespace, ResourceType.ID);
            this.mIdResourceMergerItems.add(resourceItem);
        }
    }

    private static Document readDocument(File file) throws MergingException {
        try {
            return XmlUtils.parseUtfXmlFile((File)file, (boolean)true);
        }
        catch (IOException | SAXException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
    }

    private static boolean hasDataBindings(Document document) {
        Element rootNode = document.getDocumentElement();
        return rootNode != null && "layout".equals(rootNode.getNodeName());
    }

    public ResourceMergerItem getFileResourceMergerItem() {
        return this.mFileResourceMergerItem;
    }

    public List<ResourceMergerItem> getIdResourceMergerItems() {
        return this.mIdResourceMergerItems;
    }

    private void parseIds(List<ResourceMergerItem> items, Node node, Set<String> pendingResourceIds) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String id;
                Node attribute = attributes.item(i);
                String attrNamespace = attribute.getNamespaceURI();
                if (!"http://schemas.android.com/apk/res/android".equals(attrNamespace)) continue;
                String attrName = attribute.getLocalName();
                String value = attribute.getNodeValue();
                if (value == null) continue;
                if (value.startsWith("@+id/") && !"id".equals(attrName)) {
                    id = value.substring("@+id/".length());
                    if (id.isEmpty()) continue;
                    pendingResourceIds.add(id);
                    continue;
                }
                if (!"id".equals(attrName)) continue;
                if (value.startsWith("@id/")) {
                    id = value.substring("@id/".length());
                    if (!pendingResourceIds.contains(id)) {
                        continue;
                    }
                } else {
                    if (!value.startsWith("@+id/")) continue;
                    id = value.substring("@+id/".length());
                }
                pendingResourceIds.remove(id);
                if (id.isEmpty()) continue;
                IdResourceMergerItem item = new IdResourceMergerItem(id, this.mNamespace, ResourceType.ID);
                items.add(item);
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            this.parseIds(items, child, pendingResourceIds);
        }
    }

    private static class IdResourceMergerItem
    extends ResourceMergerItem {
        public IdResourceMergerItem(String name, ResourceNamespace namespace, ResourceType type) {
            super(name, namespace, type, null, null);
        }

        @Override
        Node getDetailsXml(Document document) {
            Element newNode = document.createElement("item");
            NodeUtils.addAttribute(document, newNode, null, "name", this.getName());
            NodeUtils.addAttribute(document, newNode, null, "type", this.getType().getName());
            if (this.getType() != ResourceType.ID) {
                ResourceFile sourceFile = (ResourceFile)this.getSourceFile();
                assert (sourceFile != null);
                newNode.setTextContent(sourceFile.getFile().getAbsolutePath());
            }
            return newNode;
        }
    }
}

