/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.vectordrawable.VdOverrideInfo;
import com.android.ide.common.vectordrawable.VdParser;
import com.android.ide.common.vectordrawable.VdTree;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class VdPreview {
    private static final String ANDROID_ALPHA = "android:alpha";
    private static final String ANDROID_TINT = "android:tint";
    private static final String ANDROID_AUTO_MIRRORED = "android:autoMirrored";
    private static final String ANDROID_HEIGHT = "android:height";
    private static final String ANDROID_WIDTH = "android:width";
    public static final int MAX_PREVIEW_IMAGE_SIZE = 4096;
    public static final int MIN_PREVIEW_IMAGE_SIZE = 1;

    public static Document parseVdStringIntoDocument(String xmlFileContent, StringBuilder errorLog) {
        Document document;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(new InputSource(new StringReader(xmlFileContent)));
        }
        catch (Exception e) {
            if (errorLog != null) {
                errorLog.append("Exception while parsing XML file:\n").append(e.getMessage());
            }
            return null;
        }
        return document;
    }

    private static OutputFormat getPrettyPrintFormat() {
        OutputFormat format = new OutputFormat();
        format.setLineWidth(120);
        format.setIndenting(true);
        format.setIndent(4);
        format.setEncoding("UTF-8");
        format.setOmitComments(true);
        format.setOmitXMLDeclaration(true);
        return format;
    }

    public static SourceSize getVdOriginalSize(Document document) {
        Element root = document.getDocumentElement();
        SourceSize srcSize = new SourceSize();
        NamedNodeMap attr = root.getAttributes();
        Node nodeAttr = attr.getNamedItem(ANDROID_WIDTH);
        assert (nodeAttr != null);
        srcSize.mSourceWidth = VdPreview.parseDimension(0.0f, nodeAttr, false);
        nodeAttr = attr.getNamedItem(ANDROID_HEIGHT);
        assert (nodeAttr != null);
        srcSize.mSourceHeight = VdPreview.parseDimension(0.0f, nodeAttr, false);
        return srcSize;
    }

    public static String overrideXmlContent(Document document, VdOverrideInfo info, StringBuilder errorLog) {
        float originalValue;
        float overrideValue;
        Node nodeAttr;
        boolean isXmlFileContentChanged = false;
        Element root = document.getDocumentElement();
        NamedNodeMap attr = root.getAttributes();
        if (info.needsOverrideWidth()) {
            nodeAttr = attr.getNamedItem(ANDROID_WIDTH);
            overrideValue = info.getWidth();
            originalValue = VdPreview.parseDimension(overrideValue, nodeAttr, true);
            if (originalValue != overrideValue) {
                isXmlFileContentChanged = true;
            }
        }
        if (info.needsOverrideHeight()) {
            nodeAttr = attr.getNamedItem(ANDROID_HEIGHT);
            overrideValue = info.getHeight();
            originalValue = VdPreview.parseDimension(overrideValue, nodeAttr, true);
            if (originalValue != overrideValue) {
                isXmlFileContentChanged = true;
            }
        }
        if (info.needsOverrideAlpha()) {
            String alphaValue = XmlUtils.formatFloatAttribute((double)info.getAlpha());
            Node nodeAttr2 = attr.getNamedItem(ANDROID_ALPHA);
            if (nodeAttr2 != null) {
                nodeAttr2.setTextContent(alphaValue);
            } else {
                root.setAttribute(ANDROID_ALPHA, alphaValue);
            }
            isXmlFileContentChanged = true;
        }
        if (info.needsOverrideTint()) {
            String tintValue = String.format("#%06X", info.tintRgb());
            Node nodeAttr3 = attr.getNamedItem(ANDROID_TINT);
            if (nodeAttr3 != null) {
                nodeAttr3.setTextContent(tintValue);
            } else {
                root.setAttribute(ANDROID_TINT, tintValue);
            }
            isXmlFileContentChanged = true;
        }
        if (info.getAutoMirrored()) {
            nodeAttr = attr.getNamedItem(ANDROID_AUTO_MIRRORED);
            if (nodeAttr != null) {
                nodeAttr.setTextContent("true");
            } else {
                root.setAttribute(ANDROID_AUTO_MIRRORED, "true");
            }
            isXmlFileContentChanged = true;
        }
        if (isXmlFileContentChanged) {
            StringWriter stringOut;
            block16: {
                stringOut = new StringWriter();
                XMLSerializer serial = new XMLSerializer(stringOut, VdPreview.getPrettyPrintFormat());
                try {
                    serial.serialize(document);
                }
                catch (IOException e) {
                    if (errorLog == null) break block16;
                    errorLog.append("Exception while parsing XML file:\n").append(e.getMessage());
                }
            }
            return stringOut.toString();
        }
        return null;
    }

    private static float parseDimension(float overrideValue, Node nodeAttr, boolean override) {
        assert (nodeAttr != null);
        String content = nodeAttr.getTextContent();
        assert (content.endsWith("dp"));
        double originalValue = Double.parseDouble(content.substring(0, content.length() - 2));
        if (override) {
            nodeAttr.setTextContent(XmlUtils.formatFloatAttribute((double)overrideValue) + "dp");
        }
        return (float)originalValue;
    }

    public static BufferedImage getPreviewFromVectorXml(TargetSize targetSize, String xmlFileContent, StringBuilder errorLog) {
        if (xmlFileContent == null || xmlFileContent.isEmpty()) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlFileContent.getBytes(Charsets.UTF_8));
        VdTree vdTree = VdParser.parse(inputStream, errorLog);
        return VdPreview.getPreviewFromVectorTree(targetSize, vdTree, errorLog);
    }

    public static BufferedImage getPreviewFromVectorDocument(TargetSize targetSize, Document xml, StringBuilder vdErrorLog) {
        VdTree vdTree = new VdTree();
        vdTree.parse(xml);
        return VdPreview.getPreviewFromVectorTree(targetSize, vdTree, vdErrorLog);
    }

    public static BufferedImage getPreviewFromVectorTree(TargetSize targetSize, VdTree vdTree, StringBuilder errorLog) {
        float imageHeight;
        float imageWidth;
        float vdWidth = vdTree.getBaseWidth();
        float vdHeight = vdTree.getBaseHeight();
        int forceImageSize = targetSize.mImageMaxDimension;
        float imageScale = targetSize.mImageScale;
        if (forceImageSize > 0) {
            float maxVdSize = Math.max(vdWidth, vdHeight);
            float ratioToForceImageSize = (float)forceImageSize / maxVdSize;
            float scaledWidth = ratioToForceImageSize * vdWidth;
            float scaledHeight = ratioToForceImageSize * vdHeight;
            imageWidth = VdPreview.limitToInterval(scaledWidth, 1.0f, 4096.0f);
            imageHeight = VdPreview.limitToInterval(scaledHeight, 1.0f, 4096.0f);
            if (errorLog != null && (scaledWidth != imageWidth || scaledHeight != imageHeight)) {
                errorLog.append("Invalid image size, can't fit in a square whose size is ").append(forceImageSize);
            }
        } else {
            imageWidth = vdWidth * imageScale;
            imageHeight = vdHeight * imageScale;
        }
        BufferedImage image = AssetUtil.newArgbBufferedImage((int)imageWidth, (int)imageHeight);
        vdTree.drawIntoImage(image);
        return image;
    }

    private static float limitToInterval(float value, float begin, float end) {
        return Math.max(begin, Math.min(end, value));
    }

    public static class SourceSize {
        private float mSourceWidth;
        private float mSourceHeight;

        public float getHeight() {
            return this.mSourceHeight;
        }

        public float getWidth() {
            return this.mSourceWidth;
        }
    }

    public static class TargetSize {
        private boolean mUseWidth;
        private int mImageMaxDimension;
        private float mImageScale;

        private TargetSize(boolean useWidth, int imageWidth, float imageScale) {
            this.mUseWidth = useWidth;
            this.mImageMaxDimension = imageWidth;
            this.mImageScale = imageScale;
        }

        public static TargetSize createSizeFromWidth(int imageWidth) {
            return new TargetSize(true, imageWidth, 0.0f);
        }

        public static TargetSize createSizeFromScale(float imageScale) {
            return new TargetSize(false, 0, imageScale);
        }
    }
}

