/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xml.sax.SAXParseException;

public class MergingException
extends Exception {
    public static final String MULTIPLE_ERRORS = "Multiple errors:";
    public static final String RESOURCE_ASSET_MERGER_TOOL_NAME = "Resource and asset merger";
    private final List<Message> mMessages;

    protected MergingException(Throwable cause, Message ... messages) {
        super(messages.length == 1 ? messages[0].getText() : MULTIPLE_ERRORS, cause);
        this.mMessages = ImmutableList.copyOf((Object[])messages);
    }

    public static void findAndReportMergingException(Exception exception, MessageReceiver messageReceiver) {
        for (Throwable it = exception; it != null; it = it.getCause()) {
            if (!(it instanceof MergingException)) continue;
            ((MergingException)it).getMessages().forEach(messageReceiver::receiveMessage);
        }
    }

    public static Builder wrapException(Throwable cause) {
        return new Builder().wrapException(cause);
    }

    public static Builder withMessage(String message, Object ... args) {
        return new Builder().withMessage(message, args);
    }

    public static void throwIfNonEmpty(Collection<Message> messages) throws MergingException {
        if (!messages.isEmpty()) {
            throw new MergingException(null, (Message[])Iterables.toArray(messages, Message.class));
        }
    }

    public List<Message> getMessages() {
        return this.mMessages;
    }

    @Override
    public String getMessage() {
        ArrayList messages = Lists.newArrayListWithCapacity((int)this.mMessages.size());
        for (Message message : this.mMessages) {
            String path;
            File file;
            StringBuilder sb = new StringBuilder();
            List sourceFilePositions = message.getSourceFilePositions();
            if (sourceFilePositions.size() > 1 || !((SourceFilePosition)sourceFilePositions.get(0)).equals((Object)SourceFilePosition.UNKNOWN)) {
                sb.append(Joiner.on((char)'\t').join((Iterable)sourceFilePositions));
            }
            String text = message.getText();
            if (sb.length() > 0) {
                sb.append(':').append(' ');
                if (!text.startsWith("Error: ")) {
                    sb.append("Error: ");
                }
            } else if (!text.contains("Error: ")) {
                sb.append("Error: ");
            }
            if (sourceFilePositions.size() == 1 && (file = ((SourceFilePosition)sourceFilePositions.get(0)).getFile().getSourceFile()) != null && text.startsWith(path = file.getAbsolutePath())) {
                int stripStart = path.length();
                if (text.length() > stripStart && text.charAt(stripStart) == ':') {
                    ++stripStart;
                }
                if (text.length() > stripStart && text.charAt(stripStart) == ' ') {
                    ++stripStart;
                }
                text = text.substring(stripStart);
            }
            sb.append(text);
            messages.add(sb.toString());
        }
        return Joiner.on((char)'\n').join((Iterable)messages);
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public static class Builder {
        private Throwable mCause = null;
        private String mMessageText = null;
        private String mOriginalMessageText = null;
        private SourceFile mFile = SourceFile.UNKNOWN;
        private SourcePosition mPosition = SourcePosition.UNKNOWN;

        private Builder() {
        }

        public Builder wrapException(Throwable cause) {
            this.mCause = cause;
            this.mOriginalMessageText = Throwables.getStackTraceAsString((Throwable)cause);
            return this;
        }

        public Builder withFile(File file) {
            this.mFile = new SourceFile(file);
            return this;
        }

        public Builder withFile(SourceFile file) {
            this.mFile = file;
            return this;
        }

        public Builder withPosition(SourcePosition position) {
            this.mPosition = position;
            return this;
        }

        public Builder withMessage(String messageText, Object ... args) {
            this.mMessageText = args.length == 0 ? messageText : String.format(messageText, args);
            return this;
        }

        public MergingException build() {
            if (this.mCause != null) {
                SAXParseException exception;
                int lineNumber;
                if (this.mMessageText == null) {
                    this.mMessageText = (String)MoreObjects.firstNonNull((Object)this.mCause.getLocalizedMessage(), (Object)this.mCause.getClass().getCanonicalName());
                }
                if (this.mPosition == SourcePosition.UNKNOWN && this.mCause instanceof SAXParseException && (lineNumber = (exception = (SAXParseException)this.mCause).getLineNumber()) != -1) {
                    this.mPosition = new SourcePosition(lineNumber - 1, exception.getColumnNumber() - 1, -1);
                }
            }
            if (this.mMessageText == null) {
                this.mMessageText = "Unknown error.";
            }
            return new MergingException(this.mCause, new Message(Message.Kind.ERROR, this.mMessageText, (String)MoreObjects.firstNonNull((Object)this.mOriginalMessageText, (Object)this.mMessageText), MergingException.RESOURCE_ASSET_MERGER_TOOL_NAME, new SourceFilePosition(this.mFile, this.mPosition), new SourceFilePosition[0]));
        }
    }
}

