/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.StringResourceContentHandler;
import com.android.ide.common.resources.StringResourceEscapeUtils;
import com.android.ide.common.resources.StringResourceUnescaperCharacterHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

final class StringResourceUnescaper {
    private StringResourceUnescaper() {
    }

    static String unescapeCharacterData(String xml) {
        if (xml.isEmpty()) {
            return "";
        }
        xml = StringResourceEscapeUtils.escapeCharacterReferences(xml);
        xml = StringResourceUnescaper.unescapeLeadingQuestionMarkOrAtSign(xml);
        StringBuilder builder = new StringBuilder(xml.length());
        try {
            StringResourceEscapeUtils.parse(xml, StringResourceUnescaper.newContentHandler(builder));
        }
        catch (SAXException exception) {
            throw new IllegalArgumentException(xml, exception);
        }
        xml = builder.toString();
        xml = StringResourceEscapeUtils.unescapeCharacterReferences(xml);
        return xml;
    }

    private static String unescapeLeadingQuestionMarkOrAtSign(String xml) {
        if (xml.startsWith("\\?") || xml.startsWith("\\@")) {
            return xml.substring(1, xml.length());
        }
        return xml;
    }

    private static ContentHandler newContentHandler(StringBuilder builder) {
        StringResourceUnescaperCharacterHandler handler = new StringResourceUnescaperCharacterHandler();
        return new StringResourceContentHandler(builder, handler);
    }
}

