/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.ide.common.gradle.model.IdeBuildType;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeSourceProvider;
import com.android.ide.common.gradle.model.IdeSourceProviderContainer;
import com.android.ide.common.gradle.model.ModelCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public final class IdeBuildTypeContainer
implements BuildTypeContainer,
Serializable {
    private static final long serialVersionUID = 2L;
    private final IdeBuildType myBuildType;
    private final IdeSourceProvider mySourceProvider;
    private final Collection<SourceProviderContainer> myExtraSourceProviders;
    private final int myHashCode;

    IdeBuildTypeContainer() {
        this.myBuildType = new IdeBuildType();
        this.mySourceProvider = new IdeSourceProvider();
        this.myExtraSourceProviders = Collections.emptyList();
        this.myHashCode = 0;
    }

    public IdeBuildTypeContainer(BuildTypeContainer container, ModelCache modelCache) {
        this.myBuildType = modelCache.computeIfAbsent(container.getBuildType(), buildType -> new IdeBuildType((BuildType)buildType, modelCache));
        this.mySourceProvider = modelCache.computeIfAbsent(container.getSourceProvider(), provider -> new IdeSourceProvider((SourceProvider)provider));
        this.myExtraSourceProviders = IdeModel.copy(container.getExtraSourceProviders(), modelCache, sourceProviderContainer -> new IdeSourceProviderContainer((SourceProviderContainer)sourceProviderContainer, modelCache));
        this.myHashCode = this.calculateHashCode();
    }

    public IdeBuildType getBuildType() {
        return this.myBuildType;
    }

    public IdeSourceProvider getSourceProvider() {
        return this.mySourceProvider;
    }

    public Collection<SourceProviderContainer> getExtraSourceProviders() {
        return this.myExtraSourceProviders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeBuildTypeContainer)) {
            return false;
        }
        IdeBuildTypeContainer container = (IdeBuildTypeContainer)o;
        return Objects.equals(this.myBuildType, container.myBuildType) && Objects.equals(this.mySourceProvider, container.mySourceProvider) && Objects.equals(this.myExtraSourceProviders, container.myExtraSourceProviders);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myBuildType, this.mySourceProvider, this.myExtraSourceProviders);
    }

    public String toString() {
        return "IdeBuildTypeContainer{myBuildType=" + this.myBuildType + ", mySourceProvider=" + this.mySourceProvider + ", myExtraSourceProviders=" + this.myExtraSourceProviders + '}';
    }
}

