/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.ProtoXmlPullParser;
import com.android.ide.common.util.PathString;
import com.android.ide.common.util.PathStrings;
import com.android.utils.XmlUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class AndroidManifestPackageNameUtils {
    public static String getPackageNameFromManifestFile(PathString manifestFile) throws IOException {
        String string;
        BufferedInputStream stream = new BufferedInputStream(PathStrings.inputStream(manifestFile));
        try {
            string = AndroidManifestPackageNameUtils.getPackageName(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (XmlPullParserException e) {
                throw new IOException("File " + manifestFile + " has invalid format");
            }
        }
        ((InputStream)stream).close();
        return string;
    }

    public static String getPackageNameFromResApk(ZipFile resApk) throws IOException {
        String string;
        ZipEntry zipEntry = resApk.getEntry("AndroidManifest.xml");
        if (zipEntry == null) {
            throw new IOException("\"AndroidManifest.xml\" not found in " + resApk.getName());
        }
        BufferedInputStream stream = new BufferedInputStream(resApk.getInputStream(zipEntry));
        try {
            string = AndroidManifestPackageNameUtils.getPackageName(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (XmlPullParserException e) {
                throw new IOException("Invalid AndroidManifest.xml in " + resApk.getName());
            }
        }
        ((InputStream)stream).close();
        return string;
    }

    private static String getPackageName(InputStream stream) throws XmlPullParserException, IOException {
        ProtoXmlPullParser parser;
        stream.mark(1);
        if (XmlUtils.isProtoXml((InputStream)stream)) {
            parser = new ProtoXmlPullParser();
        } else {
            parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        parser.setInput(stream, null);
        if (parser.nextTag() == 2) {
            return parser.getAttributeValue(null, "package");
        }
        return null;
    }
}

