/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.vectordrawable.VdOverrideInfo;
import com.android.ide.common.vectordrawable.VdParser;
import com.android.ide.common.vectordrawable.VdTree;
import com.android.utils.XmlUtils;
import com.google.common.base.Strings;
import com.google.common.math.DoubleMath;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VdPreview {
    private static final String ANDROID_ALPHA = "android:alpha";
    private static final String ANDROID_TINT = "android:tint";
    private static final String ANDROID_AUTO_MIRRORED = "android:autoMirrored";
    private static final String ANDROID_HEIGHT = "android:height";
    private static final String ANDROID_WIDTH = "android:width";
    private static final int MAX_PREVIEW_IMAGE_SIZE = 4096;
    private static final int MIN_PREVIEW_IMAGE_SIZE = 1;

    private static OutputFormat getPrettyPrintFormat() {
        OutputFormat format = new OutputFormat();
        format.setLineWidth(120);
        format.setIndenting(true);
        format.setIndent(4);
        format.setEncoding("UTF-8");
        format.setOmitComments(true);
        format.setOmitXMLDeclaration(true);
        return format;
    }

    public static String overrideXmlContent(Document document, VdOverrideInfo overrideInfo, StringBuilder errorLog) {
        String value;
        boolean contentChanged = false;
        Element root = document.getDocumentElement();
        if (overrideInfo.needsOverrideWidth() && VdPreview.setDimension(root, ANDROID_WIDTH, overrideInfo.getWidth())) {
            contentChanged = true;
        }
        if (overrideInfo.needsOverrideHeight() && VdPreview.setDimension(root, ANDROID_HEIGHT, overrideInfo.getHeight())) {
            contentChanged = true;
        }
        if (overrideInfo.needsOverrideAlpha() && VdPreview.setAttributeValue(root, ANDROID_ALPHA, value = XmlUtils.formatFloatValue((double)overrideInfo.getAlpha()))) {
            contentChanged = true;
        }
        if (overrideInfo.needsOverrideTint() && VdPreview.setAttributeValue(root, ANDROID_TINT, value = String.format("#%06X", overrideInfo.tintRgb()))) {
            contentChanged = true;
        }
        if (overrideInfo.getAutoMirrored() && VdPreview.setAttributeValue(root, ANDROID_AUTO_MIRRORED, "true")) {
            contentChanged = true;
        }
        if (contentChanged) {
            StringWriter stringOut;
            block8: {
                stringOut = new StringWriter();
                XMLSerializer serial = new XMLSerializer((Writer)stringOut, VdPreview.getPrettyPrintFormat());
                try {
                    serial.serialize(document);
                }
                catch (IOException e) {
                    if (errorLog == null) break block8;
                    errorLog.append("Exception while parsing XML file:\n").append(e.getMessage());
                }
            }
            return stringOut.toString();
        }
        return null;
    }

    private static boolean setDimension(Element element, String attrName, double value) {
        String newValue = XmlUtils.formatFloatValue((double)value) + "dp";
        return VdPreview.setAttributeValue(element, attrName, newValue);
    }

    private static boolean setAttributeValue(Element element, String attrName, String value) {
        String oldValue = element.getAttribute(attrName);
        element.setAttribute(attrName, value);
        return !value.equals(oldValue);
    }

    public static BufferedImage getPreviewFromVectorXml(TargetSize targetSize, String xmlFileContent, StringBuilder errorLog) {
        if (Strings.isNullOrEmpty((String)xmlFileContent)) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlFileContent.getBytes(StandardCharsets.UTF_8));
        VdTree vdTree = VdParser.parse(inputStream, errorLog);
        return VdPreview.getPreviewFromVectorTree(targetSize, vdTree, errorLog);
    }

    public static BufferedImage getPreviewFromVectorDocument(TargetSize targetSize, Document xml, StringBuilder vdErrorLog) {
        VdTree vdTree = new VdTree();
        vdTree.parse(xml);
        return VdPreview.getPreviewFromVectorTree(targetSize, vdTree, vdErrorLog);
    }

    public static BufferedImage getPreviewFromVectorTree(TargetSize targetSize, VdTree vdTree, StringBuilder errorLog) {
        double imageHeight;
        double imageWidth;
        double vdWidth = vdTree.getBaseWidth();
        double vdHeight = vdTree.getBaseHeight();
        int forceImageSize = targetSize.imageMaxDimension;
        double imageScale = targetSize.imageScale;
        if (forceImageSize > 0) {
            double maxVdSize = Math.max(vdWidth, vdHeight);
            double ratioToForceImageSize = (double)forceImageSize / maxVdSize;
            double scaledWidth = ratioToForceImageSize * vdWidth;
            double scaledHeight = ratioToForceImageSize * vdHeight;
            imageWidth = VdPreview.limitToInterval(scaledWidth, 1.0, 4096.0);
            imageHeight = VdPreview.limitToInterval(scaledHeight, 1.0, 4096.0);
            if (errorLog != null && (scaledWidth != imageWidth || scaledHeight != imageHeight)) {
                errorLog.append("Invalid image size, can't fit in a square whose size is ").append(forceImageSize);
            }
        } else {
            imageWidth = vdWidth * imageScale;
            imageHeight = vdHeight * imageScale;
        }
        BufferedImage image = AssetUtil.newArgbBufferedImage(DoubleMath.roundToInt((double)imageWidth, (RoundingMode)RoundingMode.HALF_UP), DoubleMath.roundToInt((double)imageHeight, (RoundingMode)RoundingMode.HALF_UP));
        vdTree.drawIntoImage(image);
        return image;
    }

    private static double limitToInterval(double value, double begin, double end) {
        return Math.max(begin, Math.min(end, value));
    }

    public static class TargetSize {
        private final int imageMaxDimension;
        private final double imageScale;

        private TargetSize(int maxDimension, double imageScale) {
            this.imageMaxDimension = maxDimension;
            this.imageScale = imageScale;
        }

        public static TargetSize createFromMaxDimension(int maxDimension) {
            return new TargetSize(maxDimension, 0.0);
        }

        public static TargetSize createFromScale(double imageScale) {
            return new TargetSize(0, imageScale);
        }
    }
}

