/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonEncodedGradleMessageParser
implements PatternAwareOutputParser {
    public static final String STDOUT_ERROR_TAG = "AGPBI: ";
    private static final Pattern MSG_PATTERN = Pattern.compile("^" + Pattern.quote("AGPBI: ") + "(.*)$");

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        Matcher m = MSG_PATTERN.matcher(line);
        if (!m.matches()) {
            return false;
        }
        String json = m.group(1);
        if (json.trim().isEmpty()) {
            return false;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        MessageJsonSerializer.registerTypeAdapters(gsonBuilder);
        Gson gson2 = gsonBuilder.create();
        try {
            Message msg = (Message)gson2.fromJson(json, Message.class);
            messages.add(msg);
            return true;
        }
        catch (JsonParseException e) {
            throw new ParsingFailedException(e);
        }
    }
}

