/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering;

import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HardwareConfigHelper {
    private final Device mDevice;
    private ScreenOrientation mScreenOrientation = ScreenOrientation.PORTRAIT;
    private int mMaxRenderWidth = -1;
    private int mMaxRenderHeight = -1;
    private int mOverrideRenderWidth = -1;
    private int mOverrideRenderHeight = -1;
    private static final Pattern GENERIC_PATTERN = Pattern.compile("(\\d+\\.?\\d*)\" (.+?)( \\(.*Nexus.*\\))?");

    public HardwareConfigHelper(Device device) {
        this.mDevice = device;
    }

    public HardwareConfigHelper setOrientation(ScreenOrientation screenOrientation) {
        this.mScreenOrientation = screenOrientation;
        return this;
    }

    public HardwareConfigHelper setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.mOverrideRenderWidth = overrideRenderWidth;
        this.mOverrideRenderHeight = overrideRenderHeight;
        return this;
    }

    public HardwareConfigHelper setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.mMaxRenderWidth = maxRenderWidth;
        this.mMaxRenderHeight = maxRenderHeight;
        return this;
    }

    public HardwareConfig getConfig() {
        int height;
        int width;
        int y;
        Screen screen = this.mDevice.getDefaultHardware().getScreen();
        int x = screen.getXDimension();
        if (x > (y = screen.getYDimension())) {
            if (this.mScreenOrientation == ScreenOrientation.LANDSCAPE) {
                width = x;
                height = y;
            } else {
                width = y;
                height = x;
            }
        } else if (this.mScreenOrientation == ScreenOrientation.LANDSCAPE) {
            width = y;
            height = x;
        } else {
            width = x;
            height = y;
        }
        if (this.mOverrideRenderHeight != -1) {
            width = this.mOverrideRenderWidth;
        }
        if (this.mOverrideRenderHeight != -1) {
            height = this.mOverrideRenderHeight;
        }
        if (this.mMaxRenderWidth != -1) {
            width = this.mMaxRenderWidth;
        }
        if (this.mMaxRenderHeight != -1) {
            height = this.mMaxRenderHeight;
        }
        return new HardwareConfig(width, height, screen.getPixelDensity(), (float)screen.getXdpi(), (float)screen.getYdpi(), screen.getSize(), this.mScreenOrientation, this.mDevice.getDefaultHardware().getScreen().getScreenRound(), this.mDevice.getDefaultHardware().getButtonType() == ButtonType.SOFT);
    }

    public static String getNexusLabel(Device device) {
        String name = device.getDisplayName();
        Screen screen = device.getDefaultHardware().getScreen();
        float length = (float)screen.getDiagonalLength();
        length = (float)Math.round(10.0f * length) / 10.0f;
        return String.format(Locale.US, "%1$s (%3$s\", %2$s)", name, HardwareConfigHelper.getResolutionString(device), Float.toString(length));
    }

    public static String getNexusMenuLabel(Device device) {
        String name = device.getDisplayName();
        if (HardwareConfigHelper.isTv(device)) {
            if (name.startsWith("Android TV (") && (name = name.substring("Android TV (".length())).endsWith(")")) {
                name = name.substring(0, name.length() - 1);
            }
            return String.format(Locale.US, "%1$s, %2$s (TV)", name, HardwareConfigHelper.getResolutionString(device));
        }
        if (HardwareConfigHelper.isWear(device)) {
            if (name.startsWith("Android Wear ")) {
                name = name.substring("Android Wear ".length());
            } else if (name.startsWith("Wear OS ")) {
                name = name.substring("Wear OS ".length());
            }
            return String.format(Locale.US, "%1$s (%2$s)", HardwareConfigHelper.getResolutionString(device), name);
        }
        if (name.endsWith(")")) {
            name = name.replace("(", "").replace(")", "");
        }
        Screen screen = device.getDefaultHardware().getScreen();
        float length = (float)screen.getDiagonalLength();
        length = (float)Math.round(10.0f * length) / 10.0f;
        return String.format(Locale.US, "%1$s, %2$s (%3$s)", Float.toString(length), HardwareConfigHelper.getResolutionString(device), name);
    }

    public static String getGenericLabel(Device device) {
        Object name = device.getDisplayName();
        Matcher matcher = GENERIC_PATTERN.matcher((CharSequence)name);
        if (matcher.matches()) {
            Object size = matcher.group(1);
            String n = matcher.group(2);
            int dot = ((String)size).indexOf(46);
            if (dot == -1) {
                size = (String)size + ".0";
                dot = ((String)size).length() - 2;
            }
            for (int i = 0; i < 2 - dot; ++i) {
                size = " " + (String)size;
            }
            name = (String)size + "\" " + n;
        }
        return String.format(Locale.US, "%1$s (%2$s)", name, HardwareConfigHelper.getResolutionString(device));
    }

    public static String getResolutionString(Device device) {
        Screen screen = device.getDefaultHardware().getScreen();
        return String.format(Locale.US, "%1$d \u00d7 %2$d, %3$s", screen.getXDimension(), screen.getYDimension(), screen.getPixelDensity().getResourceValue());
    }

    public static boolean isGeneric(Device device) {
        return "Generic".equals(device.getManufacturer());
    }

    public static boolean isNexus(Device device) {
        return "Google".equals(device.getManufacturer());
    }

    public static boolean isWear(Device device) {
        return device != null && "android-wear".equals(device.getTagId());
    }

    public static boolean isThings(Device device) {
        return device != null && "android-things".equals(device.getTagId());
    }

    public static boolean isTv(Device device) {
        return device != null && "android-tv".equals(device.getTagId());
    }

    public static boolean isAutomotive(Device device) {
        return device != null && ("android-automotive".equals(device.getTagId()) || "android-automotive-playstore".equals(device.getTagId()));
    }

    public static boolean isDesktop(Device device) {
        return device != null && "android-desktop".equals(device.getTagId());
    }

    public static boolean isMobile(Device device) {
        return !HardwareConfigHelper.isTv(device) && !HardwareConfigHelper.isWear(device) && !HardwareConfigHelper.isThings(device) && !HardwareConfigHelper.isAutomotive(device) && !HardwareConfigHelper.isDesktop(device);
    }

    public static int nexusRank(Device device) {
        String id;
        switch (id = device.getId()) {
            case "Nexus One": {
                return 1;
            }
            case "Nexus S": {
                return 2;
            }
            case "Galaxy Nexus": {
                return 3;
            }
            case "Nexus 7": {
                return 4;
            }
            case "Nexus 10": {
                return 5;
            }
            case "Nexus 4": {
                return 6;
            }
            case "Nexus 7 2013": {
                return 7;
            }
            case "Nexus 5": {
                return 8;
            }
            case "Nexus 9": {
                return 9;
            }
            case "Nexus 6": {
                return 10;
            }
            case "pixel_c": {
                return 11;
            }
            case "Nexus 6P": {
                return 12;
            }
            case "Nexus 5X": {
                return 13;
            }
            case "pixel": {
                return 14;
            }
            case "pixel_xl": {
                return 15;
            }
        }
        return 100;
    }

    public static void sortNexusListByRank(List<Device> list) {
        Collections.sort(list, (device1, device2) -> HardwareConfigHelper.nexusRank(device2) - HardwareConfigHelper.nexusRank(device1));
    }

    public static void sortDevicesByScreenSize(List<Device> list) {
        Collections.sort(list, (device1, device2) -> {
            Screen screen1 = device1.getDefaultHardware().getScreen();
            float length1 = (float)screen1.getDiagonalLength();
            Screen screen2 = device2.getDefaultHardware().getScreen();
            float length2 = (float)screen2.getDiagonalLength();
            return (int)Math.signum(length1 - length2);
        });
    }
}

