/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.AssetFile;
import com.android.ide.common.resources.AssetItem;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergeWriter;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.inject.Inject;

public class MergedAssetWriter
extends MergeWriter<AssetItem, AssetWorkParameters> {
    private static final int MIN_JOBS_PER_BUCKET = 3;
    private static final int MAX_BUCKETS = 10;
    private final Map<String, AssetItem> addedItems = new HashMap<String, AssetItem>();
    private final List<AssetItem> removedItems = new ArrayList<AssetItem>();

    public MergedAssetWriter(File rootFolder, WorkerExecutorFacade facade) {
        super(rootFolder, facade);
    }

    @Override
    public void addItem(AssetItem item) throws MergeConsumer.ConsumerException {
        if (item.isTouched()) {
            this.addedItems.put(item.getName(), item);
        }
    }

    private List<List<AssetItem>> createBuckets() {
        ArrayList<List<AssetItem>> jobBuckets = new ArrayList<List<AssetItem>>();
        int totalJobs = this.addedItems.values().size();
        if (totalJobs <= 3) {
            jobBuckets.add(new ArrayList<AssetItem>(this.addedItems.values()));
        } else {
            int bucketCount = Math.min(totalJobs / 3, 10);
            for (int bucket = 0; bucket < bucketCount; ++bucket) {
                jobBuckets.add(new ArrayList());
            }
            Iterator<AssetItem> jobsIterator = this.addedItems.values().iterator();
            int currBucket = 0;
            while (jobsIterator.hasNext()) {
                ((List)jobBuckets.get(currBucket)).add(jobsIterator.next());
                currBucket = (currBucket + 1) % bucketCount;
            }
        }
        return jobBuckets;
    }

    @Override
    protected void postWriteAction() throws MergeConsumer.ConsumerException {
        for (AssetItem removedItem : this.removedItems) {
            File removedFile = new File(this.getRootFolder(), removedItem.getName());
            removedFile.delete();
        }
        List<List<AssetItem>> jobBuckets = this.createBuckets();
        for (List<AssetItem> bucket : jobBuckets) {
            this.getExecutor().submit(new AssetWorkAction(new AssetWorkParameters(bucket, this.getRootFolder())));
        }
    }

    @Override
    public void removeItem(AssetItem removedItem, AssetItem replacedBy) throws MergeConsumer.ConsumerException {
        if (replacedBy == null) {
            this.addedItems.remove(removedItem.getName());
            this.removedItems.add(removedItem);
        }
    }

    @Override
    public boolean ignoreItemInMerge(AssetItem item) {
        return false;
    }

    public static class AssetWorkAction
    implements WorkerExecutorFacade.WorkAction {
        private final List<AssetItem> assetItemBucket;
        private final File rootFolder;

        @Inject
        public AssetWorkAction(AssetWorkParameters parameters) {
            this.assetItemBucket = parameters.assetItemBucket;
            this.rootFolder = parameters.rootFolder;
        }

        @Override
        public void run() {
            for (AssetItem item : this.assetItemBucket) {
                try {
                    AssetFile assetFile = (AssetFile)Preconditions.checkNotNull((Object)((AssetFile)item.getSourceFile()));
                    Path fromFile = assetFile.getFile().toPath();
                    Path toFile = new File(this.rootFolder, item.getKey().replace('/', File.separatorChar)).toPath();
                    Files.createDirectories(toFile.getParent(), new FileAttribute[0]);
                    if (item.shouldBeUnGzipped()) {
                        GZIPInputStream gzipInputStream = new GZIPInputStream(new BufferedInputStream(Files.newInputStream(fromFile, new OpenOption[0])));
                        try {
                            Files.copy(gzipInputStream, toFile, StandardCopyOption.REPLACE_EXISTING);
                            continue;
                        }
                        finally {
                            gzipInputStream.close();
                            continue;
                        }
                    }
                    FileUtils.copyFile((Path)fromFile, (Path)toFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class AssetWorkParameters
    implements Serializable {
        public final List<AssetItem> assetItemBucket;
        public final File rootFolder;

        private AssetWorkParameters(List<AssetItem> assetItemBucket, File rootFolder) {
            this.assetItemBucket = assetItemBucket;
            this.rootFolder = rootFolder;
        }
    }
}

