/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.usage;

public class WebTokenizers {
    private final WebTokensCallback callback;

    public WebTokenizers(WebTokensCallback callback) {
        this.callback = callback;
    }

    public void tokenizeHtml(String html) {
        int length = html.length();
        boolean STATE_TEXT = true;
        int STATE_SLASH = 2;
        int STATE_ATTRIBUTE_NAME = 3;
        int STATE_BEFORE_TAG = 4;
        int STATE_IN_TAG = 5;
        int STATE_BEFORE_ATTRIBUTE = 6;
        int STATE_ATTRIBUTE_BEFORE_EQUALS = 7;
        int STATE_ATTRIBUTE_AFTER_EQUALS = 8;
        int STATE_ATTRIBUTE_VALUE_NONE = 9;
        int STATE_ATTRIBUTE_VALUE_SINGLE = 10;
        int STATE_ATTRIBUTE_VALUE_DOUBLE = 11;
        int STATE_CLOSE_TAG = 12;
        int STATE_ENDING_TAG = 13;
        int state = 1;
        int offset = 0;
        int valueStart = 0;
        int tagStart = 0;
        String tag = null;
        String attribute = null;
        int attributeStart = 0;
        int prev = -1;
        block15: while (offset < length && (offset != prev || ++offset != length)) {
            prev = offset;
            char c = html.charAt(offset);
            switch (state) {
                case 1: {
                    if (c == '<') {
                        state = 2;
                        ++offset;
                        continue block15;
                    }
                    ++offset;
                    continue block15;
                }
                case 2: {
                    int end;
                    if (c == '!') {
                        if (html.startsWith("!--", offset)) {
                            end = html.indexOf("-->", offset + 3);
                            if (end == -1) {
                                offset = length;
                                continue block15;
                            }
                            state = 1;
                            offset = end + 3;
                            continue block15;
                        }
                        if (html.startsWith("![CDATA[", offset)) {
                            end = html.indexOf("]]>", offset + 8);
                            if (end == -1) {
                                offset = length;
                                continue block15;
                            }
                            state = 1;
                            offset = end + 3;
                            continue block15;
                        }
                    } else {
                        if (c == '/') {
                            state = 12;
                            ++offset;
                            continue block15;
                        }
                        if (c == '?') {
                            end = html.indexOf(62, offset + 2);
                            if (end == -1) {
                                offset = length;
                                state = 1;
                                continue block15;
                            }
                            offset = end + 1;
                            state = 1;
                            continue block15;
                        }
                    }
                    state = 5;
                    tagStart = offset;
                    continue block15;
                }
                case 12: {
                    if (c == '>') {
                        state = 1;
                    }
                    ++offset;
                    continue block15;
                }
                case 4: {
                    if (!Character.isWhitespace(c)) {
                        state = 5;
                        tagStart = offset;
                    }
                    ++offset;
                    continue block15;
                }
                case 5: {
                    if (Character.isWhitespace(c)) {
                        state = 6;
                        tag = html.substring(tagStart, offset).trim();
                    } else if (c == '>') {
                        tag = html.substring(tagStart, offset).trim();
                        this.endHtmlTag(html, offset, tag);
                        state = 1;
                    } else if (c == '/') {
                        tag = html.substring(tagStart, offset).trim();
                        this.endHtmlTag(html, offset, tag);
                        state = 13;
                    }
                    ++offset;
                    continue block15;
                }
                case 13: {
                    if (c != '>') continue block15;
                    ++offset;
                    state = 1;
                    continue block15;
                }
                case 6: {
                    if (c == '>') {
                        this.endHtmlTag(html, offset, tag);
                        state = 1;
                    } else if (c != '/' && !Character.isWhitespace(c)) {
                        state = 3;
                        attributeStart = offset;
                    }
                    ++offset;
                    continue block15;
                }
                case 3: {
                    if (c == '>') {
                        this.endHtmlTag(html, offset, tag);
                        state = 1;
                    } else if (c == '=') {
                        attribute = html.substring(attributeStart, offset);
                        state = 8;
                    } else if (Character.isWhitespace(c)) {
                        attribute = html.substring(attributeStart, offset);
                        state = 7;
                    }
                    ++offset;
                    continue block15;
                }
                case 7: {
                    if (c == '=') {
                        state = 8;
                    } else if (c == '>') {
                        this.endHtmlTag(html, offset, tag);
                        state = 1;
                    } else if (!Character.isWhitespace(c)) {
                        state = 3;
                        attributeStart = offset;
                    }
                    ++offset;
                    continue block15;
                }
                case 8: {
                    if (c == '\'') {
                        state = 10;
                        valueStart = offset + 1;
                    } else if (c == '\"') {
                        state = 11;
                        valueStart = offset + 1;
                    } else if (!Character.isWhitespace(c)) {
                        state = 9;
                        valueStart = offset + 1;
                    }
                    ++offset;
                    continue block15;
                }
                case 10: {
                    if (c == '\'') {
                        state = 6;
                        this.recordHtmlAttributeValue(tag, attribute, html.substring(valueStart, offset));
                    }
                    ++offset;
                    continue block15;
                }
                case 11: {
                    if (c == '\"') {
                        state = 6;
                        this.recordHtmlAttributeValue(tag, attribute, html.substring(valueStart, offset));
                    }
                    ++offset;
                    continue block15;
                }
                case 9: {
                    if (c == '>') {
                        this.recordHtmlAttributeValue(tag, attribute, html.substring(valueStart, offset));
                        this.endHtmlTag(html, offset, tag);
                        state = 1;
                    } else if (Character.isWhitespace(c)) {
                        state = 6;
                        this.recordHtmlAttributeValue(tag, attribute, html.substring(valueStart, offset));
                    }
                    ++offset;
                    continue block15;
                }
            }
            assert (false) : state;
        }
    }

    private void endHtmlTag(String html, int offset, String tag) {
        int end;
        if ("script".equals(tag)) {
            int end2 = html.indexOf("</script>", offset + 1);
            if (end2 != -1) {
                String js = html.substring(offset + 1, end2);
                this.tokenizeJs(js);
            }
        } else if ("style".equals(tag) && (end = html.indexOf("</style>", offset + 1)) != -1) {
            String css = html.substring(offset + 1, end);
            this.tokenizeCss(css);
        }
    }

    private void recordHtmlAttributeValue(String tagName, String attribute, String value) {
        this.callback.referencedHtmlAttribute(tagName, attribute, value);
    }

    public void tokenizeJs(String js) {
        int length = js.length();
        boolean STATE_INIT = true;
        int STATE_SLASH = 2;
        int STATE_STRING_DOUBLE = 3;
        int STATE_STRING_DOUBLE_QUOTED = 4;
        int STATE_STRING_SINGLE = 5;
        int STATE_STRING_SINGLE_QUOTED = 6;
        int state = 1;
        int offset = 0;
        int stringStart = 0;
        int prev = -1;
        block8: while (offset < length && (offset != prev || ++offset != length)) {
            prev = offset;
            char c = js.charAt(offset);
            switch (state) {
                case 1: {
                    if (c == '/') {
                        state = 2;
                    } else if (c == '\"') {
                        stringStart = offset + 1;
                        state = 3;
                    } else if (c == '\'') {
                        stringStart = offset + 1;
                        state = 5;
                    }
                    ++offset;
                    continue block8;
                }
                case 2: {
                    int end;
                    if (c == '*') {
                        state = 1;
                        end = js.indexOf("*/", offset + 1);
                        if (end == -1) {
                            offset = length;
                            continue block8;
                        }
                        offset = end + 2;
                        continue block8;
                    }
                    if (c == '/') {
                        state = 1;
                        end = js.indexOf(10, offset + 1);
                        if (end == -1) {
                            offset = length;
                            continue block8;
                        }
                        offset = end + 1;
                        continue block8;
                    }
                    state = 1;
                    ++offset;
                    continue block8;
                }
                case 3: {
                    if (c == '\"') {
                        this.callback.referencedJsString(js.substring(stringStart, offset));
                        state = 1;
                    } else if (c == '\\') {
                        state = 4;
                    }
                    ++offset;
                    continue block8;
                }
                case 4: {
                    state = 3;
                    ++offset;
                    continue block8;
                }
                case 5: {
                    if (c == '\'') {
                        this.callback.referencedJsString(js.substring(stringStart, offset));
                        state = 1;
                    } else if (c == '\\') {
                        state = 6;
                    }
                    ++offset;
                    continue block8;
                }
                case 6: {
                    state = 5;
                    ++offset;
                    continue block8;
                }
            }
            assert (false) : state;
        }
    }

    public void tokenizeCss(String css) {
        int length = css.length();
        boolean STATE_INIT = true;
        int STATE_SLASH = 2;
        int state = 1;
        int offset = 0;
        int prev = -1;
        block4: while (offset < length && (offset != prev || ++offset != length)) {
            prev = offset;
            char c = css.charAt(offset);
            switch (state) {
                case 1: {
                    char prevChar;
                    if (c == '/') {
                        state = 2;
                    } else if (c == 'u' && css.startsWith("url(", offset) && offset > 0 && (Character.isWhitespace(prevChar = css.charAt(offset - 1)) || prevChar == ':')) {
                        int end = css.indexOf(41, offset);
                        offset += 4;
                        while (offset < length && Character.isWhitespace(css.charAt(offset))) {
                            ++offset;
                        }
                        if (end != -1 && end > offset + 1) {
                            while (end > offset && Character.isWhitespace(css.charAt(end - 1))) {
                                --end;
                            }
                            if (css.charAt(offset) == '\"' && css.charAt(end - 1) == '\"' || css.charAt(offset) == '\'' && css.charAt(end - 1) == '\'') {
                                ++offset;
                                --end;
                            }
                            this.callback.referencedCssUrl(css.substring(offset, end).trim());
                        }
                        offset = end + 1;
                        continue block4;
                    }
                    ++offset;
                    continue block4;
                }
                case 2: {
                    if (c == '*') {
                        int end = css.indexOf("*/", offset + 1);
                        if (end == -1) {
                            offset = length;
                            continue block4;
                        }
                        offset = end + 2;
                        continue block4;
                    }
                    state = 1;
                    ++offset;
                    continue block4;
                }
            }
            assert (false) : state;
        }
    }

    public static interface WebTokensCallback {
        public void referencedHtmlAttribute(String var1, String var2, String var3);

        public void referencedJsString(String var1);

        public void referencedCssUrl(String var1);
    }
}

