/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.repository.AliasStyle;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\f\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a4\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\bH\u0002\u001a\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\"\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0002\u001a\"\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a$\u0010\u0017\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\u001c\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\u001c\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\u001c\u0010\u001d\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\f\u0010\u001e\u001a\u00020\u0012*\u00020\u000eH\u0002\u001a\f\u0010\u001f\u001a\u00020\u0012*\u00020\u0001H\u0002\u001a\f\u0010 \u001a\u00020!*\u00020!H\u0002\u001a\f\u0010\"\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010#\u001a\u00020\u0001*\u00020\u0001H\u0001\u00a8\u0006$"}, d2={"cutDomainPrefix", "", "group", "generateWithSuffix", "prefix", "reserved", "", "transform", "Lkotlin/Function1;", "getAliasStyle", "Lcom/android/ide/common/repository/AliasStyle;", "reservedAliases", "getGroupPrefix", "dependency", "Lcom/android/ide/common/gradle/Dependency;", "getMaybeTransformToCamelCase", "getMaybeTransformVersionToCamelCase", "keysMatch", "", "s1", "s2", "maybeLowCamelTransform", "name", "pickLibraryVariableName", "includeVersionInKey", "caseSensitiveReserved", "pickPluginVariableName", "pluginId", "pickPluginVersionVariableName", "pickVersionVariableName", "isAndroidX", "isCommonDomain", "normalize", "", "toSafeHyphenKey", "toSafeKey", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nVersionCatalogNamingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionCatalogNamingUtil.kt\ncom/android/ide/common/repository/VersionCatalogNamingUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,406:1\n1747#2,3:407\n1064#3,2:410\n1#4:412\n*S KotlinDebug\n*F\n+ 1 VersionCatalogNamingUtil.kt\ncom/android/ide/common/repository/VersionCatalogNamingUtilKt\n*L\n59#1:407,3\n181#1:410,2\n*E\n"})
public final class VersionCatalogNamingUtilKt {
    private static final boolean isAndroidX(Dependency $this$isAndroidX) {
        String string = $this$isAndroidX.getGroup();
        return string != null ? StringsKt.startsWith$default((String)string, (String)"androidx.", (boolean)false, (int)2, null) : false;
    }

    @NotNull
    public static final String pickLibraryVariableName(@NotNull Dependency dependency, boolean includeVersionInKey, @NotNull Set<String> caseSensitiveReserved) {
        String name;
        String groupId;
        String full;
        String fullSafe;
        String artifactId;
        String artifactKey;
        String versionSuffix;
        Function1<String, String> transform;
        TreeSet reserved;
        block20: {
            String key;
            block21: {
                boolean bl;
                block19: {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
                    Intrinsics.checkNotNullParameter(caseSensitiveReserved, (String)"caseSensitiveReserved");
                    reserved = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
                    reserved.addAll(caseSensitiveReserved);
                    transform = VersionCatalogNamingUtilKt.getMaybeTransformToCamelCase(reserved);
                    RichVersion richVersion = dependency.getVersion();
                    String versionIdentifier = richVersion != null ? richVersion.toIdentifier() : null;
                    if (versionIdentifier == null) {
                        object = "";
                    } else if (!includeVersionInKey) {
                        object = "";
                    } else {
                        CharSequence charSequence = versionIdentifier;
                        Regex regex = new Regex("[^A-Za-z0-9]");
                        String string = "";
                        object = versionSuffix = "-" + VersionCatalogNamingUtilKt.toSafeKey("v" + regex.replace(charSequence, string));
                    }
                    if (!VersionCatalogNamingUtilKt.isAndroidX(dependency)) break block20;
                    if (reserved.isEmpty()) break block21;
                    Iterable $this$any$iv = reserved;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!StringsKt.startsWith$default((String)it, (String)"androidx-", (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block19;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block20;
            }
            if (!reserved.contains(key = (String)transform.invoke((Object)("androidx-" + VersionCatalogNamingUtilKt.toSafeKey(dependency.getName()) + versionSuffix)))) {
                return key;
            }
        }
        if (!reserved.contains(artifactKey = (String)transform.invoke((Object)((artifactId = VersionCatalogNamingUtilKt.toSafeKey(dependency.getName())) + versionSuffix)))) {
            return artifactKey;
        }
        String string = dependency.getGroup();
        if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)) == null || (string = VersionCatalogNamingUtilKt.toSafeKey(string)) == null) {
            string = "nogroup";
        }
        String groupSuffix = string;
        String withGroupSuffix = (String)transform.invoke((Object)(groupSuffix + "-" + artifactId + versionSuffix));
        if (!StringsKt.startsWith$default((String)artifactId, (String)groupSuffix, (boolean)false, (int)2, null) && !reserved.contains(withGroupSuffix)) {
            return withGroupSuffix;
        }
        String groupPrefix = VersionCatalogNamingUtilKt.getGroupPrefix(dependency);
        String withGroupPrefix = (String)transform.invoke((Object)(groupPrefix + "-" + artifactId + versionSuffix));
        if (!reserved.contains(withGroupPrefix)) {
            return withGroupPrefix;
        }
        String string2 = dependency.getGroup();
        if (string2 == null || (string2 = VersionCatalogNamingUtilKt.toSafeKey(string2)) == null) {
            string2 = "nogroup";
        }
        if (!reserved.contains(fullSafe = (String)transform.invoke((Object)(full = (groupId = string2) + "-" + artifactId + versionSuffix)))) {
            return fullSafe;
        }
        int id = 2;
        while (reserved.contains(name = (String)transform.invoke((Object)(full + (((CharSequence)versionSuffix).length() > 0 ? "-x" : "") + id++)))) {
        }
        return name;
    }

    private static final Function1<String, String> getMaybeTransformToCamelCase(Set<String> reserved) {
        AliasStyle aliasStyle = VersionCatalogNamingUtilKt.getAliasStyle(reserved);
        boolean haveCamelCase = aliasStyle.component1();
        boolean haveHyphen = aliasStyle.component2();
        boolean camelCaseOutput = haveCamelCase && !haveHyphen;
        return (Function1)new Function1<String, String>(camelCaseOutput){
            final /* synthetic */ boolean $camelCaseOutput;
            {
                this.$camelCaseOutput = $camelCaseOutput;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String alias) {
                String string;
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                String safeAlias = VersionCatalogNamingUtilKt.toSafeHyphenKey(alias);
                if (this.$camelCaseOutput && StringsKt.contains$default((CharSequence)safeAlias, (CharSequence)"-", (boolean)false, (int)2, null)) {
                    String string2 = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, VersionCatalogNamingUtilKt.toSafeHyphenKey(alias));
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            CaseFormat\u2026afeHyphenKey())\n        }");
                } else {
                    string = alias;
                }
                return string;
            }
        };
    }

    private static final Function1<String, String> getMaybeTransformVersionToCamelCase(Set<String> reserved) {
        AliasStyle aliasStyle = VersionCatalogNamingUtilKt.getAliasStyle(reserved);
        boolean haveCamelCase = aliasStyle.component1();
        boolean haveHyphen = aliasStyle.component2();
        boolean camelCaseOutput = haveCamelCase || !haveHyphen;
        return (Function1)new Function1<String, String>(camelCaseOutput){
            final /* synthetic */ boolean $camelCaseOutput;
            {
                this.$camelCaseOutput = $camelCaseOutput;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String version) {
                String string;
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                if (this.$camelCaseOutput) {
                    String string2 = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, version);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, version)");
                } else {
                    string = version;
                }
                return string;
            }
        };
    }

    @NotNull
    public static final String pickPluginVariableName(@NotNull String pluginId, @NotNull Set<String> caseSensitiveReserved) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter(caseSensitiveReserved, (String)"caseSensitiveReserved");
        TreeSet reserved = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        reserved.addAll(caseSensitiveReserved);
        Function1<String, String> transform = VersionCatalogNamingUtilKt.getMaybeTransformToCamelCase(reserved);
        String plugin = VersionCatalogNamingUtilKt.cutDomainPrefix(pluginId);
        String shortName = (String)transform.invoke((Object)VersionCatalogNamingUtilKt.toSafeHyphenKey(plugin));
        if (!reserved.contains(shortName)) {
            return shortName;
        }
        String fullName = (String)transform.invoke((Object)VersionCatalogNamingUtilKt.toSafeHyphenKey(pluginId));
        if (!reserved.contains(fullName)) {
            return fullName;
        }
        return VersionCatalogNamingUtilKt.generateWithSuffix(fullName + "X", reserved, transform);
    }

    private static final String maybeLowCamelTransform(String name) {
        String string;
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"-", (boolean)false, (int)2, null)) {
            String string2 = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name)");
        } else {
            string = name;
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public static final String toSafeKey(@NotNull String $this$toSafeKey) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$toSafeKey, (String)"<this>");
        if (((CharSequence)$this$toSafeKey).length() == 0) {
            return "empty";
        }
        if ($this$toSafeKey.length() == 1 && Character.isLowerCase(Character.toLowerCase($this$toSafeKey.charAt(0)))) {
            return Character.toLowerCase($this$toSafeKey.charAt(0)) + "x";
        }
        if ($this$toSafeKey.length() == 1) {
            return "xx";
        }
        if (Character.isLowerCase($this$toSafeKey.charAt(0))) {
            boolean bl;
            block12: {
                CharSequence $this$all$iv = $this$toSafeKey;
                boolean $i$f$all = false;
                for (n = 0; n < $this$all$iv.length(); ++n) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(n);
                    boolean bl2 = false;
                    if (VersionCatalogNamingUtilKt.toSafeKey$isSafe(it)) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
            if (bl) {
                return $this$toSafeKey;
            }
        }
        StringBuilder sb = new StringBuilder();
        char c = Character.toLowerCase($this$toSafeKey.charAt(0));
        boolean bl = false;
        sb.append(Character.isLowerCase(c) ? c : (char)'x');
        String string = $this$toSafeKey.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = string;
        int n2 = string2.length();
        for (n = 0; n < n2; ++n) {
            char c2 = string2.charAt(n);
            if (VersionCatalogNamingUtilKt.toSafeKey$isSafe(c2)) {
                sb.append(c2);
                continue;
            }
            if (VersionCatalogNamingUtilKt.toSafeKey$isSafe(Character.toLowerCase(c2))) {
                sb.append(Character.toLowerCase(c2));
                continue;
            }
            if (VersionCatalogNamingUtilKt.toSafeKey$isSeparator(c2)) {
                if (VersionCatalogNamingUtilKt.toSafeKey$isSeparator(sb.charAt(sb.length() - 1))) continue;
                sb.append(c2);
                continue;
            }
            if (c2 == '.') {
                if (VersionCatalogNamingUtilKt.toSafeKey$isSeparator(sb.charAt(sb.length() - 1))) continue;
                sb.append('-');
                continue;
            }
            if (VersionCatalogNamingUtilKt.toSafeKey$isSeparator(sb.charAt(sb.length() - 1))) continue;
            sb.append('_');
        }
        if (sb.length() == 1 || VersionCatalogNamingUtilKt.toSafeKey$isSeparator(sb.charAt(sb.length() - 1))) {
            sb.append('z');
        }
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sb.toString()");
        return string3;
    }

    @NotNull
    public static final String toSafeHyphenKey(@NotNull String $this$toSafeHyphenKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toSafeHyphenKey, (String)"<this>");
        return StringsKt.replace$default((String)VersionCatalogNamingUtilKt.toSafeKey($this$toSafeHyphenKey), (String)"_", (String)"-", (boolean)false, (int)4, null);
    }

    private static final String getGroupPrefix(Dependency dependency) {
        String string = dependency.getGroup();
        if (string == null) {
            return "nogroup";
        }
        String group = string;
        String groupPrefix = VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringBefore$default((String)group, (char)'.', null, (int)2, null));
        if (VersionCatalogNamingUtilKt.isCommonDomain(groupPrefix)) {
            return VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)group, (char)'.', null, (int)2, null), (char)'.', null, (int)2, null));
        }
        return VersionCatalogNamingUtilKt.toSafeKey(groupPrefix);
    }

    private static final boolean isCommonDomain(String $this$isCommonDomain) {
        return Intrinsics.areEqual((Object)$this$isCommonDomain, (Object)"com") || Intrinsics.areEqual((Object)$this$isCommonDomain, (Object)"org") || Intrinsics.areEqual((Object)$this$isCommonDomain, (Object)"io");
    }

    private static final String cutDomainPrefix(String group) {
        String groupPrefix = VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringBefore$default((String)group, (char)'.', null, (int)2, null));
        if (VersionCatalogNamingUtilKt.isCommonDomain(groupPrefix) || Intrinsics.areEqual((Object)groupPrefix, (Object)"androidx")) {
            return VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringAfter$default((String)group, (char)'.', null, (int)2, null));
        }
        return VersionCatalogNamingUtilKt.toSafeKey(groupPrefix);
    }

    @NotNull
    public static final String pickVersionVariableName(@NotNull Dependency dependency, @NotNull Set<String> caseSensitiveReserved) {
        String groupId;
        String withGroupId;
        String transformedWithGroupId;
        String artifactName;
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter(caseSensitiveReserved, (String)"caseSensitiveReserved");
        String artifact = VersionCatalogNamingUtilKt.toSafeKey(dependency.getName());
        TreeSet reserved = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        reserved.addAll(caseSensitiveReserved);
        Function1<String, String> transform = VersionCatalogNamingUtilKt.getMaybeTransformVersionToCamelCase(reserved);
        if (reserved.isEmpty()) {
            return (String)transform.invoke((Object)artifact);
        }
        if (!((Collection)reserved).isEmpty()) {
            String withVersion;
            Object e = reserved.first();
            Intrinsics.checkNotNullExpressionValue(e, (String)"reserved.first()");
            String string = ((String)e).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (StringsKt.endsWith$default((String)string, (String)"version", (boolean)false, (int)2, null) && !reserved.contains(withVersion = (String)transform.invoke((Object)(artifact + "-version")))) {
                return withVersion;
            }
        }
        if (!reserved.contains(artifactName = (String)transform.invoke((Object)artifact))) {
            return artifactName;
        }
        String withVersion = (String)transform.invoke((Object)(artifact + "-version"));
        if (!reserved.contains(withVersion)) {
            return withVersion;
        }
        String groupPrefix = VersionCatalogNamingUtilKt.getGroupPrefix(dependency);
        String withGroupIdPrefix = (String)transform.invoke((Object)(groupPrefix + "-" + artifact));
        if (!reserved.contains(withGroupIdPrefix)) {
            return withGroupIdPrefix;
        }
        String withGroupIdPrefixVersion = (String)transform.invoke((Object)(groupPrefix + "-" + artifact + "-version"));
        if (!reserved.contains(withGroupIdPrefixVersion)) {
            return withGroupIdPrefixVersion;
        }
        String string = dependency.getGroup();
        if (string == null || (string = VersionCatalogNamingUtilKt.toSafeKey(string)) == null) {
            string = "nogroup";
        }
        if (!reserved.contains(transformedWithGroupId = (String)transform.invoke((Object)(withGroupId = (groupId = string) + "-" + artifact)))) {
            return transformedWithGroupId;
        }
        return VersionCatalogNamingUtilKt.generateWithSuffix(withGroupId, reserved, transform);
    }

    private static final AliasStyle getAliasStyle(Set<String> reservedAliases) {
        boolean haveCamelCase = false;
        boolean haveHyphen = false;
        for (String name : reservedAliases) {
            int n = name.length();
            for (int i = 0; i < n; ++i) {
                char c = name.charAt(i);
                if (c == '-') {
                    haveHyphen = true;
                    continue;
                }
                if (i <= 0 || !Character.isUpperCase(c) || !Character.isLowerCase(name.charAt(i - 1)) || !Character.isLowerCase(name.charAt(0))) continue;
                haveCamelCase = true;
            }
        }
        return new AliasStyle(haveCamelCase, haveHyphen);
    }

    private static final String generateWithSuffix(String prefix, Set<String> reserved, Function1<? super String, String> transform) {
        Object object;
        Object maybeUpdatedName;
        int id = 2;
        do {
            String name = prefix + id++;
            object = transform;
            if (object != null && (object = (String)object.invoke((Object)name)) != null) continue;
            object = name;
        } while (reserved.contains(maybeUpdatedName = object));
        return maybeUpdatedName;
    }

    @NotNull
    public static final String pickPluginVersionVariableName(@NotNull String pluginId, @NotNull Set<String> caseSensitiveReserved) {
        String transformedName;
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter(caseSensitiveReserved, (String)"caseSensitiveReserved");
        TreeSet reserved = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        reserved.addAll(caseSensitiveReserved);
        String plugin = VersionCatalogNamingUtilKt.cutDomainPrefix(pluginId);
        String safeKey = VersionCatalogNamingUtilKt.toSafeHyphenKey(plugin);
        if (reserved.isEmpty()) {
            return safeKey;
        }
        Function1<String, String> transform = VersionCatalogNamingUtilKt.getMaybeTransformVersionToCamelCase(reserved);
        if (!((Collection)reserved).isEmpty()) {
            String withVersion;
            Object e = reserved.first();
            Intrinsics.checkNotNullExpressionValue(e, (String)"reserved.first()");
            String string = ((String)e).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (StringsKt.endsWith$default((String)string, (String)"version", (boolean)false, (int)2, null) && !reserved.contains(withVersion = (String)transform.invoke((Object)(plugin + "-version")))) {
                return withVersion;
            }
        }
        if (!reserved.contains(transformedName = (String)transform.invoke((Object)plugin))) {
            return transformedName;
        }
        String withVersion = (String)transform.invoke((Object)(plugin + "-version"));
        if (!reserved.contains(withVersion)) {
            return withVersion;
        }
        String fullName = (String)transform.invoke((Object)VersionCatalogNamingUtilKt.toSafeKey(pluginId));
        if (!reserved.contains(fullName)) {
            return fullName;
        }
        return VersionCatalogNamingUtilKt.generateWithSuffix(fullName, reserved, transform);
    }

    public static final boolean keysMatch(@Nullable String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        if (s1 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        int n = s1.length();
        for (int i = 0; i < n; ++i) {
            if (VersionCatalogNamingUtilKt.normalize(s1.charAt(i)) == VersionCatalogNamingUtilKt.normalize(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final char normalize(char $this$normalize) {
        if ($this$normalize == '-' || $this$normalize == '_') {
            return '.';
        }
        return $this$normalize;
    }

    private static final boolean toSafeKey$isSafe(char $this$toSafeKey_u24isSafe) {
        return Character.isLowerCase($this$toSafeKey_u24isSafe) || Character.isDigit($this$toSafeKey_u24isSafe);
    }

    private static final boolean toSafeKey$isSeparator(char $this$toSafeKey_u24isSeparator) {
        return $this$toSafeKey_u24isSeparator == '_' || $this$toSafeKey_u24isSeparator == '-';
    }
}

