/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.CountryCodeQualifier;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.GrammaticalGenderQualifier;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NetworkCodeQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ScreenDimensionQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenRoundQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.NightMode;
import com.android.resources.ScreenRound;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;

public class DeviceConfigHelper {
    public static FolderConfiguration getFolderConfig(State state) {
        if (state == null) {
            return null;
        }
        Hardware hw = state.getHardware();
        FolderConfiguration config = FolderConfiguration.createDefault();
        Screen screen = hw.getScreen();
        config.setDensityQualifier(new DensityQualifier(screen.getPixelDensity()));
        config.setNavigationMethodQualifier(new NavigationMethodQualifier(hw.getNav()));
        ScreenDimensionQualifier sdq = screen.getXDimension() > screen.getYDimension() ? new ScreenDimensionQualifier(screen.getXDimension(), screen.getYDimension()) : new ScreenDimensionQualifier(screen.getYDimension(), screen.getXDimension());
        config.setScreenDimensionQualifier(sdq);
        config.setScreenRatioQualifier(new ScreenRatioQualifier(screen.getRatio()));
        config.setScreenSizeQualifier(new ScreenSizeQualifier(screen.getSize()));
        config.setTextInputMethodQualifier(new TextInputMethodQualifier(hw.getKeyboard()));
        config.setTouchTypeQualifier(new TouchScreenQualifier(screen.getMechanism()));
        ScreenRound screenRound = screen.getScreenRound();
        if (screenRound == null) {
            screenRound = ScreenRound.NOTROUND;
        }
        config.setScreenRoundQualifier(new ScreenRoundQualifier(screenRound));
        config.setKeyboardStateQualifier(new KeyboardStateQualifier(state.getKeyState()));
        config.setNavigationStateQualifier(new NavigationStateQualifier(state.getNavState()));
        config.setScreenOrientationQualifier(new ScreenOrientationQualifier(state.getOrientation()));
        config.updateScreenWidthAndHeight();
        config.setUiModeQualifier(new UiModeQualifier(UiMode.NORMAL));
        config.setNightModeQualifier(new NightModeQualifier(NightMode.NOTNIGHT));
        config.setCountryCodeQualifier(new CountryCodeQualifier());
        config.setLocaleQualifier(new LocaleQualifier());
        config.setLayoutDirectionQualifier(new LayoutDirectionQualifier());
        config.setNetworkCodeQualifier(new NetworkCodeQualifier());
        config.setVersionQualifier(new VersionQualifier());
        config.setGrammaticalGenderQualifier(new GrammaticalGenderQualifier());
        return config;
    }

    public static FolderConfiguration getFolderConfig(Device d, String stateName) {
        return DeviceConfigHelper.getFolderConfig(d.getState(stateName));
    }

    public static FolderConfiguration getFolderConfig(Device d) {
        return DeviceConfigHelper.getFolderConfig(d.getDefaultState());
    }
}

