/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.apkinstaller;

import com.android.tools.utp.plugins.host.apkinstaller.AndroidTestApkInstallerPlugin;
import com.android.tools.utp.plugins.host.apkinstaller.proto.AndroidApkInstallerConfigProto;
import com.google.protobuf.ProtocolStringList;
import com.google.testing.platform.api.config.Config;
import com.google.testing.platform.api.config.ConfigExtKt;
import com.google.testing.platform.api.context.Context;
import com.google.testing.platform.api.context.ContextExtKt;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.device.DeviceProperties;
import com.google.testing.platform.api.error.ErrorSummary;
import com.google.testing.platform.api.plugin.HostPlugin;
import com.google.testing.platform.core.error.ErrorType;
import com.google.testing.platform.core.error.UtpException;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import com.google.testing.platform.runtime.android.device.AndroidDeviceProperties;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u001d\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020\u0013H\u0016J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J*\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001b2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020\u0013H\u0002J\"\u0010.\u001a\u0004\u0018\u00010\u000b2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000bH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin;", "Lcom/google/testing/platform/api/plugin/HostPlugin;", "logger", "Ljava/util/logging/Logger;", "(Ljava/util/logging/Logger;)V", "installables", "", "Lcom/google/testing/platform/proto/api/core/TestArtifactProto$Artifact;", "pluginConfig", "Lcom/android/tools/utp/plugins/host/apkinstaller/proto/AndroidApkInstallerConfigProto$AndroidApkInstallerConfig;", "userId", "", "afterAll", "", "testSuiteResult", "Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "deviceController", "Lcom/google/testing/platform/api/device/DeviceController;", "cancelled", "", "afterEach", "testResult", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "apkInstallErrorMessage", "apkPath", "deviceSerial", "additionalOutput", "", "beforeAll", "beforeEach", "testCase", "Lcom/google/testing/platform/proto/api/core/TestCaseProto$TestCase;", "canRun", "configure", "context", "Lcom/google/testing/platform/api/context/Context;", "getFeatureMinApiLevel", "Lcom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin$Companion$MinFeatureApiLevel;", "installOption", "Lcom/android/tools/utp/plugins/host/apkinstaller/proto/AndroidApkInstallerConfigProto$InstallableApk$InstallOption;", "getInstallCmd", "installableApk", "Lcom/android/tools/utp/plugins/host/apkinstaller/proto/AndroidApkInstallerConfigProto$InstallableApk;", "deviceApiLevel", "", "forceReinstall", "getUserId", "Companion", "android-test-plugin-host-apk-installer"})
@SourceDebugExtension(value={"SMAP\nAndroidTestApkInstallerPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTestApkInstallerPlugin.kt\ncom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin\n+ 2 ConfigExt.kt\ncom/google/testing/platform/api/config/ConfigExtKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n64#2:281\n1849#3,2:282\n1849#3:284\n1849#3,2:286\n1850#3:288\n1849#3:289\n1849#3,2:290\n1850#3:292\n1#4:285\n*S KotlinDebug\n*F\n+ 1 AndroidTestApkInstallerPlugin.kt\ncom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin\n*L\n128#1:281\n157#1:282,2\n178#1:284\n211#1:286,2\n178#1:288\n261#1:289\n263#1:290,2\n261#1:292\n*E\n"})
public final class AndroidTestApkInstallerPlugin
implements HostPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    private AndroidApkInstallerConfigProto.AndroidApkInstallerConfig pluginConfig;
    private Set<TestArtifactProto.Artifact> installables;
    @Nullable
    private String userId;
    @NotNull
    private static final List<String> INSTALL_MULTIPLE_CMD = CollectionsKt.listOf((Object)"install-multiple");
    @NotNull
    private static final Companion.installErrorSummary.1 installErrorSummary = new ErrorSummary(){
        private final int errorCode;
        @NotNull
        private final String errorName;
        @NotNull
        private final Enum<?> errorType;
        @NotNull
        private final String namespace;
        {
            this.errorCode = 2002;
            this.errorName = "Test APK installation Error";
            this.errorType = (Enum)ErrorType.TEST;
            this.namespace = "AndroidTestApkInstallerPlugin";
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        @NotNull
        public String getErrorName() {
            return this.errorName;
        }

        @NotNull
        public Enum<?> getErrorType() {
            return this.errorType;
        }

        @NotNull
        public String getNamespace() {
            return this.namespace;
        }
    };

    public AndroidTestApkInstallerPlugin(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    public /* synthetic */ AndroidTestApkInstallerPlugin(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = LoggerExtKt.getLogger((Object)Companion);
        }
        this(logger);
    }

    private final Companion.MinFeatureApiLevel getFeatureMinApiLevel(AndroidApkInstallerConfigProto.InstallableApk.InstallOption installOption) {
        Companion.MinFeatureApiLevel minApiLevel = Companion.MinFeatureApiLevel.NONE;
        if (installOption.getInstallAsSplitApk()) {
            minApiLevel = Companion.MinFeatureApiLevel.SPLIT_APK;
        }
        return minApiLevel;
    }

    private final String getUserId(int deviceApiLevel, DeviceController deviceController, String deviceSerial) {
        String userId;
        if (deviceApiLevel < 24) {
            return null;
        }
        Object[] objectArray = new String[]{"shell", "am", "get-current-user"};
        CommandResult result = DeviceController.DefaultImpls.execute$default((DeviceController)deviceController, (List)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null);
        if (result.getStatusCode() != 0) {
            this.logger.warning("Failed to execute command to obtain user ID from device " + deviceSerial);
            return null;
        }
        String string = userId = (String)CollectionsKt.getOrNull((List)result.getOutput(), (int)0);
        if ((string != null ? StringsKt.toIntOrNull((String)string) : null) == null) {
            this.logger.warning("Unexpected output of command get-current-user, expected a user id found the following output: " + userId);
            return null;
        }
        return userId;
    }

    private final List<String> getInstallCmd(AndroidApkInstallerConfigProto.InstallableApk installableApk, int deviceApiLevel, boolean forceReinstall) {
        Object[] objectArray;
        List installCmd = CollectionsKt.toMutableList((Collection)INSTALL_MULTIPLE_CMD);
        if (deviceApiLevel >= 34) {
            installCmd.add("--bypass-low-target-sdk-block");
        }
        installCmd.add("-t");
        if (installableApk != null && installableApk.getInstallOptions().getInstallAsTestService()) {
            if (deviceApiLevel >= 23) {
                installCmd.add("-g");
            }
            if (deviceApiLevel >= 30) {
                installCmd.add("--force-queryable");
            }
        }
        if (this.userId != null) {
            objectArray = new String[]{"--user", this.userId};
            installCmd.addAll(CollectionsKt.listOfNotNull((Object[])objectArray));
        }
        if (forceReinstall) {
            objectArray = new String[]{"-r", "-d"};
            installCmd.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        return installCmd;
    }

    static /* synthetic */ List getInstallCmd$default(AndroidTestApkInstallerPlugin androidTestApkInstallerPlugin, AndroidApkInstallerConfigProto.InstallableApk installableApk, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return androidTestApkInstallerPlugin.getInstallCmd(installableApk, n, bl);
    }

    public void configure(@NotNull Context context) {
        Config config;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Config $this$parseConfig$iv = config = ContextExtKt.getConfig((Context)context);
        boolean $i$f$parseConfig = false;
        AndroidApkInstallerConfigProto.AndroidApkInstallerConfig androidApkInstallerConfig = (AndroidApkInstallerConfigProto.AndroidApkInstallerConfig)ConfigExtKt.parseConfig((Config)$this$parseConfig$iv, AndroidApkInstallerConfigProto.AndroidApkInstallerConfig.class);
        if (androidApkInstallerConfig == null) {
            AndroidApkInstallerConfigProto.AndroidApkInstallerConfig androidApkInstallerConfig2 = AndroidApkInstallerConfigProto.AndroidApkInstallerConfig.getDefaultInstance();
            androidApkInstallerConfig = androidApkInstallerConfig2;
            Intrinsics.checkNotNullExpressionValue((Object)androidApkInstallerConfig2, (String)"getDefaultInstance()");
        }
        this.pluginConfig = androidApkInstallerConfig;
        this.installables = ConfigExtKt.getSetup((Config)config).getInstallables();
        Set<TestArtifactProto.Artifact> set = this.installables;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"installables");
            set = null;
        }
        if (set.isEmpty()) {
            this.logger.info("No installables found in test fixture. Nothing to install.");
        }
    }

    private final String apkInstallErrorMessage(String apkPath, String deviceSerial, List<String> additionalOutput) {
        return "Failed to install APK: " + apkPath + " on device " + deviceSerial + "." + (String)(additionalOutput.isEmpty() ? "" : "\n" + additionalOutput);
    }

    public void beforeAll(@NotNull DeviceController deviceController) throws UtpException {
        Object result;
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        DeviceProperties deviceProperties = deviceController.getDevice().getProperties();
        Intrinsics.checkNotNull((Object)deviceProperties, (String)"null cannot be cast to non-null type com.google.testing.platform.runtime.android.device.AndroidDeviceProperties");
        int deviceApiLevel = Integer.parseInt(((AndroidDeviceProperties)deviceProperties).getDeviceApiLevel());
        String deviceSerial = deviceController.getDevice().getSerial();
        this.userId = this.getUserId(deviceApiLevel, deviceController, deviceSerial);
        if (deviceApiLevel >= 33) {
            Object[] objectArray = new String[]{"shell", "settings", "put", "global", "verifier_verify_adb_installs", "0"};
            DeviceController.DefaultImpls.execute$default((DeviceController)deviceController, (List)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null);
        }
        List installablesInstallCmd = AndroidTestApkInstallerPlugin.getInstallCmd$default(this, null, deviceApiLevel, false, 4, null);
        Set<TestArtifactProto.Artifact> set = this.installables;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"installables");
            set = null;
        }
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestArtifactProto.Artifact artifact = (TestArtifactProto.Artifact)element$iv;
            boolean bl = false;
            String apkPath = artifact.getSourcePath().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)apkPath, (String)"apkPath");
            if (((CharSequence)apkPath).length() == 0) {
                this.logger.warning("Installable APK has empty path.");
                continue;
            }
            this.logger.info("Installing installable artifact: " + apkPath + " on device " + deviceSerial + ".");
            result = DeviceController.DefaultImpls.execute$default((DeviceController)deviceController, (List)CollectionsKt.plus((Collection)installablesInstallCmd, (Iterable)CollectionsKt.listOf((Object)apkPath)), null, (int)2, null);
            boolean bl2 = false;
            if (result.getStatusCode() == 0) continue;
            ErrorSummary errorSummary = installErrorSummary;
            String string = artifact.getSourcePath().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.sourcePath.path");
            throw new UtpException(errorSummary, this.apkInstallErrorMessage(string, deviceSerial, result.getOutput()), null, 4, null);
        }
        AndroidApkInstallerConfigProto.AndroidApkInstallerConfig androidApkInstallerConfig = this.pluginConfig;
        if (androidApkInstallerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pluginConfig");
            androidApkInstallerConfig = null;
        }
        List list = androidApkInstallerConfig.getApksToInstallList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pluginConfig.apksToInstallList");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Duration duration;
            AndroidApkInstallerConfigProto.InstallableApk installableApk = (AndroidApkInstallerConfigProto.InstallableApk)element$iv;
            boolean bl = false;
            if (installableApk.getApkPathsList().isEmpty()) continue;
            AndroidApkInstallerConfigProto.InstallableApk.InstallOption installOption = installableApk.getInstallOptions();
            Intrinsics.checkNotNullExpressionValue((Object)installOption, (String)"installableApk.installOptions");
            Companion.MinFeatureApiLevel featureMinApi = this.getFeatureMinApiLevel(installOption);
            if (featureMinApi.getApiLevel() > deviceApiLevel) {
                throw new UtpException((ErrorSummary)installErrorSummary, "Minimum API level for installing " + featureMinApi + " feature is " + featureMinApi.getApiLevel() + " but device " + deviceSerial + " is API level " + deviceApiLevel + ".", null, 4, null);
            }
            result = installableApk.getInstallOptions().getInstallApkTimeout();
            int it = ((Number)result).intValue();
            boolean bl3 = false;
            Object object = it > 0 ? result : null;
            if (object != null) {
                long it2 = ((Integer)object).intValue();
                boolean bl4 = false;
                duration = Duration.ofSeconds(it2);
            } else {
                duration = null;
            }
            Duration installTimeoutDuration = duration;
            List<String> installCmd = this.getInstallCmd(installableApk, deviceApiLevel, installableApk.getForceReinstallBeforeTest());
            this.logger.info("Installing " + installableApk.getApkPathsList() + " on device " + deviceSerial + ".");
            if (!installableApk.getInstallOptions().getInstallAsSplitApk() && installableApk.getApkPathsCount() > 1) {
                ProtocolStringList protocolStringList = installableApk.getApkPathsList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"installableApk.apkPathsList");
                Iterable $this$forEach$iv2 = (Iterable)protocolStringList;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String apkPath = (String)element$iv2;
                    boolean bl5 = false;
                    Collection collection = installCmd;
                    ProtocolStringList protocolStringList2 = installableApk.getInstallOptions().getCommandLineParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)protocolStringList2, (String)"installableApk.installOp\u2026.commandLineParameterList");
                    CommandResult result2 = deviceController.execute(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)protocolStringList2)), (Object)apkPath), installTimeoutDuration);
                    boolean bl6 = false;
                    if (result2.getStatusCode() == 0) continue;
                    ErrorSummary errorSummary = installErrorSummary;
                    Intrinsics.checkNotNullExpressionValue((Object)apkPath, (String)"apkPath");
                    throw new UtpException(errorSummary, this.apkInstallErrorMessage(apkPath, deviceSerial, result2.getOutput()), null, 4, null);
                }
                continue;
            }
            Collection collection = installCmd;
            ProtocolStringList protocolStringList = installableApk.getInstallOptions().getCommandLineParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"installableApk.installOp\u2026.commandLineParameterList");
            Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)protocolStringList));
            ProtocolStringList protocolStringList3 = installableApk.getApkPathsList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList3, (String)"installableApk.apkPathsList");
            CommandResult result3 = deviceController.execute(CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)protocolStringList3)), installTimeoutDuration);
            boolean bl7 = false;
            if (result3.getStatusCode() == 0) continue;
            throw new UtpException((ErrorSummary)installErrorSummary, this.apkInstallErrorMessage(installableApk.getApkPathsList().toString(), deviceSerial, result3.getOutput()), null, 4, null);
        }
    }

    public void beforeEach(@Nullable TestCaseProto.TestCase testCase, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
    }

    public void afterEach(@NotNull TestResultProto.TestResult testResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
    }

    public void afterAll(@NotNull TestSuiteResultProto.TestSuiteResult testSuiteResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testSuiteResult, (String)"testSuiteResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        AndroidApkInstallerConfigProto.AndroidApkInstallerConfig androidApkInstallerConfig = this.pluginConfig;
        if (androidApkInstallerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pluginConfig");
            androidApkInstallerConfig = null;
        }
        List list = androidApkInstallerConfig.getApksToInstallList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pluginConfig.apksToInstallList");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidApkInstallerConfigProto.InstallableApk installableApk = (AndroidApkInstallerConfigProto.InstallableApk)element$iv;
            boolean bl = false;
            if (!installableApk.getUninstallAfterTest()) continue;
            ProtocolStringList protocolStringList = installableApk.getApksPackageNameList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"installableApk.apksPackageNameList");
            Iterable $this$forEach$iv2 = (Iterable)protocolStringList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String apkPackage = (String)element$iv2;
                boolean bl2 = false;
                this.logger.info("Uninstalling " + apkPackage + " for device " + deviceController.getDevice().getSerial() + ".");
                Intrinsics.checkNotNullExpressionValue((Object)apkPackage, (String)"apkPackage");
                CommandResult result = AndroidDeviceControllerExtKt.uninstall$default((DeviceController)deviceController, (String)apkPackage, (boolean)false, null, (int)6, null);
                boolean bl3 = false;
                if (result.getStatusCode() == 0) continue;
                this.logger.warning("Device " + deviceController.getDevice().getSerial() + " failed to uninstall test APK " + apkPackage + ".\n" + result.getOutput());
            }
        }
    }

    public boolean canRun() {
        return true;
    }

    public AndroidTestApkInstallerPlugin() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0004*\u0001\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lcom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin$Companion;", "", "()V", "INSTALL_MULTIPLE_CMD", "", "", "installErrorSummary", "com/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin$Companion$installErrorSummary$1", "Lcom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin$Companion$installErrorSummary$1;", "MinFeatureApiLevel", "android-test-plugin-host-apk-installer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/utp/plugins/host/apkinstaller/AndroidTestApkInstallerPlugin$Companion$MinFeatureApiLevel;", "", "apiLevel", "", "(Ljava/lang/String;II)V", "getApiLevel", "()I", "NONE", "SPLIT_APK", "android-test-plugin-host-apk-installer"})
        private static final class MinFeatureApiLevel
        extends Enum<MinFeatureApiLevel> {
            private final int apiLevel;
            public static final /* enum */ MinFeatureApiLevel NONE = new MinFeatureApiLevel(Integer.MIN_VALUE);
            public static final /* enum */ MinFeatureApiLevel SPLIT_APK = new MinFeatureApiLevel(21);
            private static final /* synthetic */ MinFeatureApiLevel[] $VALUES;

            private MinFeatureApiLevel(int apiLevel) {
                this.apiLevel = apiLevel;
            }

            public final int getApiLevel() {
                return this.apiLevel;
            }

            public static MinFeatureApiLevel[] values() {
                return (MinFeatureApiLevel[])$VALUES.clone();
            }

            public static MinFeatureApiLevel valueOf(String value) {
                return Enum.valueOf(MinFeatureApiLevel.class, value);
            }

            static {
                $VALUES = minFeatureApiLevelArray = new MinFeatureApiLevel[]{MinFeatureApiLevel.NONE, MinFeatureApiLevel.SPLIT_APK};
            }
        }
    }
}

