/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Compressor;
import com.android.zipflinger.Crc32;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Location;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipSource;
import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZipSourceEntryInflater
extends Source {
    private final Location loc;
    private final ZipSource zipSource;
    private ByteBuffer buffer;

    public ZipSourceEntryInflater(String newName, Entry entry, ZipSource zipSource) {
        super(newName);
        this.loc = entry.getPayloadLocation();
        this.zipSource = zipSource;
    }

    @Override
    void prepare() throws IOException {
        ByteBuffer compressedBytes = ByteBuffer.allocate(Math.toIntExact(this.loc.size()));
        this.zipSource.getChannel().read(compressedBytes, this.loc.first);
        this.buffer = Compressor.inflate(compressedBytes.array());
        this.crc = Crc32.crc32(this.buffer.array(), 0, this.buffer.limit());
        this.compressedSize = this.buffer.limit();
        this.uncompressedSize = this.buffer.limit();
        this.compressionFlag = 0;
    }

    @Override
    long writeTo(ZipWriter writer) throws IOException {
        return writer.write(this.buffer);
    }
}

