/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public abstract class Source {
    private final String name;
    private final byte[] nameBytes;
    private long alignment = 0L;
    protected long compressedSize;
    protected long uncompressedSize;
    protected int crc;
    protected short compressionFlag;

    protected Source(String name) {
        this.name = name;
        this.nameBytes = name.getBytes(StandardCharsets.UTF_8);
    }

    public String getName() {
        return this.name;
    }

    byte[] getNameBytes() {
        return this.nameBytes;
    }

    boolean isAligned() {
        return this.alignment != 0L;
    }

    public void align(long alignment) {
        this.alignment = alignment;
    }

    long getAlignment() {
        return this.alignment;
    }

    int getCrc() {
        return this.crc;
    }

    long getCompressedSize() {
        return this.compressedSize;
    }

    long getUncompressedSize() {
        return this.uncompressedSize;
    }

    short getCompressionFlag() {
        return this.compressionFlag;
    }

    abstract void prepare() throws IOException;

    abstract long writeTo(ZipWriter var1) throws IOException;
}

