/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava;

import com.apollographql.federation.graphqljava.FederationDirectives;
import com.apollographql.federation.graphqljava.FederationError;
import com.apollographql.federation.graphqljava._Entity;
import com.apollographql.federation.graphqljava._Service;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactory;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.TypeResolver;
import graphql.schema.idl.SchemaPrinter;
import graphql.schema.idl.errors.SchemaProblem;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class SchemaTransformer {
    private static final Object DUMMY = new Object();
    private final GraphQLSchema originalSchema;
    private TypeResolver entityTypeResolver = null;
    private DataFetcher entitiesDataFetcher = null;
    private DataFetcherFactory entitiesDataFetcherFactory = null;

    SchemaTransformer(GraphQLSchema originalSchema) {
        this.originalSchema = originalSchema;
    }

    @NotNull
    public SchemaTransformer resolveEntityType(TypeResolver entityTypeResolver) {
        this.entityTypeResolver = entityTypeResolver;
        return this;
    }

    @NotNull
    public SchemaTransformer fetchEntities(DataFetcher entitiesDataFetcher) {
        this.entitiesDataFetcher = entitiesDataFetcher;
        this.entitiesDataFetcherFactory = null;
        return this;
    }

    @NotNull
    public SchemaTransformer fetchEntitiesFactory(DataFetcherFactory entitiesDataFetcherFactory) {
        this.entitiesDataFetcher = null;
        this.entitiesDataFetcherFactory = entitiesDataFetcherFactory;
        return this;
    }

    @NotNull
    public final GraphQLSchema build() throws SchemaProblem {
        ArrayList<FederationError> errors = new ArrayList<FederationError>();
        GraphQLSchema.Builder schema = GraphQLSchema.newSchema((GraphQLSchema)this.originalSchema);
        GraphQLObjectType originalQueryType = this.originalSchema.getQueryType();
        GraphQLCodeRegistry.Builder codeRegistry = GraphQLCodeRegistry.newCodeRegistry((GraphQLCodeRegistry)this.originalSchema.getCodeRegistry());
        String sdl = this.sdl();
        GraphQLObjectType.Builder queryType = GraphQLObjectType.newObject((GraphQLObjectType)originalQueryType).field(_Service.field);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)originalQueryType.getName(), (String)"_service"), environment -> DUMMY);
        codeRegistry.dataFetcher(FieldCoordinates.coordinates((String)"_Service", (String)"sdl"), environment -> sdl);
        Set<String> entityTypeNames = this.originalSchema.getAllTypesAsList().stream().filter(t -> t instanceof GraphQLDirectiveContainer && ((GraphQLDirectiveContainer)t).getDirective("key") != null).map(GraphQLType::getName).collect(Collectors.toSet());
        if (!entityTypeNames.isEmpty()) {
            queryType.field(_Entity.field(entityTypeNames));
            schema.additionalDirectives(FederationDirectives.allDirectives);
            if (this.entityTypeResolver != null) {
                codeRegistry.typeResolver("_Entity", this.entityTypeResolver);
            } else if (!codeRegistry.hasTypeResolver("_Entity")) {
                errors.add(new FederationError("Missing a type resolver for _Entity"));
            }
            FieldCoordinates _entities = FieldCoordinates.coordinates((String)originalQueryType.getName(), (String)"_entities");
            if (this.entitiesDataFetcher != null) {
                codeRegistry.dataFetcher(_entities, this.entitiesDataFetcher);
            } else if (this.entitiesDataFetcherFactory != null) {
                codeRegistry.dataFetcher(_entities, this.entitiesDataFetcherFactory);
            } else if (!codeRegistry.hasDataFetcher(_entities)) {
                errors.add(new FederationError("Missing a data fetcher for _entities"));
            }
        }
        if (!errors.isEmpty()) {
            throw new SchemaProblem(errors);
        }
        return schema.query(queryType.build()).codeRegistry(codeRegistry.build()).build();
    }

    private String sdl() {
        SchemaPrinter.Options options = SchemaPrinter.Options.defaultOptions().includeScalarTypes(true).includeExtendedScalarTypes(true).includeSchemaDefintion(true).includeDirectives(true);
        return new SchemaPrinter(options).print(this.originalSchema);
    }
}

