/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.ccm;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.DirectoryScanner;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.Execute;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.ccm.Continuus;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Commandline;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.FileSet;
import java.io.File;
import java.util.Vector;

public class CCMCheck
extends Continuus {
    private File file = null;
    private String comment = null;
    private String task = null;
    protected Vector filesets = new Vector();
    public static final String FLAG_COMMENT = "/comment";
    public static final String FLAG_TASK = "/task";

    public File getFile() {
        return this.file;
    }

    public void setFile(File v) {
        this.log("working file " + v, 3);
        this.file = v;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String v) {
        this.comment = v;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String v) {
        this.task = v;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("CCMCheck cannot be generated for directories");
        }
        if (this.file != null && this.filesets.size() > 0) {
            throw new BuildException("Choose between file and fileset !");
        }
        if (this.getFile() != null) {
            this.doit();
            return;
        }
        int sizeofFileSet = this.filesets.size();
        for (int i = 0; i < sizeofFileSet; ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            for (int j = 0; j < srcFiles.length; ++j) {
                File src = new File(fs.getDir(this.getProject()), srcFiles[j]);
                this.setFile(src);
                this.doit();
            }
        }
    }

    private void doit() {
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(this.getCcmCommand());
        commandLine.createArgument().setValue(this.getCcmAction());
        this.checkOptions(commandLine);
        int result = this.run(commandLine);
        if (Execute.isFailure(result)) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.getLocation());
        }
    }

    private void checkOptions(Commandline cmd) {
        if (this.getComment() != null) {
            cmd.createArgument().setValue(FLAG_COMMENT);
            cmd.createArgument().setValue(this.getComment());
        }
        if (this.getTask() != null) {
            cmd.createArgument().setValue(FLAG_TASK);
            cmd.createArgument().setValue(this.getTask());
        }
        if (this.getFile() != null) {
            cmd.createArgument().setValue(this.file.getAbsolutePath());
        }
    }
}

