/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.ejb;

import com.github.dockerjava.shaded.org.apache.tools.ant.Task;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DescriptorHandler
extends HandlerBase {
    private static final int DEFAULT_HASH_TABLE_SIZE = 10;
    private static final int STATE_LOOKING_EJBJAR = 1;
    private static final int STATE_IN_EJBJAR = 2;
    private static final int STATE_IN_BEANS = 3;
    private static final int STATE_IN_SESSION = 4;
    private static final int STATE_IN_ENTITY = 5;
    private static final int STATE_IN_MESSAGE = 6;
    private Task owningTask;
    private String publicId = null;
    private static final String EJB_REF = "ejb-ref";
    private static final String EJB_LOCAL_REF = "ejb-local-ref";
    private static final String HOME_INTERFACE = "home";
    private static final String REMOTE_INTERFACE = "remote";
    private static final String LOCAL_HOME_INTERFACE = "local-home";
    private static final String LOCAL_INTERFACE = "local";
    private static final String BEAN_CLASS = "ejb-class";
    private static final String PK_CLASS = "prim-key-class";
    private static final String EJB_NAME = "ejb-name";
    private static final String EJB_JAR = "ejb-jar";
    private static final String ENTERPRISE_BEANS = "enterprise-beans";
    private static final String ENTITY_BEAN = "entity";
    private static final String SESSION_BEAN = "session";
    private static final String MESSAGE_BEAN = "message-driven";
    private int parseState = 1;
    protected String currentElement = null;
    protected String currentText = null;
    protected Hashtable ejbFiles = null;
    protected String ejbName = null;
    private Hashtable fileDTDs = new Hashtable();
    private Hashtable resourceDTDs = new Hashtable();
    private boolean inEJBRef = false;
    private Hashtable urlDTDs = new Hashtable();
    private File srcDir;

    public DescriptorHandler(Task task, File srcDir) {
        this.owningTask = task;
        this.srcDir = srcDir;
    }

    public void registerDTD(String publicId, String location) {
        if (location == null) {
            return;
        }
        File fileDTD = new File(location);
        if (!fileDTD.exists()) {
            fileDTD = this.owningTask.getProject().resolveFile(location);
        }
        if (fileDTD.exists()) {
            if (publicId != null) {
                this.fileDTDs.put(publicId, fileDTD);
                this.owningTask.log("Mapped publicId " + publicId + " to file " + fileDTD, 3);
            }
            return;
        }
        if (this.getClass().getResource(location) != null && publicId != null) {
            this.resourceDTDs.put(publicId, location);
            this.owningTask.log("Mapped publicId " + publicId + " to resource " + location, 3);
        }
        try {
            if (publicId != null) {
                URL urldtd = new URL(location);
                this.urlDTDs.put(publicId, urldtd);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputStream is;
        String dtdResourceName;
        this.publicId = publicId;
        File dtdFile = (File)this.fileDTDs.get(publicId);
        if (dtdFile != null) {
            try {
                this.owningTask.log("Resolved " + publicId + " to local file " + dtdFile, 3);
                return new InputSource(new FileInputStream(dtdFile));
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
        if ((dtdResourceName = (String)this.resourceDTDs.get(publicId)) != null && (is = this.getClass().getResourceAsStream(dtdResourceName)) != null) {
            this.owningTask.log("Resolved " + publicId + " to local resource " + dtdResourceName, 3);
            return new InputSource(is);
        }
        URL dtdUrl = (URL)this.urlDTDs.get(publicId);
        if (dtdUrl != null) {
            try {
                InputStream is2 = dtdUrl.openStream();
                this.owningTask.log("Resolved " + publicId + " to url " + dtdUrl, 3);
                return new InputSource(is2);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.owningTask.log("Could not resolve ( publicId: " + publicId + ", systemId: " + systemId + ") to a local entity", 2);
        return null;
    }

    public Hashtable getFiles() {
        return this.ejbFiles == null ? new Hashtable() : this.ejbFiles;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void startDocument() throws SAXException {
        this.ejbFiles = new Hashtable(10, 1.0f);
        this.currentElement = null;
        this.inEJBRef = false;
    }

    public void startElement(String name, AttributeList attrs) throws SAXException {
        this.currentElement = name;
        this.currentText = "";
        if (name.equals(EJB_REF) || name.equals(EJB_LOCAL_REF)) {
            this.inEJBRef = true;
        } else if (this.parseState == 1 && name.equals(EJB_JAR)) {
            this.parseState = 2;
        } else if (this.parseState == 2 && name.equals(ENTERPRISE_BEANS)) {
            this.parseState = 3;
        } else if (this.parseState == 3 && name.equals(SESSION_BEAN)) {
            this.parseState = 4;
        } else if (this.parseState == 3 && name.equals(ENTITY_BEAN)) {
            this.parseState = 5;
        } else if (this.parseState == 3 && name.equals(MESSAGE_BEAN)) {
            this.parseState = 6;
        }
    }

    public void endElement(String name) throws SAXException {
        this.processElement();
        this.currentText = "";
        this.currentElement = "";
        if (name.equals(EJB_REF) || name.equals(EJB_LOCAL_REF)) {
            this.inEJBRef = false;
        } else if (this.parseState == 5 && name.equals(ENTITY_BEAN)) {
            this.parseState = 3;
        } else if (this.parseState == 4 && name.equals(SESSION_BEAN)) {
            this.parseState = 3;
        } else if (this.parseState == 6 && name.equals(MESSAGE_BEAN)) {
            this.parseState = 3;
        } else if (this.parseState == 3 && name.equals(ENTERPRISE_BEANS)) {
            this.parseState = 2;
        } else if (this.parseState == 2 && name.equals(EJB_JAR)) {
            this.parseState = 1;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText = this.currentText + new String(ch, start, length);
    }

    protected void processElement() {
        if (this.inEJBRef || this.parseState != 5 && this.parseState != 4 && this.parseState != 6) {
            return;
        }
        if (this.currentElement.equals(HOME_INTERFACE) || this.currentElement.equals(REMOTE_INTERFACE) || this.currentElement.equals(LOCAL_INTERFACE) || this.currentElement.equals(LOCAL_HOME_INTERFACE) || this.currentElement.equals(BEAN_CLASS) || this.currentElement.equals(PK_CLASS)) {
            File classFile = null;
            String className = this.currentText.trim();
            if (!className.startsWith("java.") && !className.startsWith("javax.")) {
                className = className.replace('.', File.separatorChar);
                className = className + ".class";
                classFile = new File(this.srcDir, className);
                this.ejbFiles.put(className, classFile);
            }
        }
        if (this.currentElement.equals(EJB_NAME) && this.ejbName == null) {
            this.ejbName = this.currentText.trim();
        }
    }
}

