/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.javah;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.Execute;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.Javah;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.javah.JavahAdapter;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Commandline;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Path;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.JavaEnvUtils;

public class Gcjh
implements JavahAdapter {
    public static final String IMPLEMENTATION_NAME = "gcjh";

    public boolean compile(Javah javah) throws BuildException {
        Commandline cmd = this.setupGcjhCommand(javah);
        try {
            Execute.runCommand(javah, cmd.getCommandline());
            return true;
        }
        catch (BuildException e) {
            if (e.getMessage().indexOf("failed with return code") == -1) {
                throw e;
            }
            return false;
        }
    }

    private Commandline setupGcjhCommand(Javah javah) {
        Commandline cmd = new Commandline();
        cmd.setExecutable(JavaEnvUtils.getJdkExecutable(IMPLEMENTATION_NAME));
        if (javah.getDestdir() != null) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(javah.getDestdir());
        }
        if (javah.getOutputfile() != null) {
            cmd.createArgument().setValue("-o");
            cmd.createArgument().setFile(javah.getOutputfile());
        }
        Path cp = new Path(javah.getProject());
        if (javah.getBootclasspath() != null) {
            cp.append(javah.getBootclasspath());
        }
        cp = cp.concatSystemBootClasspath("ignore");
        if (javah.getClasspath() != null) {
            cp.append(javah.getClasspath());
        }
        if (cp.size() > 0) {
            cmd.createArgument().setValue("--classpath");
            cmd.createArgument().setPath(cp);
        }
        if (!javah.getOld()) {
            cmd.createArgument().setValue("-jni");
        }
        cmd.addArguments(javah.getCurrentArgs());
        javah.logAndAddFiles(cmd);
        return cmd;
    }
}

