/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.jsp.compilers;

import com.github.dockerjava.shaded.org.apache.tools.ant.AntClassLoader;
import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.Java;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.jsp.JspC;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.jsp.JspMangler;
import com.github.dockerjava.shaded.org.apache.tools.ant.taskdefs.optional.jsp.compilers.DefaultJspCompilerAdapter;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.CommandlineJava;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Path;
import java.io.File;

public class JasperC
extends DefaultJspCompilerAdapter {
    JspMangler mangler;

    public JasperC(JspMangler mangler) {
        this.mangler = mangler;
    }

    public boolean execute() throws BuildException {
        this.getJspc().log("Using jasper compiler", 3);
        CommandlineJava cmd = this.setupJasperCommand();
        try {
            Java java = new Java(this.owner);
            Path p = this.getClasspath();
            if (this.getJspc().getClasspath() != null) {
                this.getProject().log("using user supplied classpath: " + p, 4);
            } else {
                this.getProject().log("using system classpath: " + p, 4);
            }
            java.setClasspath(p);
            java.setDir(this.getProject().getBaseDir());
            java.setClassname("com.github.dockerjava.shaded.org.apache.jasper.JspC");
            String[] args = cmd.getJavaCommand().getArguments();
            for (int i = 0; i < args.length; ++i) {
                java.createArg().setValue(args[i]);
            }
            java.setFailonerror(this.getJspc().getFailonerror());
            java.setFork(true);
            java.setTaskName("jasperc");
            java.execute();
            boolean bl = true;
            Object var7_7 = null;
            this.getJspc().deleteEmptyJavaFiles();
            return bl;
        }
        catch (Exception ex) {
            try {
                if (ex instanceof BuildException) {
                    throw (BuildException)ex;
                }
                throw new BuildException("Error running jsp compiler: ", ex, this.getJspc().getLocation());
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.getJspc().deleteEmptyJavaFiles();
                throw throwable;
            }
        }
    }

    private CommandlineJava setupJasperCommand() {
        CommandlineJava cmd = new CommandlineJava();
        JspC jspc = this.getJspc();
        this.addArg(cmd, "-d", jspc.getDestdir());
        this.addArg(cmd, "-p", jspc.getPackage());
        if (!this.isTomcat5x()) {
            this.addArg(cmd, "-v" + jspc.getVerbose());
        } else {
            this.getProject().log("this task doesn't support Tomcat 5.x properly, please use the Tomcat provided jspc task instead");
        }
        this.addArg(cmd, "-uriroot", jspc.getUriroot());
        this.addArg(cmd, "-uribase", jspc.getUribase());
        this.addArg(cmd, "-ieplugin", jspc.getIeplugin());
        this.addArg(cmd, "-webinc", jspc.getWebinc());
        this.addArg(cmd, "-webxml", jspc.getWebxml());
        this.addArg(cmd, "-die9");
        if (jspc.isMapped()) {
            this.addArg(cmd, "-mapped");
        }
        if (jspc.getWebApp() != null) {
            File dir = jspc.getWebApp().getDirectory();
            this.addArg(cmd, "-webapp", dir);
        }
        this.logAndAddFilesToCompile(this.getJspc(), this.getJspc().getCompileList(), cmd);
        return cmd;
    }

    public JspMangler createMangler() {
        return this.mangler;
    }

    private Path getClasspath() {
        Path p = this.getJspc().getClasspath();
        if (p == null) {
            p = new Path(this.getProject());
            return p.concatSystemClasspath("only");
        }
        return p.concatSystemClasspath("ignore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTomcat5x() {
        AntClassLoader l = null;
        try {
            l = this.getProject().createClassLoader(this.getClasspath());
            l.loadClass("com.github.dockerjava.shaded.org.apache.jasper.tagplugins.jstl.If");
            boolean bl = true;
            Object var5_4 = null;
            if (l != null) {
                l.cleanup();
            }
            return bl;
        }
        catch (ClassNotFoundException e) {
            try {
                boolean bl = false;
                Object var5_5 = null;
                if (l != null) {
                    l.cleanup();
                }
                return bl;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_6 = null;
                    if (l == null) break block6;
                    l.cleanup();
                }
                throw throwable;
            }
        }
    }
}

