/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.cms;

import com.github.dockerjava.shaded.org.bouncycastle.asn1.cms.KEKIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.cms.AuthAttributesProvider;
import com.github.dockerjava.shaded.org.bouncycastle.cms.CMSException;
import com.github.dockerjava.shaded.org.bouncycastle.cms.CMSSecureReadable;
import com.github.dockerjava.shaded.org.bouncycastle.cms.KEKRecipient;
import com.github.dockerjava.shaded.org.bouncycastle.cms.KEKRecipientId;
import com.github.dockerjava.shaded.org.bouncycastle.cms.Recipient;
import com.github.dockerjava.shaded.org.bouncycastle.cms.RecipientInformation;
import com.github.dockerjava.shaded.org.bouncycastle.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

