/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system;

import com.aspose.email.internal.hu.zb;
import com.aspose.email.system.Array;
import com.aspose.email.system.Struct;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.ArgumentOutOfRangeException;

public class ArraySegment<T>
extends Struct<ArraySegment> {
    private T[] a;
    private int b;
    private int c;

    public ArraySegment() {
    }

    public ArraySegment(T[] array) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        this.a = array;
        this.b = 0;
        this.c = Array.boxing(array).getLength();
    }

    public ArraySegment(T[] array, int offset, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required");
        }
        if (Array.boxing(array).getLength() - offset < count) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection");
        }
        this.a = array;
        this.b = offset;
        this.c = count;
    }

    public T[] getArray() {
        return this.a;
    }

    public int getOffset() {
        return this.b;
    }

    public int getCount() {
        return this.c;
    }

    public int hashCode() {
        return Array.boxing(this.a).hashCode() ^ this.b ^ this.c;
    }

    public boolean equals(Object obj) {
        return zb.b(obj, ArraySegment.class) && this.equals((ArraySegment)obj);
    }

    public boolean equals(ArraySegment<T> obj) {
        return obj.a == this.a && obj.b == this.b && obj.c == this.c;
    }

    public static <T> boolean op_Equality(ArraySegment<T> a, ArraySegment<T> b) {
        return a.equals(b.Clone());
    }

    public static <T> boolean op_Inequality(ArraySegment<T> a, ArraySegment<T> b) {
        return !ArraySegment.op_Equality(a, b);
    }

    @Override
    public void CloneTo(ArraySegment that) {
        that.a = this.a;
        that.b = this.b;
        that.c = this.c;
    }

    @Override
    public ArraySegment Clone() {
        ArraySegment<T> arraySegment = new ArraySegment<T>();
        this.CloneTo(arraySegment);
        return arraySegment;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(ArraySegment obj1, ArraySegment obj2) {
        return obj1.equals(obj2);
    }
}

