/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email;

import com.aspose.email.EmlLoadOptions;
import com.aspose.email.FolderInfo;
import com.aspose.email.MailMessage;
import com.aspose.email.MapiConversionOptions;
import com.aspose.email.MapiMessage;
import com.aspose.email.MboxLoadOptions;
import com.aspose.email.MboxStorageReader;
import com.aspose.email.MboxToPstConversionOptions;
import com.aspose.email.MboxrdStorageReader;
import com.aspose.email.PersonalStorage;
import com.aspose.email.internal.b.zar;
import com.aspose.email.internal.ev.za;
import com.aspose.email.system.AsyncCallback;
import com.aspose.email.system.IAsyncResult;
import com.aspose.email.system.MulticastDelegate;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.io.FileStream;
import com.aspose.email.system.io.Stream;
import com.aspose.email.zakp;
import com.aspose.email.zbnu;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MailStorageConverter {
    private static EmlLoadOptions a = new EmlLoadOptions();

    public static EmlLoadOptions getMboxMessageOptions() {
        return a;
    }

    public static void setMboxMessageOptions(EmlLoadOptions value) {
        a = value;
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstFileName, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName, MailHandler mailHandler) {
        if (zar.a(mboxFileName)) {
            throw new ArgumentException(zbnu.a(new byte[]{-124, -18, 69, -120, 124, -71, -70, -96, 57, -69, 76, 44, 11, 61, 53, 58, 39, 69, 91, 98, -23, -18, 79, -48, 50, -86, -65, -96, 124, -12, 80, 109, 3, 53, 101, 45, 63}), zbnu.a(new byte[]{-92, -18, 69, -120, 26, -74, -65, -87, 18, -6, 79, 40}));
        }
        return MailStorageConverter.a(new FileStream(mboxFileName, 3, 1), pstFileName, mailHandler);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, String pstFileName) {
        return MailStorageConverter.a(Stream.fromJava(mboxrdDataStream), pstFileName);
    }

    static PersonalStorage a(Stream stream, String string) {
        return MailStorageConverter.a(stream, string, null);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, String pstFileName, MailHandler mailHandler) {
        return MailStorageConverter.a(Stream.fromJava(mboxrdDataStream), pstFileName, mailHandler);
    }

    static PersonalStorage a(Stream stream, String string, MailHandler mailHandler) {
        if (zar.a(string)) {
            throw new ArgumentException(zbnu.a(new byte[]{-103, -1, 94, -48, 58, -74, -65, -87, 124, -11, 67, 32, 3, 120, 118, 56, 40, 12, 8, 54, -85, -23, 10, -98, 41, -77, -65, -20, 51, -23, 2, 40, 11, 40, 97, 32}), zbnu.a(new byte[]{-71, -1, 94, -74, 53, -77, -74, -126, 61, -10, 71}));
        }
        return MailStorageConverter.mboxToPst(stream, (Stream)new FileStream(string, 2, 3), mailHandler);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, OutputStream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstDataStream, null);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, Stream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstDataStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(String mboxFileName, OutputStream pstDataStream, MailHandler mailHandler) {
        PersonalStorage personalStorage;
        FileInputStream fileInputStream = new FileInputStream(mboxFileName);
        try {
            personalStorage = MailStorageConverter.mboxToPst((InputStream)fileInputStream, pstDataStream, mailHandler);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        ((InputStream)fileInputStream).close();
        return personalStorage;
    }

    public static PersonalStorage mboxToPst(String mboxFileName, Stream pstDataStream, MailHandler mailHandler) {
        if (zar.a(mboxFileName)) {
            throw new ArgumentException(zbnu.a(new byte[]{-124, -18, 69, -120, 124, -71, -70, -96, 57, -69, 76, 44, 11, 61, 53, 58, 39, 69, 91, 98, -23, -18, 79, -48, 50, -86, -65, -96, 124, -12, 80, 109, 3, 53, 101, 45, 63}), zbnu.a(new byte[]{-92, -18, 69, -120, 26, -74, -65, -87, 18, -6, 79, 40}));
        }
        return MailStorageConverter.mboxToPst((Stream)new FileStream(mboxFileName, 3, 1), pstDataStream, mailHandler);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, mboxToPstConversionOptions);
    }

    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, mboxToPstConversionOptions);
    }

    public static void mboxToPst(MboxStorageReader mboxStorageReader, PersonalStorage pst, String pstFolderName, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        MailStorageConverter.mboxToPst(mboxStorageReader, pst, pstFolderName, mboxToPstConversionOptions);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName, MboxToPstConversionOptions options) {
        if (zar.a(mboxFileName)) {
            throw new ArgumentException(zbnu.a(new byte[]{-124, -18, 69, -120, 124, -71, -70, -96, 57, -69, 76, 44, 11, 61, 53, 58, 39, 69, 91, 98, -23, -18, 79, -48, 50, -86, -65, -96, 124, -12, 80, 109, 3, 53, 101, 45, 63}), zbnu.a(new byte[]{-92, -18, 69, -120, 26, -74, -65, -87, 18, -6, 79, 40}));
        }
        if (zar.a(pstFileName)) {
            throw new ArgumentException(zbnu.a(new byte[]{-103, -1, 94, -48, 58, -74, -65, -87, 124, -11, 67, 32, 3, 120, 118, 56, 40, 12, 8, 54, -85, -23, 10, -98, 41, -77, -65, -20, 51, -23, 2, 40, 11, 40, 97, 32}), zbnu.a(new byte[]{-71, -1, 94, -74, 53, -77, -74, -126, 61, -10, 71}));
        }
        return MailStorageConverter.mboxToPst((Stream)new FileStream(mboxFileName, 3, 1), (Stream)new FileStream(pstFileName, 2, 3), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream, MboxToPstConversionOptions options) {
        if (mboxrdDataStream == null) {
            throw new ArgumentNullException(zbnu.a(new byte[]{-92, -18, 69, -120, 46, -69, -105, -83, 40, -6, 113, 57, 20, 61, 116, 52}));
        }
        if (pstDataStream == null) {
            throw new ArgumentNullException(zbnu.a(new byte[]{-71, -1, 94, -76, 61, -85, -78, -97, 40, -23, 71, 44, 11}));
        }
        PersonalStorage personalStorage = PersonalStorage.create(pstDataStream, 0);
        MboxLoadOptions mboxLoadOptions = new MboxLoadOptions();
        mboxLoadOptions.setLeaveOpen(false);
        MboxrdStorageReader mboxrdStorageReader = new MboxrdStorageReader(mboxrdDataStream, mboxLoadOptions);
        try {
            MailStorageConverter.mboxToPst((MboxStorageReader)mboxrdStorageReader, personalStorage, zbnu.a(new byte[]{-128, -30, 72, -97, 36}), options);
        }
        finally {
            if (mboxrdStorageReader != null) {
                mboxrdStorageReader.dispose();
            }
        }
        return personalStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream, MboxToPstConversionOptions options) {
        if (mboxrdDataStream == null) {
            throw new ArgumentNullException(zbnu.a(new byte[]{-92, -18, 69, -120, 46, -69, -105, -83, 40, -6, 113, 57, 20, 61, 116, 52}));
        }
        if (pstDataStream == null) {
            throw new ArgumentNullException(zbnu.a(new byte[]{-71, -1, 94, -76, 61, -85, -78, -97, 40, -23, 71, 44, 11}));
        }
        PersonalStorage personalStorage = PersonalStorage.a(pstDataStream, 0);
        MboxLoadOptions mboxLoadOptions = new MboxLoadOptions();
        mboxLoadOptions.setLeaveOpen(false);
        MboxrdStorageReader mboxrdStorageReader = new MboxrdStorageReader(mboxrdDataStream, mboxLoadOptions);
        try {
            MailStorageConverter.mboxToPst((MboxStorageReader)mboxrdStorageReader, personalStorage, zbnu.a(new byte[]{-128, -30, 72, -97, 36}), options);
        }
        finally {
            if (mboxrdStorageReader != null) {
                mboxrdStorageReader.dispose();
            }
        }
        return personalStorage;
    }

    public static void mboxToPst(MboxStorageReader mboxStorageReader, PersonalStorage pst, String pstFolderName, MboxToPstConversionOptions options) {
        MailMessage mailMessage;
        if (mboxStorageReader == null) {
            throw new ArgumentNullException(zbnu.a(new byte[]{-92, -18, 69, -120, 15, -85, -68, -66, 61, -4, 71, 31, 3, 57, 113, 60, 52}));
        }
        if (pst == null) {
            throw new ArgumentNullException(zbnu.a(new byte[]{-71, -1, 94}));
        }
        FolderInfo folderInfo = pst.getRootFolder().getSubFolder(pstFolderName);
        if (folderInfo == null) {
            folderInfo = pst.getRootFolder().addSubFolder(pstFolderName);
        }
        while ((mailMessage = mboxStorageReader.readNextMessage(MailStorageConverter.getMboxMessageOptions())) != null) {
            if (options.getMessageHandler() != null) {
                options.getMessageHandler().invoke(mailMessage);
            }
            MapiConversionOptions mapiConversionOptions = MapiConversionOptions.getUnicodeFormat();
            mapiConversionOptions.setRemoveSignature(options != null ? options.getRemoveSignature() : false);
            folderInfo.addMessage(MapiMessage.fromMailMessage(mailMessage, mapiConversionOptions));
        }
    }

    public static abstract class MailHandler
    extends MulticastDelegate {
        public abstract void invoke(MailMessage var1);

        public final IAsyncResult beginInvoke(MailMessage message, AsyncCallback callback, Object state) {
            return za.a(new zakp(this, this, callback, state, message));
        }

        public final void endInvoke(IAsyncResult result) {
            za.a(this, result);
        }
    }
}

