/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.events;

import com.aspose.html.dom.DOMObject;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.EventTarget;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.attributes.DOMConstructorAttribute;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMNullableAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.attributes.DOMTimeStampAttribute;
import com.aspose.html.dom.events.CustomEvent;
import com.aspose.html.dom.events.ErrorEvent;
import com.aspose.html.dom.events.KeyboardEvent;
import com.aspose.html.dom.events.MouseEvent;
import com.aspose.html.dom.events.UIEvent;
import com.aspose.html.dom.events.z3;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.LinkedList;
import com.aspose.html.internal.ms.System.Collections.Generic.LinkedListNode;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p4.z33;
import com.aspose.html.window.z14;
import java.util.concurrent.atomic.AtomicReference;

@DOMObjectAttribute
@DOMNameAttribute(name="Event")
public class Event
extends DOMObject {
    @DOMNameAttribute(name="NONE")
    public static final int NONE_PHASE = 0;
    @DOMNameAttribute(name="CAPTURING_PHASE")
    public static final int CAPTURING_PHASE = 1;
    @DOMNameAttribute(name="AT_TARGET")
    public static final int AT_TARGET_PHASE = 2;
    @DOMNameAttribute(name="BUBBLING_PHASE")
    public static final int BUBBLING_PHASE = 3;
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("CUSTOMEVENT", "EVENT", "EVENTS", "HTMLEVENTS", "KEYBOARDEVENT", "KEYEVENTS", "MOUSEEVENT", "MOUSEEVENTS", "UIEVENT", "UIEVENTS");
    private z2 flags = new z2();
    private boolean auto_Bubbles;
    private boolean auto_Cancelable;
    private EventTarget auto_CurrentTarget;
    private int auto_EventPhase;
    private EventTarget auto_Target;
    private long auto_TimeStamp;
    private String auto_Type;
    private boolean auto_IsTrusted;

    @DOMConstructorAttribute
    public Event(String type) {
        this(type, new z1());
    }

    @DOMConstructorAttribute
    public Event(String type, z1 eventInitDict) {
        this.setEventPhase(0);
        this.flags.set(z2.m7370);
        this.setType(type);
        this.setBubbles(eventInitDict.getBubbles());
        this.setCancelable(eventInitDict.getCancelable());
        this.setTrusted(eventInitDict.isTrusted());
        this.setTimeStamp(Convert.toUInt64(DateTime.getNow().getTicks()));
    }

    public static Event createDOMContentLoadedEvent(z1 eventInit) {
        return Event.createEvent("DOMContentLoaded", eventInit);
    }

    public static Event createEvent(String type) {
        return Event.createEvent(type, new z1());
    }

    public static Event createEvent(String type, z1 eventInit) {
        eventInit.setTrusted(true);
        return new Event(type, eventInit);
    }

    public static Event createError(Exception exception) {
        return new ErrorEvent(exception, new ErrorEvent.z1());
    }

    public static Event createEventByType(String eventType) {
        Event event;
        switch (gStringSwitchMap.of(StringExtensions.toUpperInvariant(eventType))) {
            case 0: {
                event = new CustomEvent(StringExtensions.Empty);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                event = new Event(StringExtensions.Empty);
                break;
            }
            case 4: 
            case 5: {
                event = new KeyboardEvent(StringExtensions.Empty);
                break;
            }
            case 6: 
            case 7: {
                event = new MouseEvent(StringExtensions.Empty);
                break;
            }
            case 8: 
            case 9: {
                event = new UIEvent(StringExtensions.Empty);
                break;
            }
            default: {
                throw com.aspose.html.internal.p68.z1.m1237();
            }
        }
        event.flags.m31(z2.m7370);
        return event;
    }

    @DOMNameAttribute(name="bubbles")
    public boolean getBubbles() {
        return this.auto_Bubbles;
    }

    @DOMNameAttribute(name="bubbles")
    private void setBubbles(boolean value) {
        this.auto_Bubbles = value;
    }

    @DOMNameAttribute(name="cancelable")
    public boolean getCancelable() {
        return this.auto_Cancelable;
    }

    @DOMNameAttribute(name="cancelable")
    private void setCancelable(boolean value) {
        this.auto_Cancelable = value;
    }

    @DOMNameAttribute(name="currentTarget")
    @DOMNullableAttribute
    public EventTarget getCurrentTarget() {
        return this.auto_CurrentTarget;
    }

    @DOMNameAttribute(name="currentTarget")
    @DOMNullableAttribute
    public void setCurrentTarget(EventTarget value) {
        this.auto_CurrentTarget = value;
    }

    @DOMNameAttribute(name="eventPhase")
    public int getEventPhase() {
        return this.auto_EventPhase;
    }

    @DOMNameAttribute(name="eventPhase")
    public void setEventPhase(int value) {
        this.auto_EventPhase = value;
    }

    @DOMNameAttribute(name="target")
    @DOMNullableAttribute
    public EventTarget getTarget() {
        return this.auto_Target;
    }

    @DOMNameAttribute(name="target")
    @DOMNullableAttribute
    public void setTarget(EventTarget value) {
        this.auto_Target = value;
    }

    @DOMNameAttribute(name="timeStamp")
    @DOMTimeStampAttribute
    public long getTimeStamp() {
        return this.auto_TimeStamp;
    }

    @DOMNameAttribute(name="timeStamp")
    @DOMTimeStampAttribute
    private void setTimeStamp(long value) {
        this.auto_TimeStamp = value;
    }

    @DOMNameAttribute(name="type")
    public String getType() {
        return this.auto_Type;
    }

    @DOMNameAttribute(name="type")
    private void setType(String value) {
        this.auto_Type = value;
    }

    @DOMNameAttribute(name="defaultPrevented")
    public boolean getDefaultPrevented() {
        return this.flags.get(z2.m7367);
    }

    @DOMNameAttribute(name="isTrusted")
    public boolean isTrusted() {
        return this.auto_IsTrusted;
    }

    @DOMNameAttribute(name="isTrusted")
    private void setTrusted(boolean value) {
        this.auto_IsTrusted = value;
    }

    @DOMNameAttribute(name="initEvent")
    public void initEvent(String type, boolean bubbles, boolean cancelable) {
        if (this.flags.get(z2.m7371)) {
            return;
        }
        this.flags.set(z2.m7370);
        this.flags.m31(z2.m7365);
        this.flags.m31(z2.m7366);
        this.flags.m31(z2.m7367);
        this.setTrusted(false);
        this.setTarget(null);
        this.setType(type);
        this.setBubbles(bubbles);
        this.setCancelable(cancelable);
        this.setTimeStamp(Convert.toUInt64(DateTime.getNow().getTicks()));
    }

    @DOMNameAttribute(name="preventDefault")
    public void preventDefault() {
        if (this.getCancelable() && !this.flags.get(z2.m7368)) {
            this.flags.set(z2.m7367);
        }
    }

    @DOMNameAttribute(name="stopPropagation")
    public void stopPropagation() {
        this.flags.set(z2.m7365);
    }

    @DOMNameAttribute(name="stopImmediatePropagation")
    public void stopImmediatePropagation() {
        this.flags.set(z2.m7365);
        this.flags.set(z2.m7366);
    }

    public boolean dispatch(EventTarget targetOverride) {
        LinkedListNode<EventTarget> linkedListNode;
        if (this.flags.get(z2.m7371) || !this.flags.get(z2.m7370)) {
            throw com.aspose.html.internal.p68.z1.m1239();
        }
        this.flags.set(z2.m7371);
        this.setTarget(targetOverride);
        LinkedList<EventTarget> linkedList = this.getPath(this.getTarget());
        this.setEventPhase(1);
        for (linkedListNode = linkedList.getFirst(); linkedListNode != null && !this.flags.get(z2.m7365); linkedListNode = linkedListNode.getNext()) {
            this.invoke(linkedListNode.getValue());
        }
        this.setEventPhase(2);
        if (!this.flags.get(z2.m7365)) {
            this.invoke(this.getTarget());
        }
        if (this.getBubbles()) {
            this.setEventPhase(3);
            for (linkedListNode = linkedList.getLast(); linkedListNode != null && !this.flags.get(z2.m7365); linkedListNode = linkedListNode.getPrevious()) {
                this.invoke(linkedListNode.getValue());
            }
        }
        this.flags.m31(z2.m7371);
        this.setEventPhase(0);
        this.setCurrentTarget(null);
        return !this.flags.get(z2.m7367);
    }

    private LinkedList<EventTarget> getPath(EventTarget target) {
        Node node;
        LinkedList<EventTarget> linkedList = new LinkedList<EventTarget>();
        while (target != null && (node = Operators.as(target, Node.class)) != null) {
            target = (node.getNodeType() & 0xFFFF) != 9 ? node.getParentNode() : Operators.as(((Document)node).getContext().getWindow(), EventTarget.class);
            if (target == null) continue;
            linkedList.addFirst(target);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(EventTarget target) {
        List<z3.z2> list = new List<z3.z2>(target.EventMap.m260(this.getType()));
        this.setCurrentTarget(target);
        IGenericEnumerator iGenericEnumerator = list.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                z3.z2 z2100 = (z3.z2)iGenericEnumerator.next();
                if (this.flags.get(z2.m7365)) {
                    return;
                }
                if (this.getEventPhase() == 1 && !z2100.m1209() || this.getEventPhase() == 3 && z2100.m1209()) continue;
                try {
                    z2100.m1212().handleEvent(this);
                }
                catch (Exception exception) {
                    Node node = Operators.as(target, Node.class);
                    Document document = node != null ? node.nodeDocument : ((z14)target).getBrowsingContext().getActiveDocument();
                    document.dispatchEvent(new ErrorEvent(exception));
                }
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    public static class z1
    extends Dictionary<String, Object> {
        private boolean auto_IsTrusted;

        public boolean getBubbles() {
            return com.aspose.html.internal.p8.z1.m1(String.class, Object.class, Boolean.class, this, "bubbles", false);
        }

        public void setBubbles(boolean value) {
            this.set_Item("bubbles", value);
        }

        public boolean getCancelable() {
            return com.aspose.html.internal.p8.z1.m1(String.class, Object.class, Boolean.class, this, "cancelable", false);
        }

        public void setCancelable(boolean value) {
            this.set_Item("cancelable", value);
        }

        public boolean isTrusted() {
            return this.auto_IsTrusted;
        }

        public void setTrusted(boolean value) {
            this.auto_IsTrusted = value;
        }
    }

    private static class z2
    extends z33 {
        public static final int m7365;
        public static final int m7366;
        public static final int m7367;
        public static final int m7368;
        public static final int m7369;
        public static final int m7370;
        public static final int m7371;
        private static AtomicReference<z33.z1> m45;

        public z2() {
            super(m45.get());
        }

        static {
            m45 = new AtomicReference<Object>(null);
            z33.z1 z1100 = new z33.z1();
            m7365 = z1100.m73("STOP_PROPAGATION");
            m7366 = z1100.m73("STOP_IMMEDIATE_PROPAGATION");
            m7367 = z1100.m73("CANCELED");
            m7368 = z1100.m73("IN_PASSIVE_LISTENER");
            m7369 = z1100.m73("COMPOSED");
            m7370 = z1100.m73("INITIALIZED");
            m7371 = z1100.m73("DISPATCH");
            m45.set(z1100);
        }
    }
}

