/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.forms;

import com.aspose.html.HTMLButtonElement;
import com.aspose.html.HTMLDocument;
import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLFormElement;
import com.aspose.html.HTMLInputElement;
import com.aspose.html.HTMLOptionElement;
import com.aspose.html.HTMLSelectElement;
import com.aspose.html.HTMLTextAreaElement;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.dom.DOMException;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.z2;
import com.aspose.html.forms.ButtonElement;
import com.aspose.html.forms.FormElementBase;
import com.aspose.html.forms.InputElement;
import com.aspose.html.forms.OptionElement;
import com.aspose.html.forms.SelectElement;
import com.aspose.html.forms.TextAreaElement;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericDictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyValuePair;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p332.z4;
import com.aspose.html.net.HttpMethod;
import com.aspose.html.z20;
import java.util.Map;

public class FormEditor
implements IGenericEnumerable<FormElementBase>,
IDisposable {
    private static final Dictionary<Type, z20> TypeToTagMap = new Dictionary();
    private HTMLFormElement _form;
    private Dictionary<Element, FormElementBase> _fields = new Dictionary();

    private FormEditor(HTMLFormElement form) {
        this._form = form;
    }

    public static FormEditor createNew(HTMLDocument document) {
        HTMLFormElement hTMLFormElement = (HTMLFormElement)document.createElement("form");
        return FormEditor.create(hTMLFormElement);
    }

    public static FormEditor create(HTMLFormElement form) {
        return new FormEditor(form);
    }

    public static FormEditor create(HTMLDocument document, int index) {
        HTMLCollection hTMLCollection = document.getForms();
        if (index < 0 || index >= hTMLCollection.getLength()) {
            throw com.aspose.html.internal.p68.z1.m1231();
        }
        return FormEditor.create((HTMLFormElement)hTMLCollection.get_Item(index));
    }

    public static FormEditor create(HTMLDocument document, String id2) {
        Element element = document.getElementById(id2);
        if (element == null) {
            throw com.aspose.html.internal.p68.z1.m1236();
        }
        HTMLFormElement hTMLFormElement = Operators.as(element, HTMLFormElement.class);
        if (hTMLFormElement == null) {
            throw com.aspose.html.internal.p68.z1.m1263();
        }
        return FormEditor.create(hTMLFormElement);
    }

    public HTMLFormElement getForm() {
        return this._form;
    }

    public int getCount() {
        return this._form.getLength();
    }

    public HttpMethod getMethod() {
        return new HttpMethod(this._form.getMethod());
    }

    public void setMethod(HttpMethod value) {
        this._form.setMethod(value.getName());
    }

    public String getAction() {
        return this._form.getAction();
    }

    public void setAction(String value) {
        this._form.setAction(value);
    }

    public <T extends FormElementBase> T add(String name, Class<T> clazz) {
        Type type = Operators.typeOf(clazz);
        if (!TypeToTagMap.containsKey(type)) {
            throw new ArgumentException(StringExtensions.format("'{0}' is not valid.", type));
        }
        Element element = this._form.getOwnerDocument().createElement(z20.m1(TypeToTagMap.get_Item(type)));
        element.setAttribute("name", name);
        this._form.appendChild(element);
        return (T)this.getOrCreate((HTMLElement)element);
    }

    public InputElement addInput(String name) {
        return this.addInput(name, 2);
    }

    public InputElement addInput(String name, int type) {
        InputElement inputElement = this.add(name, InputElement.class);
        inputElement.setType(type);
        return inputElement;
    }

    public FormElementBase get_Item(int index) {
        HTMLElement hTMLElement = Operators.as(this._form.getElements().get_Item(index), HTMLElement.class);
        if (hTMLElement == null) {
            throw com.aspose.html.internal.p68.z1.m1231();
        }
        return this.getOrCreate(hTMLElement);
    }

    public FormElementBase get_Item(String name) {
        HTMLElement hTMLElement = Operators.as(this._form.getElements().namedItem(name), HTMLElement.class);
        if (hTMLElement == null) {
            throw com.aspose.html.internal.p68.z1.m1236();
        }
        return this.getOrCreate(hTMLElement);
    }

    public <T extends FormElementBase> T getElement(Class<T> typeOfT, int index) {
        return (T)((FormElementBase)Operators.as(this.get_Item(index), typeOfT));
    }

    public <T extends FormElementBase> T getElement(Class<T> typeOfT, String name) {
        return (T)((FormElementBase)Operators.as(this.get_Item(name), typeOfT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void fill(IGenericDictionary<String, String> values) {
        block8: {
            IGenericEnumerator iGenericEnumerator = values.iterator();
            block5: while (true) {
                while (iGenericEnumerator != null && iGenericEnumerator.hasNext()) {
                    KeyValuePair keyValuePair = (KeyValuePair)iGenericEnumerator.next();
                    try {
                        FormElementBase formElementBase = this.get_Item((String)keyValuePair.getKey());
                        formElementBase.setValue((String)keyValuePair.getValue());
                        continue block5;
                    }
                    catch (DOMException dOMException) {
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                if (iGenericEnumerator != null && Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }

    public void fill(Map values) {
        this.fill(new z4<String, String>(values));
    }

    @Override
    public IGenericEnumerator<FormElementBase> iterator() {
        return new z1(this);
    }

    @Override
    public void dispose() {
        this._fields.clear();
    }

    private FormElementBase getOrCreate(HTMLElement element) {
        if (!this._fields.containsKey(element)) {
            z20 z2010 = element._Tag;
            if (ObjectExtensions.referenceEquals(z2010, z2.z9.m3959)) {
                this._fields.addItem(element, new InputElement((HTMLInputElement)element));
            } else if (ObjectExtensions.referenceEquals(z2010, z2.z9.m3961)) {
                this._fields.addItem(element, new SelectElement((HTMLSelectElement)element));
            } else if (ObjectExtensions.referenceEquals(z2010, z2.z9.m3964)) {
                this._fields.addItem(element, new OptionElement((HTMLOptionElement)element));
            } else if (ObjectExtensions.referenceEquals(z2010, z2.z9.m3965)) {
                this._fields.addItem(element, new TextAreaElement((HTMLTextAreaElement)element));
            } else if (ObjectExtensions.referenceEquals(z2010, z2.z9.m3960)) {
                this._fields.addItem(element, new ButtonElement((HTMLButtonElement)element));
            } else {
                this._fields.addItem(element, new com.aspose.html.forms.z1(element));
            }
        }
        return this._fields.get_Item(element);
    }

    static {
        TypeToTagMap.addItem(Operators.typeOf(InputElement.class), z2.z9.m3959);
        TypeToTagMap.addItem(Operators.typeOf(SelectElement.class), z2.z9.m3961);
        TypeToTagMap.addItem(Operators.typeOf(OptionElement.class), z2.z9.m3964);
        TypeToTagMap.addItem(Operators.typeOf(TextAreaElement.class), z2.z9.m3965);
        TypeToTagMap.addItem(Operators.typeOf(ButtonElement.class), z2.z9.m3960);
    }

    private static class z1
    implements IGenericEnumerator<FormElementBase> {
        private FormEditor m9154;
        private IGenericEnumerator<Element> m494;

        public z1(FormEditor formEditor) {
            this.m9154 = formEditor;
            this.m494 = formEditor.getForm().getElements().iterator();
        }

        @Override
        public void dispose() {
            this.m494.dispose();
        }

        @Override
        public boolean hasNext() {
            return this.m494.hasNext();
        }

        @Override
        public void reset() {
            this.m494.reset();
        }

        public FormElementBase m2010() {
            return this.m9154.getOrCreate((HTMLElement)this.m494.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.m2010();
        }
    }
}

