/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.core.System.f;
import com.aspose.html.internal.ms.core.System.k;
import com.aspose.html.internal.ms.lang.Extensions;

@Extensions
public final class ByteExtensions {
    public static final int MinValue = 0;
    public static final int MaxValue = 255;

    public static int compareTo(byte a2, byte b2) {
        if ((a2 & 0xFF) < (b2 & 0xFF)) {
            return -1;
        }
        if ((a2 & 0xFF) > (b2 & 0xFF)) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(byte a2, Object b2) {
        if (b2 == null) {
            return 1;
        }
        if (b2.getClass() != Byte.class) {
            throw new ArgumentException("Object must be of type Byte");
        }
        byte by2 = Convert.toByte(b2);
        if ((a2 & 0xFF) < (by2 & 0xFF)) {
            return -1;
        }
        if ((a2 & 0xFF) > (by2 & 0xFF)) {
            return 1;
        }
        return 0;
    }

    public static boolean equals(byte a2, byte b2) {
        return (a2 & 0xFF) == (b2 & 0xFF);
    }

    public static boolean equals(byte a2, Object b2) {
        if (b2 == null || b2.getClass() != Byte.class) {
            return false;
        }
        return Convert.toByte(b2) == (a2 & 0xFF);
    }

    public static int getHashCode(byte a2) {
        return a2 & 0xFF;
    }

    public static int getTypeCode() {
        return 6;
    }

    public static byte parse(String s2) {
        return f.a(s2);
    }

    public static byte parse(String s2, int numberStyles) {
        return f.a(s2, numberStyles);
    }

    public static byte parse(String s2, IFormatProvider provider) {
        return f.a(s2, provider);
    }

    public static byte parse(String s2, int numberStyles, IFormatProvider provider) {
        return f.a(s2, numberStyles, provider);
    }

    public static String toString(byte value) {
        return k.b(null, value, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(byte value, IFormatProvider provider) {
        return k.b(null, value, provider);
    }

    public static String toString(byte value, String pattern) {
        return k.b(pattern, value, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(byte value, String pattern, IFormatProvider provider) {
        return k.b(pattern, value, provider);
    }

    public static boolean tryParse(String source, int numberStyles, IFormatProvider provider, byte[] referenceToValue) {
        try {
            referenceToValue[0] = ByteExtensions.parse(source, numberStyles, provider);
            return true;
        }
        catch (Exception exception) {
            referenceToValue[0] = 0;
            return false;
        }
    }

    public static boolean tryParse(String source, byte[] referenceToValue) {
        return ByteExtensions.tryParse(source, 7, NumberFormatInfo.getCurrentInfo(), referenceToValue);
    }
}

