/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.SerializableAttribute;

@SerializableAttribute
public final class BitArray
implements ICollection,
ICloneable {
    private int[] a;
    private int b;
    private int c = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.b = bits.b;
        this.a = new int[(this.b + 31) / 32];
        if (this.a.length == 1) {
            this.a[0] = bits.a[0];
        } else {
            Array.copy(Array.boxing(bits.a), 0, Array.boxing(this.a), 0, this.a.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.b = values.length;
        this.a = new int[(this.b + 31) / 32];
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.set_Item(i2, values[i2]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.b = bytes.length * 8;
        this.a = new int[(this.b + 31) / 32];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            this.a(i2, bytes[i2]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n2 = values.length;
        this.b = n2 * 32;
        this.a = new int[n2];
        Array.copy(Array.boxing(values), 0, Array.boxing(this.a), 0, n2);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.b = length;
        this.a = new int[(this.b + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2] = -1;
            }
        }
    }

    private BitArray(int[] array, int length) {
        this.a = array;
        this.b = length;
    }

    private byte a(int n2) {
        int n3 = n2 / 4;
        int n4 = n2 % 4 * 8;
        int n5 = this.a[n3] & 255 << n4;
        return (byte)(n5 >> n4 & 0xFF);
    }

    private void a(int n2, byte by2) {
        int n3 = n2 / 4;
        int n4 = n2 % 4 * 8;
        int n5 = n3;
        this.a[n5] = this.a[n5] & ~(255 << n4);
        int n6 = n3;
        this.a[n6] = this.a[n6] | (by2 & 0xFF) << n4;
        ++this.c;
    }

    private void b(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.b != this.b) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.b;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.b;
    }

    public void setLength(int value) {
        if (this.b == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.b) {
            int n2 = (value + 31) / 32;
            int n3 = (this.b + 31) / 32;
            if (n2 > this.a.length) {
                int[] nArray = new int[n2];
                Array.copy(Array.boxing(this.a), 0, Array.boxing(nArray), 0, this.a.length);
                this.a = nArray;
            } else {
                Array.clear(Array.boxing(this.a), n3, n2 - n3);
            }
            int n4 = this.b % 32;
            if (n4 > 0) {
                int n5 = n3 - 1;
                this.a[n5] = this.a[n5] & (1 << n4) - 1;
            }
        }
        this.b = value;
        ++this.c;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(Array array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.getRank() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.getLength() && this.b > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = Array.unboxing(array);
        if (object instanceof Boolean[]) {
            if (array.getLength() - index < this.b) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i2 = 0; i2 < this.b; ++i2) {
                booleanArray[index + i2] = this.get_Item(i2);
            }
        } else if (object instanceof boolean[]) {
            if (array.getLength() - index < this.b) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i3 = 0; i3 < this.b; ++i3) {
                blArray[index + i3] = this.get_Item(i3);
            }
        } else if (object instanceof Byte[]) {
            int n2 = (this.b + 7) / 8;
            if (array.getLength() - index < n2) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i4 = 0; i4 < n2; ++i4) {
                byteArray[index + i4] = this.a(i4);
            }
        } else if (object instanceof byte[]) {
            int n3 = (this.b + 7) / 8;
            if (array.getLength() - index < n3) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i5 = 0; i5 < n3; ++i5) {
                byArray[index + i5] = this.a(i5);
            }
        } else if (object instanceof Integer[]) {
            Array.copy(Array.boxing(this.a), 0, array, index, (this.b + 31) / 32);
        } else if (object instanceof int[]) {
            Array.copy(Array.boxing(this.a), 0, array, index, (this.b + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n2 = (this.b + 31) / 32;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a[i2] = ~this.a[i2];
        }
        ++this.c;
        return this;
    }

    public BitArray and(BitArray value) {
        this.b(value);
        int n2 = (this.b + 31) / 32;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            this.a[n3] = this.a[n3] & value.a[i2];
        }
        ++this.c;
        return this;
    }

    public BitArray or(BitArray value) {
        this.b(value);
        int n2 = (this.b + 31) / 32;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            this.a[n3] = this.a[n3] | value.a[i2];
        }
        ++this.c;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.b(value);
        int n2 = (this.b + 31) / 32;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            this.a[n3] = this.a[n3] ^ value.a[i2];
        }
        ++this.c;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.b) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.a[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.b) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n2 = index >> 5;
            this.a[n2] = this.a[n2] | 1 << (index & 0x1F);
        } else {
            int n3 = index >> 5;
            this.a[n3] = this.a[n3] & ~(1 << (index & 0x1F));
        }
        ++this.c;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2] = -1;
            }
        } else {
            Array.clear(Array.boxing(this.a), 0, this.a.length);
        }
        ++this.c;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @SerializableAttribute
    private static class BitArrayEnumerator
    implements IEnumerator,
    ICloneable,
    Cloneable {
        private BitArray a;
        private boolean b;
        private int c;
        private int d;

        @Override
        public Object deepClone() {
            return this.a();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.c = -1;
            this.a = ba2;
            this.d = ba2.c;
        }

        @Override
        public Object next() {
            if (this.c == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.c >= this.a.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.b;
        }

        @Override
        public boolean hasNext() {
            this.b();
            if (this.c < this.a.size() - 1) {
                this.b = this.a.get_Item(++this.c);
                return true;
            }
            this.c = this.a.size();
            return false;
        }

        @Override
        public void reset() {
            this.b();
            this.c = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void b() {
            if (this.d != this.a.c) {
                throw new InvalidOperationException();
            }
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.a = this.a;
            bitArrayEnumerator.b = this.b;
            bitArrayEnumerator.c = this.c;
            bitArrayEnumerator.d = this.d;
            return bitArrayEnumerator;
        }
    }
}

