/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Globalization.CompareInfo;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import java.util.Comparator;

@SerializableAttribute
public final class Comparer
implements Comparator {
    public static final Comparer Default = new Comparer(CultureInfo.getCurrentCulture());
    public static final Comparer DefaultInvariant = new Comparer(CultureInfo.getInvariantCulture());
    private CompareInfo a;

    private Comparer() {
        this.a = null;
    }

    public Comparer(CultureInfo culture) {
        if (culture == null) {
            throw new ArgumentNullException("culture");
        }
        this.a = culture.getCompareInfo();
    }

    public int compare(Object a2, Object b2) {
        if (a2 == b2) {
            return 0;
        }
        if (a2 == null) {
            return -1;
        }
        if (b2 == null) {
            return 1;
        }
        if (this.a != null && a2 instanceof String && b2 instanceof String) {
            return this.a.compare((String)a2, (String)b2);
        }
        try {
            if (a2 instanceof Comparable) {
                return ((Comparable)a2).compareTo(b2);
            }
            if (b2 instanceof Comparable) {
                return ((Comparable)b2).compareTo(a2);
            }
        }
        catch (ClassCastException classCastException) {
            throw new ArgumentException("value A is not of the same type as B");
        }
        throw new ArgumentException("At least one object must implement Comparable.");
    }
}

