/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections.Generic;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import java.util.Comparator;

@SerializableAttribute
public abstract class Comparer<T>
implements Comparator<T> {
    static Comparer a = new DefaultComparer();

    @Override
    public abstract int compare(T var1, T var2);

    public static <T> Comparer<T> getDefault() {
        return a;
    }

    @SerializableAttribute
    static final class DefaultComparer<T>
    extends Comparer<T> {
        DefaultComparer() {
        }

        @Override
        public int compare(T x2, T y2) {
            if (x2 == null) {
                return y2 == null ? 0 : -1;
            }
            if (y2 == null) {
                return 1;
            }
            if (x2 instanceof String && y2 instanceof String) {
                return CultureInfo.getCurrentCulture().getCompareInfo().compare((String)x2, (String)y2, 0L);
            }
            if (x2 instanceof Comparable) {
                return ((Comparable)x2).compareTo(y2);
            }
            throw new ArgumentException("Neither 'x' nor 'y' implement Comparable");
        }
    }
}

