/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections.Specialized;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.Struct;

public class BitVector32
extends Struct<BitVector32> {
    private int a;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.a = value.a;
    }

    public BitVector32(int data) {
        this.a = data;
    }

    public int getData() {
        return this.a;
    }

    public int get_Item(Section section) {
        return this.a >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.a &= ~(section.getMask() << section.getOffset());
        this.a |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.a & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.a = value ? (this.a |= bit) : (this.a &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n2 = BitVector32.a(maxValue);
        int n3 = (1 << n2) - 1;
        int n4 = previous.getOffset() + BitVector32.a(previous.getMask());
        if (n4 + n2 > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(Operators.castToInt16(n3, 9), Operators.castToInt16(n4, 9));
    }

    public boolean equals(Object o2) {
        return Operators.is(o2, BitVector32.class) && this.a == Operators.unboxing((Object)o2, BitVector32.class).a;
    }

    public int hashCode() {
        return Int32Extensions.getHashCode(this.a);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.append("BitVector32{");
        for (long i2 = Operators.castToInt64(0x80000000L, 10); i2 > 0L; i2 >>= 1) {
            msStringBuilder2.append(((long)value.a & i2) == 0L ? (char)'0' : '1');
        }
        msStringBuilder2.append('}');
        return msStringBuilder2.toString();
    }

    private static int a(int n2) {
        int n3 = 0;
        while (n2 >> n3 != 0) {
            ++n3;
        }
        return n3;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.a = this.a;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends Struct<Section> {
        private short a;
        private short b;

        public Section() {
        }

        Section(short mask, short offset) {
            this.a = mask;
            this.b = offset;
        }

        public short getMask() {
            return this.a;
        }

        public short getOffset() {
            return this.b;
        }

        public static boolean op_Equality(Section a2, Section b2) {
            return a2.a == b2.a && a2.b == b2.b;
        }

        public static boolean op_Inequality(Section a2, Section b2) {
            return a2.a != b2.a || a2.b != b2.b;
        }

        public boolean equals(Section obj) {
            return this.a == obj.a && this.b == obj.b;
        }

        public boolean equals(Object o2) {
            if (!Operators.is(o2, Section.class)) {
                return false;
            }
            Section section = Operators.unboxing(o2, Section.class).Clone();
            return this.a == section.a && this.b == section.b;
        }

        public int hashCode() {
            return this.a << this.b;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            msStringBuilder2.append("Section{0x");
            msStringBuilder2.append(Convert.toString(value.getMask(), 16));
            msStringBuilder2.append(", 0x");
            msStringBuilder2.append(Convert.toString(value.getOffset(), 16));
            msStringBuilder2.append("}");
            return msStringBuilder2.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.a = this.a;
            that.b = this.b;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

