/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.DateTimeFormatInfo;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.TimeZoneExtensions;
import com.aspose.time.TimeSpan;
import java.util.TimeZone;

public class DateTimeUtils {
    public static int countRepeat(String fmt, int p2, char c2) {
        int n2;
        int n3 = fmt.length();
        for (n2 = p2 + 1; n2 < n3 && fmt.charAt(n2) == c2; ++n2) {
        }
        return n2 - p2;
    }

    public static void zeroPad(StringBuilder output, int digits, int len) {
        char[] cArray = new char[16];
        int n2 = 16;
        do {
            cArray[--n2] = (char)(48 + digits % 10);
            --len;
        } while ((digits /= 10) > 0);
        while (len-- > 0) {
            cArray[--n2] = 48;
        }
        output.append(new String(cArray, n2, 16 - n2));
    }

    public static int parseQuotedString(String fmt, int pos, StringBuilder output) {
        int n2 = fmt.length();
        int n3 = pos;
        char c2 = fmt.charAt(pos++);
        while (pos < n2) {
            char c3;
            if ((c3 = fmt.charAt(pos++)) == c2) {
                return pos - n3;
            }
            if (c3 == '\\') {
                if (pos >= n2) {
                    throw new FormatException("Un-ended quote");
                }
                output.append(fmt.charAt(pos++));
                continue;
            }
            output.append(c3);
        }
        throw new FormatException("Un-ended quote");
    }

    public static String getStandardPattern(char format, DateTimeFormatInfo dfi, boolean[] useutc, boolean[] use_invariant) {
        return DateTimeUtils.getStandardPattern(format, dfi, useutc, use_invariant, false);
    }

    public static String getStandardPattern(char format, DateTimeFormatInfo dfi, boolean[] useutc, boolean[] use_invariant, boolean date_time_offset) {
        String string;
        useutc[0] = false;
        use_invariant[0] = false;
        switch (format) {
            case 'd': {
                string = dfi.getShortDatePattern();
                break;
            }
            case 'D': {
                string = dfi.getLongDatePattern();
                break;
            }
            case 'f': {
                string = StringExtensions.concat(dfi.getLongDatePattern(), " ", dfi.getShortTimePattern());
                break;
            }
            case 'F': {
                string = dfi.getFullDateTimePattern();
                break;
            }
            case 'g': {
                string = StringExtensions.concat(dfi.getShortDatePattern(), " ", dfi.getShortTimePattern());
                break;
            }
            case 'G': {
                string = StringExtensions.concat(dfi.getShortDatePattern(), " ", dfi.getLongTimePattern());
                break;
            }
            case 'M': 
            case 'm': {
                string = dfi.getMonthDayPattern();
                break;
            }
            case 'O': 
            case 'o': {
                string = dfi.getRoundtripPattern();
                use_invariant[0] = true;
                break;
            }
            case 'R': 
            case 'r': {
                string = dfi.getRFC1123Pattern();
                if (date_time_offset) {
                    useutc[0] = true;
                }
                use_invariant[0] = true;
                break;
            }
            case 's': {
                string = dfi.getSortableDateTimePattern();
                use_invariant[0] = true;
                break;
            }
            case 't': {
                string = dfi.getShortTimePattern();
                break;
            }
            case 'T': {
                string = dfi.getLongTimePattern();
                break;
            }
            case 'u': {
                string = dfi.getUniversalSortableDateTimePattern();
                if (date_time_offset) {
                    useutc[0] = true;
                }
                use_invariant[0] = true;
                break;
            }
            case 'U': {
                if (date_time_offset) {
                    string = null;
                    break;
                }
                string = dfi.getFullDateTimePattern();
                useutc[0] = true;
                break;
            }
            case 'Y': 
            case 'y': {
                string = dfi.getYearMonthPattern();
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public static String getStandardPattern_DateTimeOffset(char format, DateTimeFormatInfo dfi, boolean[] useutc, boolean[] use_invariant, boolean date_time_offset) {
        String string;
        useutc[0] = false;
        use_invariant[0] = false;
        switch (format) {
            case 'd': {
                string = dfi.getShortDatePattern();
                break;
            }
            case 'D': {
                string = dfi.getLongDatePattern();
                break;
            }
            case 'f': {
                string = StringExtensions.concat(dfi.getLongDatePattern(), " ", dfi.getShortTimePattern());
                break;
            }
            case 'F': {
                string = StringExtensions.concat(dfi.getLongDatePattern(), " ", dfi.getLongTimePattern());
                break;
            }
            case 'g': {
                string = StringExtensions.concat(dfi.getShortDatePattern(), " ", dfi.getShortTimePattern());
                break;
            }
            case 'G': {
                string = StringExtensions.concat(dfi.getShortDatePattern(), " ", dfi.getLongTimePattern());
                break;
            }
            case 'M': 
            case 'm': {
                string = dfi.getMonthDayPattern();
                break;
            }
            case 'O': 
            case 'o': {
                string = dfi.getRoundtripPattern();
                use_invariant[0] = true;
                break;
            }
            case 'R': 
            case 'r': {
                string = dfi.getRFC1123Pattern();
                if (date_time_offset) {
                    useutc[0] = true;
                }
                use_invariant[0] = true;
                break;
            }
            case 's': {
                string = dfi.getSortableDateTimePattern();
                use_invariant[0] = true;
                break;
            }
            case 't': {
                string = dfi.getShortTimePattern();
                break;
            }
            case 'T': {
                string = dfi.getLongTimePattern();
                break;
            }
            case 'u': {
                string = dfi.getUniversalSortableDateTimePattern();
                if (date_time_offset) {
                    useutc[0] = true;
                }
                use_invariant[0] = true;
                break;
            }
            case 'U': {
                if (date_time_offset) {
                    string = null;
                    break;
                }
                string = StringExtensions.concat(dfi.getLongDatePattern(), " ", dfi.getLongTimePattern());
                useutc[0] = true;
                break;
            }
            case 'Y': 
            case 'y': {
                string = dfi.getYearMonthPattern();
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public static String toString(DateTime dt2, String format, DateTimeFormatInfo dfi) {
        return DateTimeUtils.toString(dt2.Clone(), null, format, dfi);
    }

    public static String toString(DateTime dt2, TimeSpan utc_offset, String format, DateTimeFormatInfo dfi) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(format.length() + 10);
        block25: for (int i2 = 0; i2 < format.length(); i2 += n2) {
            boolean bl2 = false;
            char c2 = format.charAt(i2);
            switch (c2) {
                case 'h': {
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    int n3 = dt2.getHour() % 12;
                    if (n3 == 0) {
                        n3 = 12;
                    }
                    DateTimeUtils.zeroPad(stringBuilder, n3, n2 == 1 ? 1 : 2);
                    continue block25;
                }
                case 'H': {
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    DateTimeUtils.zeroPad(stringBuilder, dt2.getHour(), n2 == 1 ? 1 : 2);
                    continue block25;
                }
                case 'm': {
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    DateTimeUtils.zeroPad(stringBuilder, dt2.getMinute(), n2 == 1 ? 1 : 2);
                    continue block25;
                }
                case 's': {
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    DateTimeUtils.zeroPad(stringBuilder, dt2.getSecond(), n2 == 1 ? 1 : 2);
                    continue block25;
                }
                case 'F': 
                case 'f': {
                    if (c2 == 'F') {
                        bl2 = true;
                    }
                    if ((n2 = DateTimeUtils.countRepeat(format, i2, c2)) > 7) {
                        throw new FormatException("Invalid Format String");
                    }
                    int n4 = (int)(dt2.getTicks() % 10000000L / (long)Math.pow(10.0, 7 - n2));
                    int n5 = stringBuilder.length();
                    DateTimeUtils.zeroPad(stringBuilder, n4, n2);
                    if (!bl2) continue block25;
                    while (stringBuilder.length() > n5 && stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                        stringBuilder.setLength(stringBuilder.length() - 1);
                    }
                    if (n4 != 0 || n5 <= 0 || stringBuilder.charAt(n5 - 1) != '.') continue block25;
                    stringBuilder.setLength(stringBuilder.length() - 1);
                    continue block25;
                }
                case 'a': {
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    String string = dt2.getHour() < 12 ? dfi.getAMDesignator() : dfi.getPMDesignator();
                    stringBuilder.append(string);
                    continue block25;
                }
                case 't': {
                    String string;
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    String string2 = string = dt2.getHour() < 12 ? dfi.getAMDesignator() : dfi.getPMDesignator();
                    if (n2 == 1) {
                        if (string.length() < 1) continue block25;
                        stringBuilder.append(string.charAt(0));
                        continue block25;
                    }
                    stringBuilder.append(string);
                    continue block25;
                }
                case 'z': {
                    TimeSpan timeSpan;
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    TimeSpan timeSpan2 = timeSpan = utc_offset != null ? utc_offset : TimeZoneExtensions.getUtcOffset(TimeZone.getDefault(), dt2.Clone()).Clone();
                    if (timeSpan.getTicks() >= 0L) {
                        stringBuilder.append('+');
                    } else {
                        stringBuilder.append('-');
                    }
                    switch (n2) {
                        case 1: {
                            stringBuilder.append(Math.abs(timeSpan.getHours()));
                            continue block25;
                        }
                        case 2: {
                            stringBuilder.append(Int32Extensions.toString(Math.abs(timeSpan.getHours()), "D2"));
                            continue block25;
                        }
                    }
                    stringBuilder.append(Int32Extensions.toString(Math.abs(timeSpan.getHours()), "D2"));
                    stringBuilder.append(':');
                    stringBuilder.append(Int32Extensions.toString(Math.abs(timeSpan.getMinutes()), "D2"));
                    continue block25;
                }
                case 'K': {
                    TimeSpan timeSpan;
                    n2 = 1;
                    if (utc_offset != null || dt2.getKind() == 2L) {
                        TimeSpan timeSpan3 = timeSpan = utc_offset != null ? utc_offset : TimeZoneExtensions.getUtcOffset(TimeZone.getDefault(), dt2.Clone()).Clone();
                        if (timeSpan.getTicks() >= 0L) {
                            stringBuilder.append('+');
                        } else {
                            stringBuilder.append('-');
                        }
                        stringBuilder.append(Int32Extensions.toString(Math.abs(timeSpan.getHours()), "D2"));
                        stringBuilder.append(':');
                        stringBuilder.append(Int32Extensions.toString(Math.abs(timeSpan.getMinutes()), "D2"));
                        continue block25;
                    }
                    if (dt2.getKind() != 1L) continue block25;
                    stringBuilder.append('Z');
                    continue block25;
                }
                case 'd': {
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    if (n2 <= 2) {
                        DateTimeUtils.zeroPad(stringBuilder, dfi.getCalendar().getDayOfMonth(dt2.Clone()), n2 == 1 ? 1 : 2);
                        continue block25;
                    }
                    if (n2 == 3) {
                        stringBuilder.append(dfi.getAbbreviatedDayName(dfi.getCalendar().getDayOfWeek(dt2.Clone())));
                        continue block25;
                    }
                    stringBuilder.append(dfi.getDayName(dfi.getCalendar().getDayOfWeek(dt2.Clone())));
                    continue block25;
                }
                case 'E': {
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    if (n2 != 4) continue block25;
                    stringBuilder.append(dfi.getDayName(dfi.getCalendar().getDayOfWeek(dt2.Clone())));
                    continue block25;
                }
                case 'M': {
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    int n6 = dfi.getCalendar().getMonth(dt2.Clone());
                    if (n2 <= 2) {
                        DateTimeUtils.zeroPad(stringBuilder, n6, n2);
                        continue block25;
                    }
                    if (n2 == 3) {
                        stringBuilder.append(dfi.getAbbreviatedMonthName(n6));
                        continue block25;
                    }
                    if (DateTimeUtils.a(format) && dfi.getMonthGenitiveNames() != null && dfi.getMonthGenitiveNames().length > 0) {
                        stringBuilder.append(dfi.getMonthGenitiveNames()[n6 - 1]);
                        continue block25;
                    }
                    stringBuilder.append(dfi.getMonthName(n6));
                    continue block25;
                }
                case 'y': {
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    if (n2 <= 2) {
                        DateTimeUtils.zeroPad(stringBuilder, dfi.getCalendar().getYear(dt2.Clone()) % 100, n2);
                        continue block25;
                    }
                    DateTimeUtils.zeroPad(stringBuilder, dfi.getCalendar().getYear(dt2.Clone()), n2);
                    continue block25;
                }
                case 'g': {
                    n2 = DateTimeUtils.countRepeat(format, i2, c2);
                    stringBuilder.append(dfi.getEraName(dfi.getCalendar().getEra(dt2.Clone())));
                    continue block25;
                }
                case ':': {
                    stringBuilder.append(dfi.getTimeSeparator());
                    n2 = 1;
                    continue block25;
                }
                case '/': {
                    stringBuilder.append(dfi.getDateSeparator());
                    n2 = 1;
                    continue block25;
                }
                case '\"': 
                case '\'': {
                    n2 = DateTimeUtils.parseQuotedString(format, i2, stringBuilder);
                    continue block25;
                }
                case '%': {
                    if (i2 >= format.length() - 1) {
                        throw new FormatException("% at end of date time string");
                    }
                    if (format.charAt(i2 + 1) == '%') {
                        throw new FormatException("%% in date string");
                    }
                    n2 = 1;
                    continue block25;
                }
                case '\\': {
                    if (i2 >= format.length() - 1) {
                        throw new FormatException("\\ at end of date time string");
                    }
                    stringBuilder.append(format.charAt(i2 + 1));
                    n2 = 2;
                    continue block25;
                }
                default: {
                    stringBuilder.append(c2);
                    n2 = 1;
                }
            }
        }
        return stringBuilder.toString();
    }

    private static boolean a(String string) {
        boolean bl2 = false;
        for (char c2 : StringExtensions.toCharArray(string)) {
            if (c2 == '\'') {
                boolean bl3 = bl2 = !bl2;
            }
            if (c2 != 'd' || bl2) continue;
            return true;
        }
        return false;
    }
}

